/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.recipes;

import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.items.BoosterItem;
import com.majruszsaccessories.items.CardItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_8566;

public record RecipeData(List<AccessoryHolder> accessories, List<BoosterItem> boosters, List<CardItem> cards) {
    public RecipeData() {
        this(new ArrayList<AccessoryHolder>(), new ArrayList<BoosterItem>(), new ArrayList<CardItem>());
    }

    public static RecipeData build(class_8566 container) {
        RecipeData data = new RecipeData();
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 itemStack = container.method_5438(i);
            if (itemStack.method_7960()) continue;
            if (itemStack.method_7909() instanceof AccessoryItem) {
                data.accessories.add(AccessoryHolder.getOrCreate(itemStack));
                continue;
            }
            class_1792 class_17922 = itemStack.method_7909();
            if (class_17922 instanceof BoosterItem) {
                BoosterItem booster = (BoosterItem)class_17922;
                data.boosters.add(booster);
                continue;
            }
            class_17922 = itemStack.method_7909();
            if (class_17922 instanceof CardItem) {
                CardItem card = (CardItem)class_17922;
                data.cards.add(card);
                continue;
            }
            return new RecipeData();
        }
        data.accessories.sort((left, right) -> Float.compare(left.getBaseBonus(), right.getBaseBonus()));
        return data;
    }

    public AccessoryHolder getAccessory(int idx) {
        return this.accessories.get(idx);
    }

    public BoosterItem getBooster(int idx) {
        return this.boosters.get(idx);
    }

    public CardItem getCard(int idx) {
        return this.cards.get(idx);
    }

    float getStandardDeviation() {
        float average = this.getAverageBonus();
        double variation = this.accessories.stream().map(AccessoryHolder::getBaseBonus).reduce(Float.valueOf(0.0f), (sum, bonus) -> Float.valueOf(sum.floatValue() + (float)Math.pow(bonus.floatValue() - average, 2.0))).floatValue() / (float)this.accessories.size();
        return (float)Math.sqrt(variation);
    }

    float getMaxBonus() {
        return this.accessories.get(this.accessories.size() - 1).getBaseBonus();
    }

    float getMinBonus() {
        return this.accessories.get(0).getBaseBonus();
    }

    float getAverageBonus() {
        return this.accessories.stream().map(AccessoryHolder::getBaseBonus).reduce(Float.valueOf(0.0f), Float::sum).floatValue() / (float)this.accessories.size();
    }

    int getAccessoriesSize() {
        return this.accessories.size();
    }

    int getBoostersSize() {
        return this.boosters.size();
    }

    int getCardsSize() {
        return this.cards.size();
    }

    boolean hasAccessory(AccessoryItem item) {
        return this.accessories.stream().anyMatch(holder -> ((Object)((Object)holder.getItem())).equals((Object)item));
    }

    boolean hasIdenticalItemTypes() {
        return this.accessories.stream().allMatch(holder -> ((Object)((Object)holder.getItem())).equals((Object)this.accessories.get(0).getItem()));
    }
}

