/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.tooltip;

import com.majruszlibrary.math.Range;
import com.majruszlibrary.text.TextHelper;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.config.RangedInteger;
import com.majruszsaccessories.items.BoosterItem;
import com.majruszsaccessories.tooltip.ITooltipProvider;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_5250;

public class TooltipHelper {
    public static final class_124 DEFAULT_FORMAT = class_124.field_1080;

    public static class_5250 asFormula(Object base, Object bonus) {
        return TextHelper.translatable((String)"majruszsaccessories.items.formula", (Object[])new Object[]{base, bonus}).method_27692(DEFAULT_FORMAT);
    }

    public static class_5250 asRange(Object base, Object bonus) {
        return TextHelper.translatable((String)"majruszsaccessories.items.range", (Object[])new Object[]{base, bonus}).method_27692(DEFAULT_FORMAT);
    }

    public static IntegerTooltip asValue(RangedInteger value) {
        return new IntegerTooltip(value);
    }

    public static FloatTooltip asValue(RangedFloat value) {
        return new FloatTooltip(value);
    }

    public static IntegerTooltip asFixedValue(RangedInteger value) {
        return new IntegerTooltip(value).bonusMultiplier(0);
    }

    public static FloatTooltip asFixedValue(RangedFloat value) {
        return new FloatTooltip(value).bonusMultiplier(0.0f);
    }

    public static PercentTooltip asPercent(RangedFloat value) {
        return new PercentTooltip(value);
    }

    public static PercentTooltip asFixedPercent(RangedFloat value) {
        return new PercentTooltip(value).bonusMultiplier(0.0f);
    }

    public static ITooltipProvider asBooster(final Supplier<BoosterItem> item) {
        return new ITooltipProvider(){

            @Override
            public class_5250 getTooltip(AccessoryHolder holder) {
                if (!holder.isValid()) {
                    return TextHelper.literal((String)"");
                }
                return TextHelper.translatable((String)"majruszsaccessories.items.booster_name", (Object[])new Object[]{((BoosterItem)((Object)item.get())).method_7848()}).method_27692(((BoosterItem)((Object)item.get())).method_7862((class_1799)class_1799.field_8037).field_8908).method_27693(" ");
            }
        };
    }

    public static ITooltipProvider asItem(final Supplier<class_1792> item) {
        return new ITooltipProvider(){

            @Override
            public class_5250 getTooltip(AccessoryHolder holder) {
                return ((class_1792)item.get()).method_7848().method_27661();
            }
        };
    }

    public static ITooltipProvider asEntity(final Supplier<class_1299<?>> type) {
        return new ITooltipProvider(){

            @Override
            public class_5250 getTooltip(AccessoryHolder holder) {
                return ((class_1299)type.get()).method_5897().method_27661();
            }
        };
    }

    public static class IntegerTooltip
    implements ITooltipProvider {
        private final RangedInteger value;
        private int bonusMultiplier = 1;
        private int valueMultiplier = 1;

        IntegerTooltip(RangedInteger value) {
            this.value = value;
        }

        @Override
        public class_5250 getTooltip(AccessoryHolder holder) {
            int bonusValue = holder.apply(this.value, this.bonusMultiplier) * this.valueMultiplier;
            int defaultValue = this.value.get() * this.valueMultiplier;
            int diff = bonusValue - defaultValue;
            return TextHelper.literal((String)"%d".formatted(bonusValue)).method_27692(diff != 0 ? holder.getBonusFormatting() : DEFAULT_FORMAT);
        }

        @Override
        public class_5250 getDetailedTooltip(AccessoryHolder holder) {
            int defaultValue;
            int bonusValue = holder.apply(this.value, this.bonusMultiplier) * this.valueMultiplier;
            int diff = bonusValue - (defaultValue = this.value.get() * this.valueMultiplier);
            class_5250 component = diff != 0 ? TextHelper.literal((String)TextHelper.signed((int)diff)) : TextHelper.literal((String)"");
            return TooltipHelper.asFormula(defaultValue, component.method_27692(holder.getBonusFormatting()));
        }

        @Override
        public class_5250 getRangeTooltip(AccessoryHolder holder) {
            Range<Float> range = holder.getClampedBonusRange();
            int minValue = AccessoryHolder.apply(((Float)range.from).floatValue(), this.value, this.bonusMultiplier) * this.valueMultiplier;
            int maxValue = AccessoryHolder.apply(((Float)range.to).floatValue(), this.value, this.bonusMultiplier) * this.valueMultiplier;
            int defaultValue = this.value.get() * this.valueMultiplier;
            class_5250 minComponent = TextHelper.literal((String)("" + minValue)).method_27692(minValue != defaultValue ? AccessoryHolder.getBonusFormatting(((Float)range.from).floatValue()) : DEFAULT_FORMAT);
            if (minValue != maxValue) {
                class_5250 maxComponent = TextHelper.literal((String)("" + maxValue)).method_27692(maxValue != defaultValue ? AccessoryHolder.getBonusFormatting(((Float)range.to).floatValue()) : DEFAULT_FORMAT);
                return TooltipHelper.asRange(minComponent, maxComponent);
            }
            return minComponent;
        }

        public IntegerTooltip bonusMultiplier(int multiplier) {
            this.bonusMultiplier = multiplier;
            return this;
        }

        public IntegerTooltip valueMultiplier(int multiplier) {
            this.valueMultiplier = multiplier;
            return this;
        }
    }

    public static class FloatTooltip
    implements ITooltipProvider {
        private final RangedFloat value;
        private float bonusMultiplier = 1.0f;
        private float valueMultiplier = 1.0f;
        private float diffMargin = 0.001f;
        private boolean isScaledOnlyOnDetailed = false;
        private int scale = 2;

        FloatTooltip(RangedFloat value) {
            this.value = value;
        }

        @Override
        public class_5250 getTooltip(AccessoryHolder holder) {
            int scale = this.isScaledOnlyOnDetailed ? 0 : this.scale;
            float bonusValue = FloatTooltip.getScaled(holder.apply(this.value, this.bonusMultiplier) * this.valueMultiplier, scale);
            float defaultValue = FloatTooltip.getScaled(this.value.get() * this.valueMultiplier, scale);
            float diff = bonusValue - defaultValue;
            return TextHelper.literal((String)TextHelper.minPrecision((float)bonusValue, (int)scale)).method_27692(Math.abs(diff) >= this.diffMargin ? holder.getBonusFormatting() : DEFAULT_FORMAT);
        }

        @Override
        public class_5250 getDetailedTooltip(AccessoryHolder holder) {
            float defaultValue;
            float bonusValue = holder.apply(this.value, this.bonusMultiplier) * this.valueMultiplier;
            float diff = bonusValue - (defaultValue = this.value.get() * this.valueMultiplier);
            class_5250 component = Math.abs(diff) >= this.diffMargin ? TextHelper.literal((String)TextHelper.signed((float)diff, (int)this.scale)) : TextHelper.literal((String)"");
            return TooltipHelper.asFormula(TextHelper.minPrecision((float)defaultValue, (int)this.scale), component.method_27692(holder.getBonusFormatting()));
        }

        @Override
        public class_5250 getRangeTooltip(AccessoryHolder holder) {
            Range<Float> range = holder.getClampedBonusRange();
            int scale = this.isScaledOnlyOnDetailed ? 0 : this.scale;
            float minValue = FloatTooltip.getScaled(AccessoryHolder.apply(((Float)range.from).floatValue(), this.value, this.bonusMultiplier) * this.valueMultiplier, scale);
            float maxValue = FloatTooltip.getScaled(AccessoryHolder.apply(((Float)range.to).floatValue(), this.value, this.bonusMultiplier) * this.valueMultiplier, scale);
            float defaultValue = FloatTooltip.getScaled(this.value.get() * this.valueMultiplier, scale);
            class_5250 minComponent = TextHelper.literal((String)TextHelper.minPrecision((float)minValue, (int)this.scale)).method_27692(Math.abs(minValue - defaultValue) >= this.diffMargin ? AccessoryHolder.getBonusFormatting(((Float)range.from).floatValue()) : DEFAULT_FORMAT);
            if (Math.abs(maxValue - minValue) >= this.diffMargin) {
                class_5250 maxComponent = TextHelper.literal((String)TextHelper.minPrecision((float)maxValue, (int)this.scale)).method_27692(Math.abs(maxValue - defaultValue) >= this.diffMargin ? AccessoryHolder.getBonusFormatting(((Float)range.to).floatValue()) : DEFAULT_FORMAT);
                return TooltipHelper.asRange(minComponent, maxComponent);
            }
            return minComponent;
        }

        public FloatTooltip bonusMultiplier(float multiplier) {
            this.bonusMultiplier = multiplier;
            return this;
        }

        public FloatTooltip valueMultiplier(float multiplier) {
            this.valueMultiplier = multiplier;
            return this;
        }

        public FloatTooltip scale(int scale) {
            this.scale = scale;
            this.diffMargin = (float)Math.pow(0.1, scale + 2);
            return this;
        }

        public FloatTooltip scaleOnlyOnDetailed() {
            this.isScaledOnlyOnDetailed = true;
            return this;
        }

        private static float getScaled(float value, int scale) {
            return new BigDecimal(value).setScale(scale, RoundingMode.HALF_EVEN).stripTrailingZeros().floatValue();
        }
    }

    public static class PercentTooltip
    implements ITooltipProvider {
        private final RangedFloat value;
        private float bonusMultiplier = 1.0f;
        private float valueMultiplier = 1.0f;
        private float diffMargin = 0.001f;
        private int scale = 2;

        PercentTooltip(RangedFloat value) {
            this.value = value;
        }

        @Override
        public class_5250 getTooltip(AccessoryHolder holder) {
            float bonusValue = holder.apply(this.value, this.bonusMultiplier) * this.valueMultiplier;
            float defaultValue = this.value.get() * this.valueMultiplier;
            float diff = bonusValue - defaultValue;
            return TextHelper.literal((String)TextHelper.percent((float)bonusValue, (int)this.scale)).method_27692(Math.abs(diff) >= this.diffMargin ? holder.getBonusFormatting() : DEFAULT_FORMAT);
        }

        @Override
        public class_5250 getDetailedTooltip(AccessoryHolder holder) {
            float defaultValue;
            float bonusValue = holder.apply(this.value, this.bonusMultiplier) * this.valueMultiplier;
            float diff = bonusValue - (defaultValue = this.value.get() * this.valueMultiplier);
            class_5250 component = Math.abs(diff) >= this.diffMargin ? TextHelper.literal((String)TextHelper.signedPercent((float)diff, (int)this.scale)) : TextHelper.literal((String)"");
            return TooltipHelper.asFormula(TextHelper.percent((float)defaultValue, (int)this.scale), component.method_27692(holder.getBonusFormatting()));
        }

        @Override
        public class_5250 getRangeTooltip(AccessoryHolder holder) {
            Range<Float> range = holder.getClampedBonusRange();
            float minValue = AccessoryHolder.apply(((Float)range.from).floatValue(), this.value, this.bonusMultiplier) * this.valueMultiplier;
            float maxValue = AccessoryHolder.apply(((Float)range.to).floatValue(), this.value, this.bonusMultiplier) * this.valueMultiplier;
            class_5250 minComponent = TextHelper.literal((String)TextHelper.percent((float)minValue, (int)this.scale)).method_27692(AccessoryHolder.getBonusFormatting(((Float)range.from).floatValue()));
            if (Math.abs(maxValue - minValue) >= this.diffMargin) {
                return TooltipHelper.asRange(minComponent, TextHelper.literal((String)TextHelper.percent((float)maxValue, (int)this.scale)).method_27692(AccessoryHolder.getBonusFormatting(((Float)range.to).floatValue())));
            }
            return minComponent;
        }

        public PercentTooltip bonusMultiplier(float multiplier) {
            this.bonusMultiplier = multiplier;
            return this;
        }

        public PercentTooltip valueMultiplier(float multiplier) {
            this.valueMultiplier = multiplier;
            return this;
        }

        public PercentTooltip scale(int scale) {
            this.scale = scale;
            this.diffMargin = (float)Math.pow(0.1, scale + 2);
            return this;
        }
    }
}

