/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.emi.trinkets.api.LivingEntityTrinketComponent;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.data.EntitySlotLoader;
import dev.emi.trinkets.data.SlotLoader;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2287;
import net.minecraft.class_2290;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_7157;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrinketsMain
implements ModInitializer,
EntityComponentInitializer {
    public static final String MOD_ID = "trinkets";
    public static final Logger LOGGER = LogManager.getLogger();

    public void onInitialize() {
        ResourceManagerHelper resourceManagerHelper = ResourceManagerHelper.get((class_3264)class_3264.field_14190);
        resourceManagerHelper.registerReloadListener((IdentifiableResourceReloadListener)SlotLoader.INSTANCE);
        resourceManagerHelper.registerReloadListener((IdentifiableResourceReloadListener)EntitySlotLoader.SERVER);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, serverResourceManager, success) -> EntitySlotLoader.SERVER.sync(server.method_3760().method_14571()));
        CommandRegistrationCallback.EVENT.register((dispatcher, registry, env) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)MOD_ID).requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"slot", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"offset", (ArgumentType)IntegerArgumentType.integer((int)0)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"stack", (ArgumentType)class_2287.method_9776((class_7157)registry)).executes(context -> {
            try {
                return TrinketsMain.trinketsCommand((CommandContext<class_2168>)context, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        })).then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            int amount = (Integer)context.getArgument("amount", Integer.class);
            return TrinketsMain.trinketsCommand((CommandContext<class_2168>)context, amount);
        })))))))));
    }

    private static int trinketsCommand(CommandContext<class_2168> context, int amount) {
        try {
            String group = (String)context.getArgument("group", String.class);
            String slot = (String)context.getArgument("slot", String.class);
            int offset = (Integer)context.getArgument("offset", Integer.class);
            class_2290 stack = (class_2290)context.getArgument("stack", class_2290.class);
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player != null) {
                TrinketComponent comp = TrinketsApi.getTrinketComponent((class_1309)player).get();
                SlotGroup slotGroup = comp.getGroups().getOrDefault(group, null);
                if (slotGroup != null) {
                    SlotType slotType = slotGroup.getSlots().getOrDefault(slot, null);
                    if (slotType != null) {
                        if (offset >= 0 && offset < slotType.getAmount()) {
                            comp.getInventory().get(group).get(slot).method_5447(offset, stack.method_9781(amount, true));
                            return 1;
                        }
                        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)(offset + " offset does not exist for slot")));
                    } else {
                        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)(slot + " does not exist")));
                    }
                } else {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)(group + " does not exist")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerFor(class_1309.class, TrinketsApi.TRINKET_COMPONENT, LivingEntityTrinketComponent::new);
        registry.registerForPlayers(TrinketsApi.TRINKET_COMPONENT, LivingEntityTrinketComponent::new, RespawnCopyStrategy.ALWAYS_COPY);
    }
}

