/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.stl_backport.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2540;
import net.minecraft.class_5253;
import net.minecraft.class_5699;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ColorParticleOption
implements class_2394 {
    private final class_2396<ColorParticleOption> type;
    private final Vector3f color;

    public ColorParticleOption(class_2396<ColorParticleOption> type, Vector3f color) {
        this.type = type;
        this.color = color;
    }

    public float getRed() {
        return this.color.x;
    }

    public float getGreen() {
        return this.color.y;
    }

    public float getBlue() {
        return this.color.z;
    }

    @NotNull
    public class_2396<ColorParticleOption> method_10295() {
        return this.type;
    }

    public void method_10294(class_2540 buffer) {
        buffer.writeFloat(this.color.x);
        buffer.writeFloat(this.color.y);
        buffer.writeFloat(this.color.z);
    }

    @NotNull
    public String method_10293() {
        return String.format("ColorParticleOption{type=%s, color=%s}", this.type, this.color);
    }

    public static ColorParticleOption create(class_2396<ColorParticleOption> type, int color) {
        return new ColorParticleOption(type, new Vector3f((float)class_5253.class_5254.method_27765((int)color) / 255.0f, (float)class_5253.class_5254.method_27766((int)color) / 255.0f, (float)class_5253.class_5254.method_27767((int)color) / 255.0f));
    }

    public static ColorParticleOption create(class_2396<ColorParticleOption> type, float red, float green, float blue) {
        return new ColorParticleOption(type, new Vector3f(red, green, blue));
    }

    public static Codec<ColorParticleOption> codec(class_2396<ColorParticleOption> type) {
        return RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_40723.fieldOf("color").forGetter(dustParticleOptions -> dustParticleOptions.color)).apply((Applicative)instance, vector3f -> new ColorParticleOption(type, (Vector3f)vector3f)));
    }

    public static class_2394.class_2395<ColorParticleOption> deserializer() {
        return new class_2394.class_2395<ColorParticleOption>(){

            @NotNull
            public ColorParticleOption fromCommand(class_2396<ColorParticleOption> particleType, StringReader reader) throws CommandSyntaxException {
                Vector3f vector3f = this.readVector3f(reader);
                return new ColorParticleOption(particleType, vector3f);
            }

            @NotNull
            public ColorParticleOption fromNetwork(class_2396<ColorParticleOption> particleType, class_2540 buffer) {
                return new ColorParticleOption(particleType, this.readVector3f(buffer));
            }

            private Vector3f readVector3f(StringReader reader) throws CommandSyntaxException {
                float x = reader.readFloat();
                reader.expect(' ');
                float y = reader.readFloat();
                reader.expect(' ');
                float z = reader.readFloat();
                return new Vector3f(x, y, z);
            }

            private Vector3f readVector3f(class_2540 buffer) {
                float x = buffer.readFloat();
                float y = buffer.readFloat();
                float z = buffer.readFloat();
                return new Vector3f(x, y, z);
            }
        };
    }
}

