/*
 * Decompiled with CFR 0.152.
 */
package net.puzzlemc.splashscreen;

import eu.midnightdust.lib.util.MidnightColorUtil;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_1084;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_4491;
import net.puzzlemc.core.PuzzleCore;
import net.puzzlemc.core.config.PuzzleConfig;
import org.jetbrains.annotations.NotNull;

public class PuzzleSplashScreen {
    public static final class_2960 LOGO = new class_2960("minecraft", "textures/gui/title/mojangstudios.png");
    public static final class_2960 BACKGROUND = new class_2960("minecraft", "puzzle/splash_background.png");
    public static File CONFIG_PATH = new File(String.valueOf(PlatformFunctions.getConfigDirectory().resolve(".puzzle_cache")));
    public static Path LOGO_TEXTURE = Paths.get(String.valueOf(CONFIG_PATH) + "/mojangstudios.png", new String[0]);
    public static Path BACKGROUND_TEXTURE = Paths.get(String.valueOf(CONFIG_PATH) + "/splash_background.png", new String[0]);
    private static class_310 client = class_310.method_1551();
    private static boolean keepBackground = false;
    public static class_4491 CUSTOM_LOGO_PIPELINE;

    public static void init() {
        if (!CONFIG_PATH.exists() && CONFIG_PATH.mkdir() && class_156.method_668().equals((Object)class_156.class_158.field_1133)) {
            try {
                Files.setAttribute(CONFIG_PATH.toPath(), "dos:hidden", true, new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void resetColors() {
        PuzzleConfig.backgroundColor = 15675965;
        PuzzleConfig.progressBarColor = 0xFFFFFF;
        PuzzleConfig.progressBarBackgroundColor = 15675965;
        PuzzleConfig.progressFrameColor = 0xFFFFFF;
        PuzzleConfig.disableBlend = false;
        PuzzleConfig.customBlendFunction = new ArrayList<String>();
        PuzzleConfig.hasCustomSplashScreen = false;
    }

    public static class DynamicLogoTexture
    extends class_1049 {
        public DynamicLogoTexture() {
            super(LOGO);
        }

        @NotNull
        public class_1049.class_4006 method_18153(class_3300 resourceManager) {
            class_1049.class_4006 class_40062;
            FileInputStream input = new FileInputStream(String.valueOf(LOGO_TEXTURE));
            try {
                class_40062 = new class_1049.class_4006(new class_1084(true, true), class_1011.method_4309((InputStream)input));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    PuzzleCore.LOGGER.error("Encountered an error during logo loading: ", (Throwable)e);
                    return class_1049.class_4006.method_18156((class_3300)resourceManager, (class_2960)LOGO);
                }
            }
            ((InputStream)input).close();
            return class_40062;
        }
    }

    public static class LogoTexture
    extends class_1049 {
        public LogoTexture(class_2960 logo) {
            super(logo);
        }

        @NotNull
        public class_1049.class_4006 method_18153(class_3300 resourceManager) {
            class_1049.class_4006 class_40062;
            block8: {
                class_310 client = class_310.method_1551();
                class_3268 defaultResourcePack = client.method_45573();
                InputStream input = (InputStream)Objects.requireNonNull(defaultResourcePack.method_14405(class_3264.field_14188, LOGO)).get();
                try {
                    class_40062 = new class_1049.class_4006(new class_1084(true, true), class_1011.method_4309((InputStream)input));
                    if (input == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        return new class_1049.class_4006(ex);
                    }
                }
                input.close();
            }
            return class_40062;
        }
    }

    public static class ReloadListener
    implements class_4013 {
        public static final ReloadListener INSTANCE = new ReloadListener();

        private ReloadListener() {
        }

        public void method_14491(class_3300 manager) {
            client = class_310.method_1551();
            if (PuzzleConfig.resourcepackSplashScreen) {
                PuzzleSplashScreen.resetColors();
                client.method_1531().method_4616(LOGO, (class_1044)new LogoTexture(LOGO));
                client.method_1531().method_4616(BACKGROUND, (class_1044)new LogoTexture(BACKGROUND));
                manager.method_14488("optifine", path -> path.method_12832().contains("color.properties")).forEach((id, resource) -> {
                    try (InputStream stream = resource.method_14482();){
                        Properties properties = new Properties();
                        properties.load(stream);
                        if (properties.get("screen.loading") != null) {
                            PuzzleConfig.backgroundColor = MidnightColorUtil.hex2Rgb((String)properties.get("screen.loading").toString()).getRGB();
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                        if (properties.get("screen.loading.bar") != null) {
                            PuzzleConfig.progressBarBackgroundColor = MidnightColorUtil.hex2Rgb((String)properties.get("screen.loading.bar").toString()).getRGB();
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                        if (properties.get("screen.loading.progress") != null) {
                            PuzzleConfig.progressBarColor = MidnightColorUtil.hex2Rgb((String)properties.get("screen.loading.progress").toString()).getRGB();
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                        if (properties.get("screen.loading.outline") != null) {
                            PuzzleConfig.progressFrameColor = MidnightColorUtil.hex2Rgb((String)properties.get("screen.loading.outline").toString()).getRGB();
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                        if (properties.get("screen.loading.blend") != null) {
                            PuzzleConfig.disableBlend = properties.get("screen.loading.blend").toString().equals("off");
                            PuzzleConfig.customBlendFunction = new ArrayList<String>(Arrays.stream(properties.get("screen.loading.blend").toString().split(" ")).toList());
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                    }
                    catch (Exception e) {
                        PuzzleCore.LOGGER.error("Error occurred while loading color.properties {}", (Object)id.toString(), (Object)e);
                    }
                });
                AtomicInteger logoCount = new AtomicInteger();
                manager.method_14488("textures", path -> path.method_12832().contains("mojangstudios.png")).forEach((id, resource) -> {
                    try (InputStream stream = resource.method_14482();){
                        Files.copy(stream, LOGO_TEXTURE, StandardCopyOption.REPLACE_EXISTING);
                        client.method_1531().method_4616(LOGO, (class_1044)new DynamicLogoTexture());
                        if (logoCount.get() > 0) {
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                        logoCount.getAndIncrement();
                    }
                    catch (Exception e) {
                        PuzzleCore.LOGGER.error("Error occurred while loading custom minecraft logo {}", (Object)id.toString(), (Object)e);
                    }
                });
                manager.method_14488("puzzle", path -> path.method_12832().contains("splash_background.png")).forEach((id, resource) -> {
                    try (InputStream stream = resource.method_14482();){
                        Files.copy(stream, BACKGROUND_TEXTURE, StandardCopyOption.REPLACE_EXISTING);
                        FileInputStream input = new FileInputStream(String.valueOf(BACKGROUND_TEXTURE));
                        client.method_1531().method_4616(BACKGROUND, (class_1044)new class_1043(class_1011.method_4309((InputStream)input)));
                        keepBackground = true;
                        PuzzleConfig.hasCustomSplashScreen = true;
                    }
                    catch (Exception e) {
                        PuzzleCore.LOGGER.error("Error occurred while loading custom splash background {}", (Object)id.toString(), (Object)e);
                    }
                });
                if (!keepBackground) {
                    try {
                        Files.delete(BACKGROUND_TEXTURE);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                keepBackground = false;
                PuzzleConfig.write((String)"puzzle");
            }
        }
    }
}

