/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.handler.IItemHandlerModifiable;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.sorter.InvWrapper;
import com.tiviacz.travelersbackpack.inventory.sorter.SortSelector;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class ContainerSorter {
    public static final int SORT_BACKPACK = 0;
    public static final int QUICK_STACK = 1;
    public static final int TRANSFER_TO_BACKPACK = 2;
    public static final int TRANSFER_TO_PLAYER = 3;

    public static void selectSort(BackpackWrapper backpackWrapper, class_1657 player, int button, boolean shiftPressed) {
        if (button == 0) {
            ContainerSorter.sortBackpack(backpackWrapper, player, backpackWrapper.getSortType(), shiftPressed);
        } else if (button == 1) {
            ContainerSorter.quickStackToBackpackNoSort(backpackWrapper, player, shiftPressed);
        } else if (button == 2) {
            ContainerSorter.transferToBackpackNoSort(backpackWrapper, player, shiftPressed);
        } else if (button == 3) {
            ContainerSorter.transferToPlayer(backpackWrapper, player);
        }
    }

    public static void sortBackpack(BackpackWrapper backpackWrapper, class_1657 player, SortSelector.SortType type, boolean shiftPressed) {
        if (shiftPressed) {
            backpackWrapper.setNextSortType();
        } else {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            CustomWrapper storage = new CustomWrapper(backpackWrapper, backpackWrapper.getStorage());
            for (int i = 0; i < storage.getSlots(); ++i) {
                ContainerSorter.addStackWithMerge(stacks, backpackWrapper.getUnsortableSlots().contains(i) ? class_1799.field_8037 : storage.getStackInSlot(i));
            }
            if (!stacks.isEmpty()) {
                stacks.sort(SortSelector.getSortTypeComparator(stacks, type));
            }
            if (stacks.isEmpty()) {
                return;
            }
            int j = 0;
            for (int i = 0; i < storage.getSlots(); ++i) {
                if (backpackWrapper.getUnsortableSlots().contains(i)) continue;
                storage.setStackInSlot(i, j < stacks.size() ? (class_1799)stacks.get(j) : class_1799.field_8037);
                ++j;
            }
        }
    }

    public static void quickStackToBackpackNoSort(BackpackWrapper backpackWrapper, class_1657 player, boolean shiftPressed) {
        int i;
        InvWrapper playerStacks = new InvWrapper((class_1263)player.method_31548());
        int n = i = shiftPressed ? 0 : 9;
        while (i < 36) {
            class_1799 playerStack = playerStacks.getStackInSlot(i);
            if (!(playerStack.method_7960() || backpackWrapper.getScreenID() == 1 && i == (backpackWrapper.getBackpackSlotIndex() == -1 ? player.method_31548().field_7545 : backpackWrapper.getBackpackSlotIndex()))) {
                CustomWrapper storage = new CustomWrapper(backpackWrapper, backpackWrapper.getStorage());
                boolean hasExistingStack = IntStream.range(0, storage.getSlots()).mapToObj(storage::getStackInSlot).filter(existing -> !existing.method_7960()).anyMatch(existing -> existing.method_7909() == playerStack.method_7909());
                if (hasExistingStack) {
                    class_1799 ext = playerStacks.extractItem(i, Integer.MAX_VALUE, false);
                    for (int j = 0; j < storage.getSlots() && !(ext = storage.insertItem(j, ext, false)).method_7960(); ++j) {
                    }
                    if (!ext.method_7960()) {
                        playerStacks.insertItem(i, ext, false);
                    }
                }
            }
            ++i;
        }
    }

    public static void transferToBackpackNoSort(BackpackWrapper backpackWrapper, class_1657 player, boolean shiftPressed) {
        int i;
        InvWrapper playerStacks;
        block10: {
            playerStacks = new InvWrapper((class_1263)player.method_31548());
            if (backpackWrapper.getMemorySlots().isEmpty()) break block10;
            for (Pair<Integer, Pair<class_1799, Boolean>> pair : backpackWrapper.getMemorySlots()) {
                int i2;
                int n = i2 = shiftPressed ? 0 : 9;
                while (i2 < 36) {
                    block11: {
                        class_1799 ext;
                        block12: {
                            class_1799 playerStack = playerStacks.getStackInSlot(i2);
                            if (playerStack.method_7960() || backpackWrapper.getScreenID() == 1 && i2 == (backpackWrapper.getBackpackSlotIndex() == -1 ? player.method_31548().field_7545 : backpackWrapper.getBackpackSlotIndex())) break block11;
                            CustomWrapper wrapper = new CustomWrapper(backpackWrapper, backpackWrapper.getStorage());
                            class_1799 extSimulate = playerStacks.extractItem(i2, Integer.MAX_VALUE, true);
                            ext = class_1799.field_8037;
                            if (!((Boolean)((Pair)pair.getSecond()).getSecond() != false ? ItemStackUtils.isSameItemSameTags((class_1799)((Pair)pair.getSecond()).getFirst(), extSimulate) : class_1799.method_7984((class_1799)((class_1799)((Pair)pair.getSecond()).getFirst()), (class_1799)extSimulate))) break block12;
                            ext = playerStacks.extractItem(i2, Integer.MAX_VALUE, false);
                            ext = wrapper.insertItem((Integer)pair.getFirst(), ext, false);
                            if (ext.method_7960()) break block11;
                        }
                        if (!ext.method_7960()) {
                            playerStacks.insertItem(i2, ext, false);
                        }
                    }
                    ++i2;
                }
            }
        }
        int n = i = shiftPressed ? 0 : 9;
        while (i < 36) {
            class_1799 playerStack = playerStacks.getStackInSlot(i);
            if (!(playerStack.method_7960() || backpackWrapper.getScreenID() == 1 && i == (backpackWrapper.getBackpackSlotIndex() == -1 ? player.method_31548().field_7545 : backpackWrapper.getBackpackSlotIndex()))) {
                CustomWrapper wrapper = new CustomWrapper(backpackWrapper, backpackWrapper.getStorage());
                class_1799 ext = playerStacks.extractItem(i, Integer.MAX_VALUE, false);
                for (int j = 0; j < wrapper.getSlots() && !(ext = wrapper.insertItem(j, ext, false)).method_7960(); ++j) {
                }
                if (!ext.method_7960()) {
                    playerStacks.insertItem(i, ext, false);
                }
            }
            ++i;
        }
    }

    public static void transferToPlayer(BackpackWrapper backpackWrapper, class_1657 player) {
        InvWrapper playerStacks = new InvWrapper((class_1263)player.method_31548());
        CustomWrapper wrapper = new CustomWrapper(backpackWrapper, backpackWrapper.getStorage());
        for (int i = 0; i < wrapper.getSlots(); ++i) {
            class_1799 stack = wrapper.getStackInSlot(i);
            if (stack.method_7960()) continue;
            class_1799 ext = wrapper.extractItem(i, Integer.MAX_VALUE, false);
            for (int j = 9; j < 36 && !(ext = playerStacks.insertItem(j, ext, false)).method_7960(); ++j) {
            }
            if (ext.method_7960()) continue;
            wrapper.isTransferToPlayer = true;
            wrapper.insertItem(i, ext, false);
            wrapper.isTransferToPlayer = false;
        }
    }

    private static void addStackWithMerge(List<class_1799> stacks, class_1799 newStack) {
        if (newStack.method_7960()) {
            return;
        }
        if (newStack.method_7946() && newStack.method_7947() != newStack.method_7914()) {
            for (int j = stacks.size() - 1; j >= 0; --j) {
                class_1799 oldStack = stacks.get(j);
                if (!ContainerSorter.canMergeItems(newStack, oldStack)) continue;
                ContainerSorter.combineStacks(newStack, oldStack);
                if (!oldStack.method_7960() && oldStack.method_7947() != 0) continue;
                stacks.remove(j);
            }
        }
        stacks.add(newStack);
    }

    private static void combineStacks(class_1799 stack, class_1799 stack2) {
        if (stack.method_7914() >= stack.method_7947() + stack2.method_7947()) {
            stack.method_7933(stack2.method_7947());
            stack2.method_7939(0);
        }
        int maxInsertAmount = Math.min(stack.method_7914() - stack.method_7947(), stack2.method_7947());
        stack.method_7933(maxInsertAmount);
        stack2.method_7934(maxInsertAmount);
    }

    private static boolean canMergeItems(class_1799 stack1, class_1799 stack2) {
        if (!stack1.method_7946() || !stack2.method_7946()) {
            return false;
        }
        if (stack1.method_7947() == stack2.method_7914() || stack2.method_7947() == stack2.method_7914()) {
            return false;
        }
        if (stack1.method_7909() != stack2.method_7909()) {
            return false;
        }
        if (stack1.method_7919() != stack2.method_7919()) {
            return false;
        }
        return class_1799.method_31577((class_1799)stack1, (class_1799)stack2);
    }

    public static class CustomWrapper
    implements IItemHandlerModifiable {
        public final BackpackWrapper wrapper;
        public final ItemStackHandler parent;
        public boolean isTransferToPlayer;

        public CustomWrapper(BackpackWrapper wrapper, ItemStackHandler parent) {
            this(wrapper, parent, false);
        }

        public CustomWrapper(BackpackWrapper wrapper, ItemStackHandler parent, boolean isTransferToPlayer) {
            this.wrapper = wrapper;
            this.parent = parent;
            this.isTransferToPlayer = isTransferToPlayer;
        }

        @Override
        public void setStackInSlot(int slot, @NotNull class_1799 stack) {
            this.parent.setStackInSlot(slot, stack);
        }

        @Override
        public int getSlots() {
            return this.parent.getSlots();
        }

        @Override
        @NotNull
        public class_1799 getStackInSlot(int slot) {
            return this.parent.getStackInSlot(slot);
        }

        @Override
        @NotNull
        public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate) {
            if (this.wrapper.getMemorizedSlot(slot).isPresent()) {
                return this.wrapper.getMemorySlots().stream().noneMatch(pair -> {
                    if (((Boolean)((Pair)pair.getSecond()).getSecond()).booleanValue()) {
                        return (Integer)pair.getFirst() == slot && ItemStackUtils.isSameItemSameTags((class_1799)((Pair)pair.getSecond()).getFirst(), stack);
                    }
                    return (Integer)pair.getFirst() == slot && class_1799.method_7984((class_1799)((class_1799)((Pair)pair.getSecond()).getFirst()), (class_1799)stack);
                }) ? stack : this.parent.insertItem(slot, stack, simulate);
            }
            return this.wrapper.getUnsortableSlots().contains(slot) ? stack : this.parent.insertItem(slot, stack, simulate);
        }

        @Override
        @NotNull
        public class_1799 extractItem(int slot, int amount, boolean simulate) {
            return this.wrapper.getUnsortableSlots().contains(slot) ? class_1799.field_8037 : this.parent.extractItem(slot, amount, simulate);
        }

        @Override
        public int getSlotLimit(int slot) {
            return this.parent.getSlotLimit(slot);
        }

        @Override
        public boolean isItemValid(int slot, @NotNull class_1799 stack) {
            return this.parent.isItemValid(slot, stack);
        }
    }
}

