/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.config;

import com.simibubi.create.content.kinetics.BlockStressValues;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.config.ui.BaseConfigScreen;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_437;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import rbasamoyai.createbigcannons.config.CBCCfgClient;
import rbasamoyai.createbigcannons.config.CBCCfgCommon;
import rbasamoyai.createbigcannons.config.CBCCfgServer;
import rbasamoyai.createbigcannons.config.CBCConfigBase;

public class CBCConfigs {
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    public static CBCCfgClient CLIENT;
    public static CBCCfgCommon COMMON;
    public static CBCCfgServer SERVER;

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends CBCConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            CBCConfigBase config = (CBCConfigBase)((Object)((Object)factory.get()));
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        CBCConfigBase config = (CBCConfigBase)((Object)specPair.getLeft());
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)((Object)config);
    }

    public static void registerConfigs(BiConsumer<ModConfig.Type, ForgeConfigSpec> cons) {
        CLIENT = CBCConfigs.register(CBCCfgClient::new, ModConfig.Type.CLIENT);
        COMMON = CBCConfigs.register(CBCCfgCommon::new, ModConfig.Type.COMMON);
        SERVER = CBCConfigs.register(CBCCfgServer::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) {
            cons.accept(pair.getKey(), pair.getValue().specification);
        }
        BlockStressValues.registerProvider((String)"createbigcannons", (BlockStressValues.IStressValueProvider)CBCConfigs.SERVER.kinetics.stress);
    }

    public static void onLoad(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onLoad();
        }
    }

    public static void onReload(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onReload();
        }
    }

    public static BaseConfigScreen createConfigScreen(class_437 parent) {
        BaseConfigScreen.setDefaultActionFor((String)"createbigcannons", base -> base.withSpecs(CBCConfigs.CLIENT.specification, null, CBCConfigs.SERVER.specification).withTitles("Client Settings", "", "Server Settings"));
        return new BaseConfigScreen(parent, "createbigcannons");
    }
}

