/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.balm.api.item.BalmItems;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import us.mikebartosh.minecraft.ExtendedWaystones;

public class CustomWaystoneBlocks {
    private static final String[] WOOD_TYPES = new String[]{"acacia", "birch", "cherry", "dark_oak", "jungle", "mangrove", "oak", "spruce"};
    private static final String[] WOOD_VARIANTS = new String[]{"", "_framed"};
    public static final Map<String, class_2248> WAYSTONE_BLOCKS = new HashMap<String, class_2248>();
    public static class_2248 acaciaWaystone;
    public static class_2248 birchWaystone;
    public static class_2248 cherryWaystone;
    public static class_2248 darkOakWaystone;
    public static class_2248 jungleWaystone;
    public static class_2248 mangroveWaystone;
    public static class_2248 oakWaystone;
    public static class_2248 spruceWaystone;
    public static class_2248 acaciaFramedWaystone;
    public static class_2248 birchFramedWaystone;
    public static class_2248 cherryFramedWaystone;
    public static class_2248 darkOakFramedWaystone;
    public static class_2248 jungleFramedWaystone;
    public static class_2248 mangroveFramedWaystone;
    public static class_2248 oakFramedWaystone;
    public static class_2248 spruceFramedWaystone;

    public static void initialize(BalmBlocks blocks) {
        for (String variant : WOOD_VARIANTS) {
            for (String woodType : WOOD_TYPES) {
                String blockName = woodType + variant + "_waystone";
                blocks.register(identifier -> {
                    WaystoneBlock waystone = new WaystoneBlock(CustomWaystoneBlocks.defaultSettings());
                    WAYSTONE_BLOCKS.put(blockName, (class_2248)waystone);
                    CustomWaystoneBlocks.setStaticField(woodType, variant, (class_2248)waystone);
                    return waystone;
                }, BalmItems::blockItem, CustomWaystoneBlocks.id(blockName));
            }
        }
    }

    private static class_2960 id(String name) {
        return new class_2960("extended-waystones", name);
    }

    private static void setStaticField(String woodType, String variant, class_2248 block) {
        String fieldName = woodType.replace("_", "").toLowerCase() + (variant.isEmpty() ? "" : variant.replace("_", "").toLowerCase()) + "Waystone";
        try {
            Field field = CustomWaystoneBlocks.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(null, block);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            ExtendedWaystones.LOGGER.error("Field doesn't exist or is inaccessible: {}", (Object)e.getMessage());
        }
    }

    private static class_4970.class_2251 defaultSettings() {
        return class_4970.class_2251.method_9637().method_9626(class_2498.field_11547).method_9632(2.0f).method_50013();
    }
}

