/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.EquipAction;
import io.wispforest.accessories.api.EquipCheck;
import io.wispforest.accessories.api.EquipmentChecking;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AccessoriesCapability {
    @Nullable
    public static AccessoriesCapability get(@NotNull class_1309 livingEntity) {
        return livingEntity.accessoriesCapability();
    }

    public static Optional<AccessoriesCapability> getOptionally(@NotNull class_1309 livingEntity) {
        return Optional.ofNullable(AccessoriesCapability.get(livingEntity));
    }

    public class_1309 entity();

    public AccessoriesHolder getHolder();

    public void reset(boolean var1);

    public Map<String, AccessoriesContainer> getContainers();

    @Nullable
    default public AccessoriesContainer getContainer(SlotType slotType) {
        return this.getContainers().get(slotType.name());
    }

    @Nullable
    default public AccessoriesContainer getContainer(SlotTypeReference reference) {
        return this.getContainers().get(reference.slotName());
    }

    public void updateContainers();

    @Deprecated
    @Nullable
    default public Pair<SlotReference, List<class_1799>> equipAccessory(class_1799 stack) {
        return this.equipAccessory(stack, false);
    }

    @Deprecated
    default public Pair<SlotReference, List<class_1799>> equipAccessory(class_1799 stack, boolean allowSwapping) {
        class_1799 stackCopy = stack.method_7972();
        Pair<SlotReference, Optional<class_1799>> result = this.attemptToEquipAccessory(stackCopy, allowSwapping);
        if (result == null) {
            return null;
        }
        ArrayList<class_1799> returnStacks = new ArrayList<class_1799>();
        if (!stackCopy.method_7960()) {
            returnStacks.add(stackCopy);
        }
        ((Optional)result.second()).ifPresent(returnStacks::add);
        return Pair.of((Object)((SlotReference)result.first()), returnStacks);
    }

    @Nullable
    default public SlotReference attemptToEquipAccessory(class_1799 stack) {
        Pair<SlotReference, Optional<class_1799>> result = this.attemptToEquipAccessory(stack, false);
        return result != null ? (SlotReference)result.first() : null;
    }

    @Nullable
    default public Pair<SlotReference, Optional<class_1799>> attemptToEquipAccessory(class_1799 stack, boolean allowSwapping) {
        Pair<SlotReference, EquipAction> result = this.canEquipAccessory(stack, allowSwapping, (slotStack, slotReference) -> true);
        return result != null ? Pair.of((Object)((SlotReference)result.first()), ((EquipAction)result.second()).equipStack(stack)) : null;
    }

    default public Pair<SlotReference, EquipAction> canEquipAccessory(class_1799 stack, boolean allowSwapping) {
        return this.canEquipAccessory(stack, allowSwapping, (slotStack, slotReference) -> true);
    }

    @Nullable
    public Pair<SlotReference, EquipAction> canEquipAccessory(class_1799 var1, boolean var2, EquipCheck var3);

    default public boolean isEquipped(class_1792 item) {
        return this.isEquipped(item, EquipmentChecking.ACCESSORIES_ONLY);
    }

    default public boolean isEquipped(class_1792 item, EquipmentChecking check) {
        return this.isEquipped((class_1799 stack) -> stack.method_7909() == item, check);
    }

    default public boolean isEquipped(Predicate<class_1799> predicate) {
        return this.isEquipped(predicate, EquipmentChecking.ACCESSORIES_ONLY);
    }

    default public boolean isEquipped(Predicate<class_1799> predicate, EquipmentChecking check) {
        return this.getFirstEquipped(predicate, check) != null;
    }

    default public boolean isAnotherEquipped(SlotReference slotReference, class_1792 item) {
        return this.isAnotherEquipped(slotReference, (class_1799 stack) -> stack.method_7909().equals(item));
    }

    default public boolean isAnotherEquipped(SlotReference slotReference, Predicate<class_1799> predicate) {
        List<SlotEntryReference> equippedStacks = this.getEquipped(predicate);
        if (equippedStacks.size() > 2) {
            for (SlotEntryReference equippedStack : equippedStacks) {
                if (equippedStack.reference().equals(slotReference)) continue;
                return true;
            }
        } else if (equippedStacks.size() == 1) {
            return !equippedStacks.get(0).reference().equals(slotReference);
        }
        return false;
    }

    @Nullable
    default public SlotEntryReference getFirstEquipped(class_1792 item) {
        return this.getFirstEquipped(item, EquipmentChecking.ACCESSORIES_ONLY);
    }

    @Nullable
    default public SlotEntryReference getFirstEquipped(class_1792 item, EquipmentChecking check) {
        return this.getFirstEquipped((class_1799 stack) -> stack.method_7909() == item, check);
    }

    @Nullable
    default public SlotEntryReference getFirstEquipped(Predicate<class_1799> predicate) {
        return this.getFirstEquipped(predicate, EquipmentChecking.ACCESSORIES_ONLY);
    }

    @Nullable
    public SlotEntryReference getFirstEquipped(Predicate<class_1799> var1, EquipmentChecking var2);

    default public List<SlotEntryReference> getEquipped(class_1792 item) {
        return this.getEquipped((class_1799 stack) -> stack.method_7909() == item);
    }

    public List<SlotEntryReference> getEquipped(Predicate<class_1799> var1);

    default public List<SlotEntryReference> getAllEquipped() {
        return this.getAllEquipped(true);
    }

    public List<SlotEntryReference> getAllEquipped(boolean var1);

    public void addTransientSlotModifiers(Multimap<String, class_1322> var1);

    public void addPersistentSlotModifiers(Multimap<String, class_1322> var1);

    public void removeSlotModifiers(Multimap<String, class_1322> var1);

    public Multimap<String, class_1322> getSlotModifiers();

    public void clearSlotModifiers();

    public void clearCachedSlotModifiers();

    @Deprecated
    @Nullable
    default public Pair<SlotReference, List<class_1799>> equipAccessory(class_1799 stack, boolean allowSwapping, TriFunction<Accessory, class_1799, SlotReference, Boolean> additionalCheck) {
        return this.equipAccessory(stack, allowSwapping);
    }
}

