/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.ReplaceableJsonResourceReloadListener;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.SlotGroupImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public class SlotGroupLoader
extends ReplaceableJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final SlotGroupLoader INSTANCE = new SlotGroupLoader();
    private Map<String, SlotGroup> server = new HashMap<String, SlotGroup>();
    private Map<String, SlotGroup> client = new HashMap<String, SlotGroup>();

    protected SlotGroupLoader() {
        super(GSON, LOGGER, "accessories/group");
    }

    public static List<SlotGroup> getGroups(class_1937 level) {
        return INSTANCE.getGroups(level.method_8608(), true);
    }

    public static List<SlotGroup> getGroups(class_1937 level, boolean filterUniqueGroups) {
        return INSTANCE.getGroups(level.method_8608(), filterUniqueGroups);
    }

    public static Optional<SlotGroup> getGroup(class_1937 level, String group) {
        return Optional.ofNullable(INSTANCE.getGroup(level.method_8608(), group));
    }

    @ApiStatus.Internal
    public final Map<String, SlotGroup> getGroupMap(boolean isClientSide) {
        return isClientSide ? this.client : this.server;
    }

    public final List<SlotGroup> getGroups(boolean isClientSide, boolean filterUniqueGroups) {
        Collection<SlotGroup> groups = this.getGroupMap(isClientSide).values();
        if (filterUniqueGroups) {
            groups = groups.stream().filter(group -> !UniqueSlotHandling.isUniqueGroup(group.name(), isClientSide)).toList();
        }
        return List.copyOf(groups);
    }

    public final SlotGroup getGroup(boolean isClientSide, String group) {
        return this.getGroupMap(isClientSide).get(group);
    }

    public final Optional<SlotGroup> findGroup(boolean isClientSide, String slot) {
        for (SlotGroup entry : this.getGroups(isClientSide, false)) {
            if (!entry.slots().contains(slot)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    public final SlotGroup getOrDefaultGroup(boolean isClientSide, String slot) {
        Map<String, SlotGroup> groups = this.getGroupMap(isClientSide);
        for (SlotGroup entry : groups.values()) {
            if (!entry.slots().contains(slot)) continue;
            return entry;
        }
        return groups.get("any");
    }

    @ApiStatus.Internal
    public final void setGroups(Map<String, SlotGroup> groups) {
        this.client = ImmutableMap.copyOf(groups);
    }

    protected void apply(Map<class_2960, JsonObject> data, class_3300 resourceManager, class_3695 profiler) {
        HashMap<String, SlotGroupBuilder> slotGroups = new HashMap<String, SlotGroupBuilder>();
        slotGroups.put("unsorted", new SlotGroupBuilder("unsorted").order(30));
        HashMap<String, SlotType> allSlots = new HashMap<String, SlotType>(SlotTypeLoader.INSTANCE.getSlotTypes(false));
        for (Map.Entry<class_2960, JsonObject> entry : data.entrySet()) {
            String icon;
            class_2960 location = entry.getKey();
            JsonObject jsonObject = entry.getValue();
            if (!AccessoriesInternals.isValidOnConditions(jsonObject, this.directory, location, null)) continue;
            String[] pathParts = location.method_12832().split("/");
            Object groupName = pathParts[pathParts.length - 1];
            Object namespace = pathParts.length > 1 ? pathParts[0] + ":" : "";
            boolean isShared = ((String)namespace).isBlank();
            if (!isShared) {
                groupName = (String)namespace + ":" + (String)groupName;
            }
            SlotGroupBuilder group = slotGroups.computeIfAbsent((String)groupName, SlotGroupBuilder::new);
            if (isShared) {
                JsonArray slotElements = this.safeHelper(class_3518::method_15261, jsonObject, "slots", new JsonArray(), location);
                this.decodeJsonArray(slotElements, "slot", location, JsonElement::getAsString, s -> {
                    for (Map.Entry builderEntry : slotGroups.entrySet()) {
                        if (!((SlotGroupBuilder)builderEntry.getValue()).slots.contains(s)) continue;
                        LOGGER.error("Unable to assign a give slot [{}] to the group [{}] as it already exists within the group [{}]", new Object[]{s, group, builderEntry.getKey()});
                        return;
                    }
                    SlotType slotType = (SlotType)allSlots.remove(s);
                    if (slotType == null) {
                        LOGGER.warn("SlotType added to a given group without being in the main map for slots! [Name: {}]", (Object)slotType.name());
                    } else {
                        group.addSlot((String)s);
                    }
                });
                group.order(this.safeHelper(class_3518::method_15260, jsonObject, "order", 100, location));
            }
            if ((icon = this.safeHelper(class_3518::method_15265, jsonObject, "icon", location)) == null) continue;
            class_2960 iconLocation = class_2960.method_12829((String)icon);
            if (iconLocation != null) {
                group.icon(iconLocation);
                continue;
            }
            LOGGER.warn("A given SlotGroup was found to have a invalid Icon Location. [Location: {}]", (Object)location);
        }
        HashSet<String> remainSlots = new HashSet<String>();
        for (SlotType value : allSlots.values()) {
            String slotName = value.name();
            if (!UniqueSlotHandling.isUniqueSlot(slotName)) {
                remainSlots.add(slotName);
                continue;
            }
            String group = slotName.split(":")[0];
            slotGroups.computeIfAbsent(group, SlotGroupBuilder::new).order(5).addSlot(slotName);
            UniqueSlotHandling.addGroup(group);
        }
        ((SlotGroupBuilder)slotGroups.get("unsorted")).addSlots(remainSlots);
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        slotGroups.forEach((s, builder) -> tempMap.put(s, (Object)builder.build()));
        this.server = builder2.build();
    }

    public static class SlotGroupBuilder {
        private final String name;
        private Integer order = null;
        private final Set<String> slots = new LinkedHashSet<String>();
        private class_2960 iconLocation = SlotGroup.UNKNOWN;

        public SlotGroupBuilder(String name) {
            this.name = name;
        }

        public SlotGroupBuilder order(Integer value) {
            this.order = value;
            return this;
        }

        public SlotGroupBuilder addSlot(String value) {
            this.slots.add(value);
            return this;
        }

        public SlotGroupBuilder addSlots(Collection<String> values) {
            this.slots.addAll(values);
            return this;
        }

        public SlotGroupBuilder icon(class_2960 location) {
            this.iconLocation = location;
            return this;
        }

        public SlotGroup build() {
            return new SlotGroupImpl(this.name, Optional.ofNullable(this.order).orElse(0), this.slots, this.iconLocation);
        }
    }
}

