/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.item;

import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LABColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1472;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DyeBottleItem
extends class_1792 {
    public static final String COLOR_TAG = "color";
    protected static final HashBiMap<class_1767, Integer> COLOR_TO_DIFFUSE = Arrays.stream(class_1767.values()).collect(Collectors.toMap(Function.identity(), color -> ColorUtils.pack((float[])color.method_7787()), (color, color2) -> color2, HashBiMap::create));

    public DyeBottleItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static int getColor(class_1799 stack) {
        class_2487 compoundTag = stack.method_7969();
        if (compoundTag != null) {
            return compoundTag.method_10550(COLOR_TAG);
        }
        return 0;
    }

    public static SoftFluidStack toFluidStack(class_1767 color, int amount) {
        class_2487 tag = new class_2487();
        tag.method_10569(COLOR_TAG, DyeBottleItem.getDyeInt(color).intValue());
        return SoftFluidStack.of(ModRegistry.DYE_SOFT_FLUID, (int)amount, (class_2487)tag);
    }

    public static class_1799 fromFluidStack(SoftFluidStack stack) {
        class_1799 item = new class_1799((class_1935)ModRegistry.DYE_BOTTLE_ITEM.get());
        item.method_7948().method_10569(COLOR_TAG, stack.getTag().method_10550(COLOR_TAG));
        return item;
    }

    public static int mixColor(int oldColor, int newColor, int oldAmount, int newAmount) {
        return new RGBColor(oldColor).asHCL().mixWith(new RGBColor(newColor).asHCL(), (float)newAmount / (float)(oldAmount + newAmount)).asRGB().toInt();
    }

    @NotNull
    private static Integer getDyeInt(class_1767 color) {
        return (Integer)COLOR_TO_DIFFUSE.get((Object)color);
    }

    public static class_1767 getClosestDye(SoftFluidStack stack) {
        return DyeBottleItem.getClosestDye(stack.getTag().method_10550(COLOR_TAG));
    }

    public static class_1767 getClosestDye(class_1799 stack) {
        return DyeBottleItem.getClosestDye(stack.method_7948().method_10550(COLOR_TAG));
    }

    public static class_1767 getClosestDye(int tintColor) {
        LABColor color = new RGBColor(tintColor).asLAB();
        double minDist = Double.MAX_VALUE;
        class_1767 minColor = null;
        for (class_1767 dyeColor : class_1767.values()) {
            LABColor c2 = new RGBColor(DyeBottleItem.getDyeInt(dyeColor).intValue()).asLAB();
            double dist = c2.distTo((BaseColor)color);
            if (!(dist < minDist)) continue;
            minDist = dist;
            minColor = dyeColor;
        }
        return minColor;
    }

    public class_1799 method_7854() {
        class_1799 stack = super.method_7854();
        stack.method_7948().method_10569(COLOR_TAG, DyeBottleItem.getDyeInt(class_1767.field_7964).intValue());
        return stack;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> list, class_1836 isAdvanced) {
        class_2487 tag = stack.method_7948();
        int col = tag.method_10550(COLOR_TAG);
        class_1767 color = (class_1767)COLOR_TO_DIFFUSE.inverse().get((Object)col);
        if (color != null) {
            list.add((class_2561)class_2561.method_43471((String)("item.amendments.dye_bottle." + color.method_7792())).method_27692(class_124.field_1080));
        } else {
            list.add((class_2561)class_2561.method_43469((String)"item.color", (Object[])new Object[]{String.format(Locale.ROOT, "#%06X", col)}).method_27692(class_124.field_1080));
        }
        super.method_7851(stack, level, list, isAdvanced);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 interactionTarget, class_1268 usedHand) {
        if (interactionTarget instanceof class_1472) {
            class_1472 sheep = (class_1472)interactionTarget;
            class_1767 dye = DyeBottleItem.getClosestDye(stack);
            if (sheep.method_5805() && !sheep.method_6629() && sheep.method_6633() != dye) {
                sheep.method_37908().method_43129(player, (class_1297)sheep, class_3417.field_28391, class_3419.field_15248, 1.0f, 1.0f);
                if (!player.method_37908().field_9236) {
                    sheep.method_6631(dye);
                    stack.method_7934(1);
                }
                return class_1269.method_29236((boolean)player.method_37908().field_9236);
            }
        }
        return class_1269.field_5811;
    }
}

