/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.entities.layer;

import com.blackgear.vanillabackport.client.registries.ModModelLayers;
import com.blackgear.vanillabackport.common.level.entities.wolf.ModCrackiness;
import com.blackgear.vanillabackport.common.level.items.WolfArmorItem;
import com.blackgear.vanillabackport.common.registries.ModItems;
import com.blackgear.vanillabackport.core.VanillaBackport;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1493;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_624;

@Environment(value=EnvType.CLIENT)
public class WolfArmorLayer
extends class_3887<class_1493, class_624<class_1493>> {
    private final class_624<class_1493> model;
    private static final Map<ModCrackiness.Level, class_2960> ARMOR_CRACK_LOCATIONS = Map.of(ModCrackiness.Level.LOW, VanillaBackport.vanilla("textures/entity/wolf/wolf_armor_crackiness_low.png"), ModCrackiness.Level.MEDIUM, VanillaBackport.vanilla("textures/entity/wolf/wolf_armor_crackiness_medium.png"), ModCrackiness.Level.HIGH, VanillaBackport.vanilla("textures/entity/wolf/wolf_armor_crackiness_high.png"));

    public WolfArmorLayer(class_3883<class_1493, class_624<class_1493>> renderer, class_5599 models) {
        super(renderer);
        this.model = new class_624(models.method_32072(ModModelLayers.WOLF_ARMOR));
    }

    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, class_1493 wolf, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        class_1799 stack;
        class_1792 class_17922;
        if (wolf.method_6118(class_1304.field_6174).method_31574(ModItems.WOLF_ARMOR.get()) && (class_17922 = (stack = wolf.method_6118(class_1304.field_6174)).method_7909()) instanceof WolfArmorItem) {
            WolfArmorItem armor = (WolfArmorItem)class_17922;
            ((class_624)this.method_17165()).method_17081(this.model);
            this.model.method_17131(wolf, limbSwing, limbSwingAmount, partialTick);
            this.model.method_17133(wolf, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            class_4588 vertices = buffer.getBuffer(class_1921.method_23578((class_2960)armor.getTexture()));
            this.model.method_2828(poseStack, vertices, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            this.maybeRenderColoredLayer(poseStack, buffer, packedLight, stack, armor);
            this.maybeRenderCracks(poseStack, buffer, packedLight, stack);
        }
    }

    private void maybeRenderColoredLayer(class_4587 poseStack, class_4597 buffer, int packedLight, class_1799 stack, WolfArmorItem armor) {
        class_2960 overlay = armor.getOverlayTexture();
        if (overlay == null) {
            return;
        }
        int color = WolfArmorItem.getColorOrDefault(stack, 0);
        if (color == 10511680) {
            return;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        class_4588 vertices = buffer.getBuffer(class_1921.method_23578((class_2960)overlay));
        this.model.method_2828(poseStack, vertices, packedLight, class_4608.field_21444, red, green, blue, 1.0f);
    }

    private void maybeRenderCracks(class_4587 poseStack, class_4597 buffer, int packedLight, class_1799 stack) {
        ModCrackiness.Level level = ModCrackiness.WOLF_ARMOR.byDamage(stack);
        if (level != ModCrackiness.Level.NONE) {
            class_2960 texture = ARMOR_CRACK_LOCATIONS.get((Object)level);
            class_4588 vertices = buffer.getBuffer(class_1921.method_23580((class_2960)texture));
            this.model.method_2828(poseStack, vertices, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static class_5609 createMeshDefinition(class_5605 grow) {
        class_5609 mesh = new class_5609();
        class_5610 root = mesh.method_32111();
        class_5610 head = root.method_32117("head", class_5606.method_32108(), class_5603.method_32090((float)-1.0f, (float)13.5f, (float)-7.0f));
        head.method_32117("real_head", class_5606.method_32108().method_32101(0, 0).method_32098(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, grow).method_32101(16, 14).method_32098(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, grow).method_32101(16, 14).method_32098(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, grow).method_32101(0, 10).method_32098(-0.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, grow), class_5603.field_27701);
        root.method_32117("body", class_5606.method_32108().method_32101(18, 14).method_32098(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, grow), class_5603.method_32091((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        root.method_32117("upper_body", class_5606.method_32108().method_32101(21, 0).method_32098(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, grow), class_5603.method_32091((float)-1.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        class_5606 legShape = class_5606.method_32108().method_32101(0, 18).method_32098(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, grow);
        root.method_32117("right_hind_leg", legShape, class_5603.method_32090((float)-2.5f, (float)16.0f, (float)7.0f));
        root.method_32117("left_hind_leg", legShape, class_5603.method_32090((float)0.5f, (float)16.0f, (float)7.0f));
        root.method_32117("right_front_leg", legShape, class_5603.method_32090((float)-2.5f, (float)16.0f, (float)-4.0f));
        root.method_32117("left_front_leg", legShape, class_5603.method_32090((float)0.5f, (float)16.0f, (float)-4.0f));
        class_5610 tail = root.method_32117("tail", class_5606.method_32108(), class_5603.method_32091((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        tail.method_32117("real_tail", class_5606.method_32108().method_32101(9, 18).method_32098(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, grow), class_5603.field_27701);
        return mesh;
    }
}

