/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.resource;

import com.blackgear.platform.common.resource.RegistryAwareJsonReloadListener;
import com.blackgear.vanillabackport.common.level.entities.wolf.WolfVariant;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.registries.ModBuiltinRegistries;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;

public class WolfVariantReloadListener
extends RegistryAwareJsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String DIRECTORY = "wolf_variant";

    public WolfVariantReloadListener() {
        super(GSON, DIRECTORY);
    }

    public void parse(Map<class_2960, JsonElement> resources, class_5455 registryAccess, class_3300 manager, class_3695 profiler) {
        profiler.method_15396("Loading wolf variants");
        ModBuiltinRegistries.WOLF_VARIANTS.clearDataDrivenEntries();
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        for (Map.Entry<class_2960, JsonElement> entry : resources.entrySet()) {
            class_2960 name = entry.getKey();
            JsonElement element = entry.getValue();
            try {
                WolfVariant.CODEC.parse((DynamicOps)ops, (Object)element).resultOrPartial(error -> VanillaBackport.LOGGER.error("Failed to parse wolf variant {}: {}", (Object)name, error)).ifPresent(variant -> ModBuiltinRegistries.WOLF_VARIANTS.registerDataDriven(name, variant));
            }
            catch (JsonParseException exception) {
                VanillaBackport.LOGGER.error("Failed to parse wolf variant JSON {}: {}", new Object[]{name, exception.getMessage(), exception});
            }
            catch (Exception exception) {
                VanillaBackport.LOGGER.error("Unexpected error processing wolf variant {}", (Object)name, (Object)exception);
            }
        }
        profiler.method_15407();
    }
}

