/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.client;

import com.blackgear.vanillabackport.common.api.bundle.BundleFeatures;
import com.blackgear.vanillabackport.common.api.bundle.BundleSelectionTooltip;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5631;
import net.minecraft.class_5682;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_5682.class})
public class ClientBundleTooltipMixin
implements class_5684 {
    @Unique
    private static final class_2960 BUNDLE_PROGRESS_BAR_TEXTURE = VanillaBackport.vanilla("textures/container/bundle/bundle_progressbar.png");
    @Unique
    private static final class_2960 BUNDLE_SLOT_HIGHLIGHT_BACK_TEXTURE = VanillaBackport.vanilla("textures/container/bundle/slot_highlight_back.png");
    @Unique
    private static final class_2960 BUNDLE_SLOT_HIGHLIGHT_FRONT_TEXTURE = VanillaBackport.vanilla("textures/container/bundle/slot_highlight_front.png");
    @Unique
    private static final class_2960 BUNDLE_SLOT_BACKGROUND_TEXTURE = VanillaBackport.vanilla("textures/container/bundle/slot_background.png");
    @Unique
    private static final class_2561 BUNDLE_EMPTY_DESCRIPTION = class_2561.method_43471((String)"item.minecraft.bundle.empty.description");
    @Unique
    private static final class_2561 BUNDLE_FULL = class_2561.method_43471((String)"item.minecraft.bundle.full");
    @Unique
    private static final class_2561 BUNDLE_EMPTY = class_2561.method_43471((String)"item.minecraft.bundle.empty");
    @Shadow
    @Final
    private class_2371<class_1799> field_27995;
    @Shadow
    @Final
    private int field_28360;
    @Unique
    private int selectedItem;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void vb$init(class_5631 tooltip, CallbackInfo ci) {
        int n;
        if (tooltip instanceof BundleSelectionTooltip) {
            BundleSelectionTooltip selection = (BundleSelectionTooltip)tooltip;
            n = selection.getSelectedItem();
        } else {
            n = -1;
        }
        this.selectedItem = n;
    }

    @Unique
    private int getSelectedItem() {
        return this.selectedItem;
    }

    @Unique
    private boolean hasSelectedItem() {
        return this.selectedItem != -1;
    }

    public int method_32661() {
        return this.field_27995.isEmpty() ? 39 : this.backgroundHeight();
    }

    public int method_32664(class_327 font) {
        return 96;
    }

    @Unique
    private int backgroundHeight() {
        return this.itemGridHeight() + 13 + 8;
    }

    @Unique
    private int itemGridHeight() {
        return this.gridSizeY() * 24;
    }

    @Unique
    private int getContentXOffset(int width) {
        return (width - 96) / 2;
    }

    @Unique
    private int gridSizeY() {
        return class_3532.method_38788((int)this.slotCount(), (int)4);
    }

    @Unique
    private int slotCount() {
        return Math.min(12, this.field_27995.size());
    }

    @Inject(method={"renderImage"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$onRenderImage(class_327 font, int x, int y, class_332 graphics, CallbackInfo ci) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        if (this.field_27995.isEmpty()) {
            this.renderEmptyBundleTooltip(font, x, y, this.method_32664(font), graphics);
        } else {
            this.renderBundleWithItemsTooltip(font, x, y, this.method_32664(font), graphics);
        }
        ci.cancel();
    }

    @Unique
    private void renderEmptyBundleTooltip(class_327 font, int x, int y, int width, class_332 graphics) {
        this.drawEmptyBundleDescriptionText(x + this.getContentXOffset(width), y, font, graphics);
        this.drawProgressBar(x + this.getContentXOffset(width), y + this.getEmptyBundleDescriptionTextHeight(font) + 4, font, graphics);
    }

    @Unique
    private void renderBundleWithItemsTooltip(class_327 font, int x, int y, int width, class_332 graphics) {
        boolean maxDisplay = this.field_27995.size() > 12;
        List<class_1799> stacks = this.getShownItems(BundleFeatures.getItemsToShow(this.field_27995));
        int xOffset = x + this.getContentXOffset(width) + 96;
        int yOffset = y + this.gridSizeY() * 24;
        int index = 1;
        for (int row = 1; row <= this.gridSizeY(); ++row) {
            for (int column = 1; column <= 4; ++column) {
                int slotX = xOffset - column * 24;
                int slotY = yOffset - row * 24;
                if (this.shouldRenderSurplusText(maxDisplay, column, row)) {
                    this.renderCount(slotX, slotY, this.getAmountOfHiddenItems(stacks), font, graphics);
                    continue;
                }
                if (!this.shouldRenderItemSlot(stacks, index)) continue;
                this.renderSlot(index, slotX, slotY, stacks, index, font, graphics);
                ++index;
            }
        }
        this.drawSelectedItemTooltip(font, graphics, x, y, width);
        this.drawProgressBar(x + this.getContentXOffset(width), y + this.itemGridHeight() + 4, font, graphics);
    }

    @Unique
    private List<class_1799> getShownItems(int max) {
        int size = Math.min(this.field_27995.size(), max);
        return this.field_27995.stream().toList().subList(0, size);
    }

    @Unique
    private boolean shouldRenderSurplusText(boolean maxDisplay, int column, int row) {
        return maxDisplay && column * row == 1;
    }

    @Unique
    private boolean shouldRenderItemSlot(List<class_1799> items, int itemIndex) {
        return items.size() >= itemIndex;
    }

    @Unique
    private int getAmountOfHiddenItems(List<class_1799> items) {
        return this.field_27995.stream().skip(items.size()).mapToInt(class_1799::method_7947).sum();
    }

    @Unique
    private void renderSlot(int index, int x, int y, List<class_1799> stacks, int seed, class_327 font, class_332 graphics) {
        int itemIndex = stacks.size() - index;
        boolean hasSelectedItem = itemIndex == this.getSelectedItem();
        class_1799 stack = stacks.get(itemIndex);
        if (hasSelectedItem) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            graphics.method_25291(BUNDLE_SLOT_HIGHLIGHT_BACK_TEXTURE, x, y, 0, 0.0f, 0.0f, 24, 24, 24, 24);
            RenderSystem.disableBlend();
        } else {
            graphics.method_25291(BUNDLE_SLOT_BACKGROUND_TEXTURE, x, y, 0, 0.0f, 0.0f, 24, 24, 24, 24);
        }
        graphics.method_51428(stack, x + 4, y + 4, seed);
        graphics.method_51431(font, stack, x + 4, y + 4);
        if (hasSelectedItem) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            graphics.method_25291(BUNDLE_SLOT_HIGHLIGHT_FRONT_TEXTURE, x, y, 0, 0.0f, 0.0f, 24, 24, 24, 24);
            RenderSystem.disableBlend();
        }
    }

    @Unique
    private void renderCount(int x, int y, int value, class_327 font, class_332 graphics) {
        graphics.method_25300(font, "+" + value, x + 12, y + 10, -1);
    }

    @Unique
    private void drawSelectedItemTooltip(class_327 font, class_332 graphics, int x, int y, int width) {
        if (this.hasSelectedItem()) {
            class_1799 stack = (class_1799)this.field_27995.get(this.getSelectedItem());
            class_5250 component = class_2561.method_43473().method_10852(stack.method_7964()).method_27692(stack.method_7932().field_8908);
            if (stack.method_7938()) {
                component.method_27692(class_124.field_1056);
            }
            int textWidth = font.method_30880(component.method_30937());
            int xOffset = x + width / 2 - 12;
            graphics.method_51438(font, (class_2561)component, xOffset - textWidth / 2, y - 15);
        }
    }

    @Unique
    private void drawProgressBar(int x, int y, class_327 textRenderer, class_332 graphics) {
        boolean isFull;
        int progress = this.getProgressBarFill();
        boolean bl = isFull = this.field_28360 >= 64;
        if (progress > 0) {
            graphics.method_48586(BUNDLE_PROGRESS_BAR_TEXTURE, x + 1, y, progress > 1 ? progress : 2, 13, 2, 6, 6, isFull ? 6 : 0, 12);
        }
        graphics.method_48586(BUNDLE_PROGRESS_BAR_TEXTURE, x, y, 96, 13, 2, 12, 12, 0, 0);
        class_2561 fillText = this.getProgressBarFillText();
        if (fillText != null) {
            graphics.method_27534(textRenderer, fillText, x + 48, y + 3, -1);
        }
    }

    @Unique
    private void drawEmptyBundleDescriptionText(int x, int y, class_327 font, class_332 graphics) {
        graphics.method_51440(font, (class_5348)BUNDLE_EMPTY_DESCRIPTION, x, y, 96, -5592406);
    }

    @Unique
    private int getEmptyBundleDescriptionTextHeight(class_327 font) {
        return font.method_1728((class_5348)BUNDLE_EMPTY_DESCRIPTION, 96).size() * 9;
    }

    @Unique
    private int getProgressBarFill() {
        return class_3532.method_15340((int)(this.field_28360 * 94 / 64), (int)0, (int)94);
    }

    @Unique
    @Nullable
    private class_2561 getProgressBarFillText() {
        if (this.field_27995.isEmpty()) {
            return BUNDLE_EMPTY;
        }
        return this.field_28360 >= 64 ? BUNDLE_FULL : null;
    }
}

