/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util;

import juuxel.adorn.util.Fractions;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B!\b\u0002\u0012\u0006\u0010\u000f\u001a\u00020\u0002\u0012\u0006\u0010\r\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0014"}, d2={"Ljuuxel/adorn/util/MixedFraction;", "", "", "newDenominator", "resizeFraction", "(J)Ljuuxel/adorn/util/MixedFraction;", "", "toString", "()Ljava/lang/String;", "denominator", "J", "getDenominator", "()J", "numerator", "getNumerator", "whole", "getWhole", "<init>", "(JJJ)V", "Companion", "Adorn"})
public final class MixedFraction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long whole;
    private final long numerator;
    private final long denominator;

    private MixedFraction(long whole, long numerator, long denominator) {
        this.whole = whole;
        this.numerator = numerator;
        this.denominator = denominator;
        if (!(this.numerator >= 0L)) {
            boolean $i$a$-require-MixedFraction$42 = false;
            String $i$a$-require-MixedFraction$42 = "Numerator must not be negative, was " + this.numerator;
            throw new IllegalArgumentException($i$a$-require-MixedFraction$42.toString());
        }
        if (!(this.denominator > 0L)) {
            boolean $i$a$-require-MixedFraction$52 = false;
            String $i$a$-require-MixedFraction$52 = "Denominator must not be 0 or negative, was " + this.denominator;
            throw new IllegalArgumentException($i$a$-require-MixedFraction$52.toString());
        }
        if (!(this.denominator != 1L || this.numerator == 0L)) {
            boolean bl = false;
            String string = "Denominator 1 is only allowed when numerator == 0, was " + this.numerator;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final long getWhole() {
        return this.whole;
    }

    public final long getNumerator() {
        return this.numerator;
    }

    public final long getDenominator() {
        return this.denominator;
    }

    @NotNull
    public final MixedFraction resizeFraction(long newDenominator) {
        return this.numerator == 0L ? this : new MixedFraction(this.whole, this.numerator * newDenominator / this.denominator, newDenominator);
    }

    @NotNull
    public String toString() {
        return Fractions.INSTANCE.toString(this.whole, this.numerator, this.denominator);
    }

    public /* synthetic */ MixedFraction(long whole, long numerator, long denominator, DefaultConstructorMarker $constructor_marker) {
        this(whole, numerator, denominator);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ \u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Ljuuxel/adorn/util/MixedFraction$Companion;", "", "", "numerator", "denominator", "Ljuuxel/adorn/util/MixedFraction;", "invoke", "(JJ)Ljuuxel/adorn/util/MixedFraction;", "n", "whole", "(J)Ljuuxel/adorn/util/MixedFraction;", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MixedFraction whole(long n) {
            return new MixedFraction(n, 0L, 1L, null);
        }

        @NotNull
        public final MixedFraction invoke(long numerator, long denominator) {
            if (denominator == 1L) {
                return new MixedFraction(numerator, 0L, 1L, null);
            }
            long realNumerator = numerator % denominator;
            long whole = (numerator - realNumerator) / denominator;
            return new MixedFraction(whole, realNumerator, denominator, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

