/*
 * Decompiled with CFR 0.152.
 */
package net.iamaprogrammer.config.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.iamaprogrammer.WaxItemFrames;
import net.iamaprogrammer.config.core.Config;

public class ConfigUtil {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir();

    public static <C extends Config> boolean save(C config) {
        Path path = Path.of(CONFIG_PATH.toString(), config.fileName() + ".json");
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                ConfigUtil.createFileWithDirectories(path, config);
                return true;
            }
            catch (IOException e) {
                WaxItemFrames.LOGGER.error("Could not create config.");
            }
        } else {
            try {
                ConfigUtil.createFile(path, config);
                return true;
            }
            catch (IOException e) {
                WaxItemFrames.LOGGER.error("Could not create config.");
            }
        }
        return false;
    }

    public static <C extends Config> C load(Path configPath, Class<C> config) {
        try {
            return (C)((Config)GSON.fromJson((Reader)new FileReader(configPath.toString()), config));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static <C extends Config> void createFileWithDirectories(Path path, C config) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        ConfigUtil.createFile(path, config);
    }

    public static <C extends Config> void createFile(Path path, C config) throws IOException {
        String data = GSON.toJson(config != null ? config : "");
        FileWriter fooWriter = new FileWriter(path.toFile(), false);
        fooWriter.write(data);
        fooWriter.close();
    }

    public static <C extends Config> Path findOrCreateConfig(C defaultConfig) {
        Path path = Path.of(CONFIG_PATH.toString(), defaultConfig.fileName() + ".json");
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                ConfigUtil.createFileWithDirectories(path, defaultConfig);
            }
            catch (IOException e) {
                WaxItemFrames.LOGGER.error("Could not create config.");
            }
        }
        return path;
    }
}

