/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.entity;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.item.PhotographItem;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_8111;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhotographEntity
extends class_1530 {
    protected static final class_2940<class_1799> DATA_ITEM = class_2945.method_12791(PhotographEntity.class, (class_2941)class_2943.field_13322);
    protected static final class_2940<Boolean> DATA_GLOWING = class_2945.method_12791(PhotographEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Integer> DATA_ROTATION = class_2945.method_12791(PhotographEntity.class, (class_2941)class_2943.field_13327);

    public PhotographEntity(class_1299<? extends PhotographEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public PhotographEntity(class_1937 level, class_2338 pos, class_2350 facingDirection, class_1799 photographStack) {
        super(Exposure.EntityTypes.PHOTOGRAPH.get(), level, pos);
        this.method_6892(facingDirection);
        this.setItem(photographStack);
    }

    public boolean method_5640(double distance) {
        double d = 16.0;
        return distance < (d *= 64.0 * PhotographEntity.method_5824()) * d;
    }

    protected void method_5693() {
        this.method_5841().method_12784(DATA_ITEM, (Object)class_1799.field_8037);
        this.method_5841().method_12784(DATA_GLOWING, (Object)false);
        this.method_5841().method_12784(DATA_ROTATION, (Object)0);
    }

    public void method_5674(class_2940<?> key) {
        if (key.equals(DATA_ITEM)) {
            this.onItemChanged(this.getItem());
        }
    }

    public void method_31471(@NotNull class_2604 packet) {
        super.method_31471(packet);
        this.method_6892(class_2350.method_10143((int)packet.method_11166()));
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this, this.field_7099.method_10146(), this.method_6896());
    }

    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        if (!this.getItem().method_7960()) {
            tag.method_10566("Item", (class_2520)this.getItem().method_7953(new class_2487()));
            tag.method_10556("Glowing", this.isGlowing());
            tag.method_10567("ItemRotation", (byte)this.getRotation());
        }
        tag.method_10567("Facing", (byte)this.field_7099.method_10146());
        tag.method_10556("Invisible", this.method_5767());
    }

    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        class_2487 compoundtag = tag.method_10562("Item");
        if (!compoundtag.method_33133()) {
            class_1799 itemstack = class_1799.method_7915((class_2487)compoundtag);
            if (itemstack.method_7960()) {
                Exposure.LOGGER.warn("Unable to load item from: {}", (Object)compoundtag);
            }
            this.setItem(itemstack);
            this.setGlowing(tag.method_10577("Glowing"));
            this.setRotation(tag.method_10571("ItemRotation"));
        }
        this.method_6892(class_2350.method_10143((int)tag.method_10571("Facing")));
        this.method_5648(tag.method_10577("Invisible"));
    }

    protected float method_18378(@NotNull class_4050 pose, @NotNull class_4048 dimensions) {
        return 0.0f;
    }

    public int method_6897() {
        return 16;
    }

    public int method_6891() {
        return 16;
    }

    @Nullable
    public class_1799 method_31480() {
        return this.getItem().method_7972();
    }

    public boolean method_6888() {
        if (!this.method_37908().method_17892((class_1297)this)) {
            return false;
        }
        class_2680 blockstate = this.method_37908().method_8320(this.field_7100.method_10093(this.field_7099.method_10153()));
        return (blockstate.method_51367() || this.field_7099.method_10166().method_10179() && class_2312.method_9999((class_2680)blockstate)) && this.method_37908().method_8333((class_1297)this, this.method_5829(), field_7098).isEmpty();
    }

    protected void method_6895() {
        if (this.field_7099 == null) {
            return;
        }
        double value = 0.46875;
        double d1 = (double)this.field_7100.method_10263() + 0.5 - (double)this.field_7099.method_10148() * value;
        double d2 = (double)this.field_7100.method_10264() + 0.5 - (double)this.field_7099.method_10164() * value;
        double d3 = (double)this.field_7100.method_10260() + 0.5 - (double)this.field_7099.method_10165() * value;
        this.method_23327(d1, d2, d3);
        double d4 = this.method_6897();
        double d5 = this.method_6891();
        double d6 = this.method_6897();
        class_2350.class_2351 directionAxis = this.field_7099.method_10166();
        switch (directionAxis) {
            case field_11048: {
                d4 = 1.0;
                break;
            }
            case field_11052: {
                d5 = 1.0;
                break;
            }
            case field_11051: {
                d6 = 1.0;
            }
        }
        this.method_5857(new class_238(d1 - (d4 /= 32.0), d2 - (d5 /= 32.0), d3 - (d6 /= 32.0), d1 + d4, d2 + d5, d3 + d6));
    }

    protected void method_6892(@NotNull class_2350 facingDirection) {
        Validate.notNull((Object)facingDirection);
        this.field_7099 = facingDirection;
        if (facingDirection.method_10166().method_10179()) {
            this.method_36457(0.0f);
            this.method_36456(this.field_7099.method_10161() * 90);
        } else {
            this.method_36457(-90 * facingDirection.method_10171().method_10181());
            this.method_36456(0.0f);
        }
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        this.method_6895();
    }

    public class_1799 getItem() {
        return (class_1799)this.method_5841().method_12789(DATA_ITEM);
    }

    public void setItem(class_1799 photographStack) {
        Preconditions.checkState((boolean)(photographStack.method_7909() instanceof PhotographItem), (Object)(String.valueOf(photographStack) + " is not a PhotographItem"));
        this.method_5841().method_12778(DATA_ITEM, (Object)photographStack);
    }

    protected void onItemChanged(class_1799 itemStack) {
        if (!itemStack.method_7960()) {
            itemStack.method_27320((class_1297)this);
        }
        this.method_6895();
    }

    public boolean isGlowing() {
        return (Boolean)this.method_5841().method_12789(DATA_GLOWING);
    }

    public void setGlowing(boolean glowing) {
        this.method_5841().method_12778(DATA_GLOWING, (Object)glowing);
    }

    public int getRotation() {
        return (Integer)this.method_5841().method_12789(DATA_ROTATION);
    }

    public void setRotation(int rotation) {
        this.method_5841().method_12778(DATA_ROTATION, (Object)(rotation % 4));
    }

    @NotNull
    public class_1269 method_5688(@NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        if (!this.method_5767() && this.canShear(itemInHand)) {
            if (!this.method_37908().field_9236) {
                this.method_5648(true);
                itemInHand.method_7956(1, (class_1309)player, pl -> pl.method_20236(hand));
                this.method_5783(class_3417.field_14975, 1.0f, this.method_37908().method_8409().method_43057() * 0.2f + 0.9f);
            }
            return class_1269.field_5812;
        }
        if (itemInHand.method_31574(class_1802.field_28410)) {
            this.setGlowing(true);
            itemInHand.method_7934(1);
            if (!this.method_37908().field_9236) {
                this.method_43077(class_3417.field_28392);
            }
            return class_1269.field_5812;
        }
        if (!this.method_37908().field_9236) {
            this.method_5783(this.getRotateSound(), 1.0f, this.method_37908().method_8409().method_43057() * 0.2f + 0.9f);
            this.setRotation(this.getRotation() + 1);
        }
        return class_1269.field_5812;
    }

    public boolean canShear(class_1799 stack) {
        return PlatformHelper.canShear(stack);
    }

    public boolean method_5643(@NotNull class_1282 damageSource, float amount) {
        if (this.method_5679(damageSource)) {
            return false;
        }
        if (!this.method_31481() && !this.method_37908().field_9236) {
            if (!this.getItem().method_7960() && !damageSource.method_49708(class_8111.field_42331)) {
                this.method_6889(damageSource.method_5529());
            }
            this.method_5768();
            this.method_5785();
        }
        return true;
    }

    public void method_6889(@Nullable class_1297 breaker) {
        class_1657 player;
        this.method_5783(this.getBreakSound(), 1.0f, this.method_37908().method_8409().method_43057() * 0.3f + 0.6f);
        if (breaker instanceof class_1657 && (player = (class_1657)breaker).method_7337()) {
            return;
        }
        class_1799 itemStack = this.getItem();
        this.method_5775(itemStack);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236 && this.isGlowing() && this.method_37908().method_8409().method_43057() < 0.01f) {
            class_238 bb = this.method_5829();
            class_2382 normal = this.method_5735().method_10163();
            this.method_37908().method_8406((class_2394)class_2398.field_11207, this.method_19538().field_1352 + ((double)this.method_37908().method_8409().method_43057() * (bb.method_17939() * 0.75) - bb.method_17939() * 0.75 / 2.0), this.method_19538().field_1351 + ((double)this.method_37908().method_8409().method_43057() * (bb.method_17940() * 0.75) - bb.method_17940() * 0.75 / 2.0), this.method_19538().field_1350 + ((double)this.method_37908().method_8409().method_43057() * (bb.method_17941() * 0.75) - bb.method_17941() * 0.75 / 2.0), (double)(this.method_37908().method_8409().method_43057() * 0.02f * (float)normal.method_10263()), (double)(this.method_37908().method_8409().method_43057() * 0.02f * (float)normal.method_10264()), (double)(this.method_37908().method_8409().method_43057() * 0.02f * (float)normal.method_10260()));
        }
    }

    public void method_6894() {
        this.method_5783(this.getPlaceSound(), 1.0f, this.method_37908().method_8409().method_43057() * 0.3f + 0.9f);
    }

    public class_3414 getPlaceSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_PLACE.get();
    }

    public class_3414 getBreakSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_BREAK.get();
    }

    public class_3414 getRotateSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get();
    }
}

