/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.entity;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.item.PhotographItem;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5630;
import net.minecraft.class_5712;
import net.minecraft.class_8103;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PhotographFrameEntity
extends class_1530 {
    public static final Logger LOGGER = Exposure.LOGGER;
    protected static final class_2940<Integer> DATA_SIZE = class_2945.method_12791(PhotographFrameEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<class_1799> DATA_FRAME_ITEM = class_2945.method_12791(PhotographFrameEntity.class, (class_2941)class_2943.field_13322);
    protected static final class_2940<class_1799> DATA_ITEM = class_2945.method_12791(PhotographFrameEntity.class, (class_2941)class_2943.field_13322);
    protected static final class_2940<Integer> DATA_ITEM_ROTATION = class_2945.method_12791(PhotographFrameEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Boolean> DATA_GLOWING = class_2945.method_12791(PhotographFrameEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> DATA_STRIPPED = class_2945.method_12791(PhotographFrameEntity.class, (class_2941)class_2943.field_13323);
    protected int size = 0;

    public PhotographFrameEntity(class_1299<? extends PhotographFrameEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public PhotographFrameEntity(class_1937 level, class_2338 pos, class_2350 facingDirection) {
        super(Exposure.EntityTypes.PHOTOGRAPH_FRAME.get(), level, pos);
        this.method_6892(facingDirection);
        this.setItem(class_1799.field_8037);
    }

    public boolean method_5640(double distance) {
        double d = (double)((Integer)Config.Client.PHOTOGRAPH_FRAME_CULLING_DISTANCE.get()).intValue() * PhotographFrameEntity.method_5824();
        return distance < d * d;
    }

    protected void method_5693() {
        this.method_5841().method_12784(DATA_SIZE, (Object)0);
        this.method_5841().method_12784(DATA_FRAME_ITEM, (Object)class_1799.field_8037);
        this.method_5841().method_12784(DATA_ITEM, (Object)class_1799.field_8037);
        this.method_5841().method_12784(DATA_ITEM_ROTATION, (Object)0);
        this.method_5841().method_12784(DATA_STRIPPED, (Object)false);
        this.method_5841().method_12784(DATA_GLOWING, (Object)false);
    }

    public void method_5674(class_2940<?> key) {
        if (key.equals(DATA_ITEM)) {
            this.onItemChanged(this.getItem());
        }
        if (key.equals(DATA_SIZE)) {
            this.size = (Integer)this.method_5841().method_12789(DATA_SIZE);
            this.method_6895();
        }
    }

    public void method_31471(@NotNull class_2604 packet) {
        super.method_31471(packet);
        int packedData = packet.method_11166();
        int size = packedData >> 8 & 0xFF;
        int direction = packedData & 0xFF;
        this.setSize(size);
        this.method_6892(class_2350.method_10143((int)direction));
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        int packedData = this.size << 8 | this.field_7099.method_10146();
        return new class_2604((class_1297)this, packedData, this.method_6896());
    }

    public void method_5652(@NotNull class_2487 tag) {
        class_1799 frameItem;
        super.method_5652(tag);
        class_1799 item = this.getItem();
        if (!item.method_7960()) {
            tag.method_10566("Item", (class_2520)item.method_7953(new class_2487()));
            tag.method_10556("IsGlowing", this.isGlowing());
            tag.method_10567("ItemRotation", (byte)this.getItemRotation());
        }
        if (!(frameItem = this.getFrameItem()).method_7960()) {
            tag.method_10566("FrameItem", (class_2520)frameItem.method_7953(new class_2487()));
        }
        tag.method_10567("Size", (byte)this.getSize());
        tag.method_10567("Facing", (byte)this.field_7099.method_10146());
        tag.method_10556("Stripped", this.isStripped());
        tag.method_10556("Invisible", this.method_5767());
    }

    public void method_5749(@NotNull class_2487 tag) {
        class_2487 itemTag;
        super.method_5749(tag);
        class_2487 frameItemTag = tag.method_10562("FrameItem");
        if (!frameItemTag.method_33133()) {
            class_1799 itemstack = class_1799.method_7915((class_2487)frameItemTag);
            if (itemstack.method_7960()) {
                Exposure.LOGGER.warn("Unable to load frame item from: {}", (Object)frameItemTag);
                itemstack = new class_1799((class_1935)Exposure.Items.PHOTOGRAPH_FRAME.get());
            }
            this.setFrameItem(itemstack);
        }
        if (!(itemTag = tag.method_10562("Item")).method_33133()) {
            class_1799 itemstack = class_1799.method_7915((class_2487)itemTag);
            if (itemstack.method_7960()) {
                Exposure.LOGGER.warn("Unable to load item from: {}", (Object)itemTag);
            }
            this.setItem(itemstack);
            this.setGlowing(tag.method_10577("IsGlowing"));
            this.setItemRotation(tag.method_10571("ItemRotation"));
        }
        this.setSize(tag.method_10571("Size"));
        this.method_6892(class_2350.method_10143((int)tag.method_10571("Facing")));
        this.setStripped(tag.method_10577("Stripped"));
        this.method_5648(tag.method_10577("Invisible"));
    }

    @NotNull
    public class_243 method_43390() {
        return class_243.method_24954((class_2382)this.field_7100);
    }

    protected float method_18378(@NotNull class_4050 pose, @NotNull class_4048 dimensions) {
        return 0.0f;
    }

    public int method_6897() {
        return this.getSize() * 16 + 16;
    }

    public int method_6891() {
        return this.getSize() * 16 + 16;
    }

    @Nullable
    public class_1799 method_31480() {
        class_1799 item = this.getItem();
        if (!item.method_7960()) {
            return item.method_7972();
        }
        return this.getFrameItem().method_7972();
    }

    protected void method_6895() {
        double heightOffset;
        if (this.field_7099 == null) {
            return;
        }
        double x = (double)this.field_7100.method_10263() + 0.5;
        double y = (double)this.field_7100.method_10264() + 0.5;
        double z = (double)this.field_7100.method_10260() + 0.5;
        double widthOffset = this.method_6897() % 32 == 0 ? 0.5 : 0.0;
        double d = heightOffset = this.method_6891() % 32 == 0 ? 0.5 : 0.0;
        if (this.getSize() == 2) {
            widthOffset += 1.0;
            heightOffset += 1.0;
        }
        double hangOffset = 0.46875;
        if (this.method_5735().method_10166().method_10179()) {
            x -= (double)this.method_5735().method_10148() * hangOffset;
            z -= (double)this.method_5735().method_10165() * hangOffset;
            class_2350 direction = this.method_5735().method_10160();
            this.method_23327(x += widthOffset * (double)direction.method_10148(), y += heightOffset, z += widthOffset * (double)direction.method_10165());
            double xSize = this.method_6897();
            double ySize = this.method_6891();
            double zSize = this.method_6897();
            if (this.method_5735().method_10166() == class_2350.class_2351.field_11051) {
                zSize = 1.0;
            } else {
                xSize = 1.0;
            }
            this.method_5857(new class_238(x - (xSize /= 32.0), y - (ySize /= 32.0), z - (zSize /= 32.0), x + xSize, y + ySize, z + zSize));
        } else {
            this.method_23327(x += widthOffset, y -= (double)this.method_5735().method_10164() * hangOffset, z -= heightOffset);
            double xSize = this.method_6897();
            double zSize = this.method_6891();
            this.method_5857(new class_238(x - (xSize /= 32.0), y - 0.03125, z - (zSize /= 32.0), x + xSize, y + 0.03125, z + zSize));
        }
    }

    public boolean method_6888() {
        if (!this.method_37908().method_17892((class_1297)this)) {
            return false;
        }
        int sizeX = Math.max(1, this.method_6897() / 16);
        int sizeY = Math.max(1, this.method_6891() / 16);
        class_2338 baseBlockPos = this.field_7100.method_10093(this.field_7099.method_10153());
        if (this.method_5735().method_10166().method_10179()) {
            class_2350 direction = this.method_5735().method_10160();
            class_2338.class_2339 mPos = new class_2338.class_2339();
            for (int pX = 0; pX < sizeX; ++pX) {
                for (int pY = 0; pY < sizeY; ++pY) {
                    mPos.method_10101((class_2382)baseBlockPos).method_10104(direction, pX).method_10104(class_2350.field_11036, pY);
                    class_2680 blockState = this.method_37908().method_8320((class_2338)mPos);
                    if (blockState.method_51367() || class_2312.method_9999((class_2680)blockState)) continue;
                    return false;
                }
            }
        } else {
            class_2338.class_2339 mPos = new class_2338.class_2339();
            for (int pX = 0; pX < sizeX; ++pX) {
                for (int pY = 0; pY < sizeY; ++pY) {
                    mPos.method_10101((class_2382)baseBlockPos).method_10104(class_2350.field_11043, pX).method_10104(class_2350.field_11034, pY);
                    class_2680 blockState = this.method_37908().method_8320((class_2338)mPos);
                    if (blockState.method_51367() || class_2312.method_9999((class_2680)blockState)) continue;
                    return false;
                }
            }
        }
        return this.method_37908().method_8333((class_1297)this, this.method_5829(), field_7098).isEmpty();
    }

    protected void method_6892(@NotNull class_2350 facingDirection) {
        Validate.notNull((Object)facingDirection);
        this.field_7099 = facingDirection;
        if (facingDirection.method_10166().method_10179()) {
            this.method_36457(0.0f);
            this.method_36456(this.field_7099.method_10161() * 90);
        } else {
            this.method_36457(-90 * facingDirection.method_10171().method_10181());
            this.method_36456(0.0f);
        }
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        this.method_6895();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.method_5841().method_12778(DATA_SIZE, (Object)class_3532.method_15340((int)size, (int)0, (int)2));
        this.size = size;
        this.method_6895();
    }

    public class_1799 getFrameItem() {
        return (class_1799)this.method_5841().method_12789(DATA_FRAME_ITEM);
    }

    public void setFrameItem(class_1799 stack) {
        this.method_5841().method_12778(DATA_FRAME_ITEM, (Object)stack);
    }

    public class_1799 getItem() {
        return (class_1799)this.method_5841().method_12789(DATA_ITEM);
    }

    public void setItem(class_1799 stack) {
        this.method_5841().method_12778(DATA_ITEM, (Object)stack);
    }

    protected void onItemChanged(class_1799 itemStack) {
        if (!itemStack.method_7960()) {
            itemStack.method_27320((class_1297)this);
        }
    }

    public int getItemRotation() {
        return (Integer)this.method_5841().method_12789(DATA_ITEM_ROTATION);
    }

    public void setItemRotation(int rotation) {
        this.method_5841().method_12778(DATA_ITEM_ROTATION, (Object)(rotation % 4));
    }

    public boolean isGlowing() {
        return (Boolean)this.method_5841().method_12789(DATA_GLOWING);
    }

    public void setGlowing(boolean glowing) {
        this.method_5841().method_12778(DATA_GLOWING, (Object)glowing);
    }

    public boolean isStripped() {
        return (Boolean)this.method_5841().method_12789(DATA_STRIPPED);
    }

    public void setStripped(boolean stripped) {
        this.method_5841().method_12778(DATA_STRIPPED, (Object)stripped);
    }

    @NotNull
    public class_1269 method_5688(@NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        if (!this.isStripped()) {
            if (this.canStrip(itemInHand)) {
                if (!this.method_37908().field_9236) {
                    this.setStripped(true);
                    itemInHand.method_7956(1, (class_1309)player, pl -> pl.method_20236(hand));
                    this.method_32875(class_5712.field_28733, (class_1297)player);
                    this.method_5783(class_3417.field_14675, 1.0f, 1.0f);
                }
                return class_1269.field_5812;
            }
        } else if (itemInHand.method_31574(class_1802.field_8600)) {
            if (!this.method_37908().field_9236) {
                this.setStripped(false);
                itemInHand.method_7934(1);
                this.method_32875(class_5712.field_28733, (class_1297)player);
                this.method_6894();
            }
            return class_1269.field_5812;
        }
        if (itemInHand.method_7909() instanceof PhotographItem && this.getItem().method_7960()) {
            this.setItem(itemInHand.method_7972());
            itemInHand.method_7934(1);
            this.method_32875(class_5712.field_28733, (class_1297)player);
            this.method_5783(this.getAddItemSound(), 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (itemInHand.method_31574(class_1802.field_28410) && !this.isGlowing()) {
            this.setGlowing(true);
            itemInHand.method_7934(1);
            if (!this.method_37908().field_9236) {
                this.method_43077(class_3417.field_28392);
                this.method_32875(class_5712.field_28733, (class_1297)player);
            }
            return class_1269.field_5812;
        }
        if (this.method_5767()) {
            if (itemInHand.method_31573(class_3489.field_15537)) {
                this.method_5648(false);
                itemInHand.method_7934(1);
                if (!this.method_37908().field_9236) {
                    this.method_6894();
                    this.method_32875(class_5712.field_28733, (class_1297)player);
                }
                return class_1269.field_5812;
            }
        } else if (itemInHand.method_31574(class_1802.field_8141)) {
            this.method_5648(true);
            itemInHand.method_7934(1);
            if (!this.method_37908().field_9236) {
                this.method_5783(Exposure.SoundEvents.FILTER_INSERT.get(), 0.8f, 1.0f);
                this.method_32875(class_5712.field_28733, (class_1297)player);
            }
            return class_1269.field_5812;
        }
        if (!this.getItem().method_7960()) {
            if (!this.method_37908().field_9236) {
                this.method_5783(this.getRotateSound(), 1.0f, this.method_37908().method_8409().method_43057() * 0.2f + 0.9f);
                this.setItemRotation(this.getItemRotation() + 1);
                this.method_32875(class_5712.field_28733, (class_1297)player);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean canStrip(class_1799 stack) {
        return PlatformHelper.canStrip(stack);
    }

    public boolean method_5643(@NotNull class_1282 damageSource, float amount) {
        if (this.method_5679(damageSource)) {
            return false;
        }
        if (!damageSource.method_48789(class_8103.field_42249) && !this.getItem().method_7960()) {
            if (!this.method_37908().field_9236) {
                this.dropItem(damageSource.method_5529(), false);
                this.method_32875(class_5712.field_28733, damageSource.method_5529());
                this.method_5783(this.getRemoveItemSound(), 1.0f, 1.0f);
            }
            return true;
        }
        return super.method_5643(damageSource, amount);
    }

    public void method_6889(@Nullable class_1297 brokenEntity) {
        this.method_5783(this.getBreakSound(), 1.0f, 1.0f);
        this.dropItem(brokenEntity, true);
        this.method_32875(class_5712.field_28733, brokenEntity);
    }

    protected void dropItem(@Nullable class_1297 entity, boolean dropSelf) {
        float yOffset;
        class_1657 player;
        class_1799 itemStack = this.getItem();
        this.setItem(class_1799.field_8037);
        if (!this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            return;
        }
        if (entity instanceof class_1657 && (player = (class_1657)entity).method_7337()) {
            return;
        }
        float f = yOffset = this.method_5735() == class_2350.field_11033 ? -0.3f : 0.0f;
        if (dropSelf) {
            this.method_5699(this.getFrameItem(), yOffset);
        }
        if (!itemStack.method_7960()) {
            this.method_5699(itemStack.method_7972(), yOffset);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236 && this.isGlowing() && this.method_37908().method_8409().method_43057() < 0.003f) {
            class_238 bb = this.method_5829();
            class_2382 normal = this.method_5735().method_10163();
            this.method_37908().method_8406((class_2394)class_2398.field_11207, this.method_19538().field_1352 + ((double)this.method_37908().method_8409().method_43057() * (bb.method_17939() * 0.75) - bb.method_17939() * 0.75 / 2.0), this.method_19538().field_1351 + ((double)this.method_37908().method_8409().method_43057() * (bb.method_17940() * 0.75) - bb.method_17940() * 0.75 / 2.0), this.method_19538().field_1350 + ((double)this.method_37908().method_8409().method_43057() * (bb.method_17941() * 0.75) - bb.method_17941() * 0.75 / 2.0), (double)(this.method_37908().method_8409().method_43057() * 0.02f * (float)normal.method_10263()), (double)(this.method_37908().method_8409().method_43057() * 0.02f * (float)normal.method_10264()), (double)(this.method_37908().method_8409().method_43057() * 0.02f * (float)normal.method_10260()));
        }
    }

    @NotNull
    public class_5630 method_32318(int slot) {
        if (slot == 0) {
            return new class_5630(){

                @NotNull
                public class_1799 method_32327() {
                    return PhotographFrameEntity.this.getItem();
                }

                public boolean method_32332(class_1799 carried) {
                    PhotographFrameEntity.this.setItem(carried);
                    return true;
                }
            };
        }
        return super.method_32318(slot);
    }

    @NotNull
    protected class_2561 method_23315() {
        if (this.isGlowing()) {
            return class_2561.method_43471((String)"entity.exposure.glow_photograph_frame");
        }
        return super.method_23315();
    }

    public float method_51152() {
        return (float)(this.getSize() + 1) / 2.0f + 0.35f;
    }

    public void method_6894() {
        this.method_5783(this.getPlaceSound(), 1.0f, this.method_37908().method_8409().method_43057() * 0.2f + 0.7f);
    }

    public class_3414 getPlaceSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_FRAME_PLACE.get();
    }

    public class_3414 getBreakSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_FRAME_BREAK.get();
    }

    public class_3414 getAddItemSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_FRAME_ADD_ITEM.get();
    }

    public class_3414 getRemoveItemSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_FRAME_REMOVE_ITEM.get();
    }

    public class_3414 getRotateSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_FRAME_ROTATE_ITEM.get();
    }
}

