/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.camera.infrastructure.FrameData;
import io.github.mortuusars.exposure.gui.ClientGUI;
import io.github.mortuusars.exposure.gui.component.PhotographTooltip;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhotographItem
extends class_1792 {
    public PhotographItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @NotNull
    public Optional<class_5632> method_32346(@NotNull class_1799 stack) {
        return FrameData.hasIdOrTexture(stack) ? Optional.of(new PhotographTooltip(stack)) : Optional.empty();
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 isAdvanced) {
        String photographerName;
        if (stack.method_7969() == null) {
            return;
        }
        int generation = stack.method_7969().method_10550("generation");
        if (generation > 0) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)("item.exposure.photograph.generation." + generation)).method_27692(class_124.field_1080));
        }
        if (!(photographerName = stack.method_7969().method_10558("Photographer")).isEmpty() && ((Boolean)Config.Client.PHOTOGRAPH_SHOW_PHOTOGRAPHER_IN_TOOLTIP.get()).booleanValue()) {
            tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.exposure.photograph.photographer_tooltip", (Object[])new Object[]{class_2561.method_43470((String)photographerName).method_27692(class_124.field_1068)}).method_27692(class_124.field_1080));
        }
        if (generation < 2 && !PlatformHelper.isModLoaded("jei") && ((Boolean)Config.Client.RECIPE_TOOLTIPS_WITHOUT_JEI.get()).booleanValue()) {
            ClientGUI.addPhotographCopyingTooltip(stack, level, tooltipComponents, isAdvanced);
        }
        if (isAdvanced.method_8035()) {
            String str = (String)FrameData.getIdOrTexture(stack.method_7969()).map(id -> "Exposure Id: " + id, texture -> "Texture: " + String.valueOf(texture));
            tooltipComponents.add((class_2561)class_2561.method_43470((String)str).method_27692(class_124.field_1063));
        }
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        if (!FrameData.hasIdOrTexture(itemInHand)) {
            Exposure.LOGGER.warn("No Id or Texture is defined. - {}", (Object)itemInHand);
            return class_1271.method_22430((Object)itemInHand);
        }
        if (level.field_9236) {
            ClientGUI.openPhotographScreen(List.of(new ItemAndStack(itemInHand)));
            player.method_5783(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.6f, 1.1f);
        }
        return class_1271.method_22427((Object)itemInHand);
    }

    public boolean method_31566(@NotNull class_1799 stack, @NotNull class_1799 other, @NotNull class_1735 slot, @NotNull class_5536 action, @NotNull class_1657 player, @NotNull class_5630 access) {
        if (action != class_5536.field_27014) {
            return false;
        }
        if (other.method_7909() instanceof PhotographItem) {
            StackedPhotographsItem stackedPhotographsItem = Exposure.Items.STACKED_PHOTOGRAPHS.get();
            class_1799 stackedPhotographsStack = new class_1799((class_1935)stackedPhotographsItem);
            stackedPhotographsItem.addPhotographOnTop(stackedPhotographsStack, stack);
            stackedPhotographsItem.addPhotographOnTop(stackedPhotographsStack, other);
            slot.method_7673(stackedPhotographsStack);
            access.method_32332(class_1799.field_8037);
            StackedPhotographsItem.playAddSoundClientside(player);
            return true;
        }
        return false;
    }
}

