/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.StorageTags;
import com.tom.storagemod.gui.CraftingTerminalScreen;
import com.tom.storagemod.gui.InventoryConnectorFilterScreen;
import com.tom.storagemod.gui.InventoryLinkScreen;
import com.tom.storagemod.gui.ItemFilterScreen;
import com.tom.storagemod.gui.LevelEmitterScreen;
import com.tom.storagemod.gui.StorageTerminalScreen;
import com.tom.storagemod.gui.TagItemFilterScreen;
import com.tom.storagemod.item.WirelessTerminalItem;
import com.tom.storagemod.model.BakedPaintedModel;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.platform.Platform;
import com.tom.storagemod.tile.PaintedBlockEntity;
import com.tom.storagemod.util.IDataReceiver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3929;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;

public class StorageModClient
implements ClientModInitializer {
    protected static final class_2960 PAINT = new class_2960("toms_storage", "paint");
    public static class_304 openTerm;
    private static class_2561[] tooltipExt;

    public void onInitializeClient() {
        class_3929.method_17542(Content.storageTerminal.get(), StorageTerminalScreen::new);
        class_3929.method_17542(Content.craftingTerminalCont.get(), CraftingTerminalScreen::new);
        class_3929.method_17542(Content.invCableConnectorFilteredConatiner.get(), InventoryConnectorFilterScreen::new);
        class_3929.method_17542(Content.levelEmitterConatiner.get(), LevelEmitterScreen::new);
        class_3929.method_17542(Content.inventoryLink.get(), InventoryLinkScreen::new);
        class_3929.method_17542(Content.itemFilterConatiner.get(), ItemFilterScreen::new);
        class_3929.method_17542(Content.tagItemFilterConatiner.get(), TagItemFilterScreen::new);
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)Content.paintedTrim.get(), class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)StorageMod.invCablePainted.get(), class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)Content.levelEmitter.get(), class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)StorageMod.invCableConnectorPainted.get(), class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)StorageMod.invProxyPainted.get(), class_1921.method_23583());
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkHandler.DATA_S2C, (mc, h, buf, rp) -> {
            class_2487 tag = Platform.readNbtTag(buf);
            mc.method_20493(() -> {
                if (mc.field_1755 instanceof IDataReceiver) {
                    ((IDataReceiver)mc.field_1755).receive(tag);
                }
            });
        });
        ModelLoadingPlugin.register((ModelLoadingPlugin)new ModelLoadingPlugin(){

            public void onInitializeModelLoader(ModelLoadingPlugin.Context ctx) {
                ctx.resolveModel().register(c -> c.id().equals((Object)PAINT) ? new BakedPaintedModel() : null);
            }
        });
        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> {
            if (world != null) {
                try {
                    class_2680 mimicBlock = ((PaintedBlockEntity)world.method_8321(pos)).getPaintedBlockState();
                    return class_310.method_1551().method_1505().method_1697(mimicBlock, world, pos, tintIndex);
                }
                catch (Exception var8) {
                    return -1;
                }
            }
            return -1;
        }, (Object[])new class_2248[]{(class_2248)Content.paintedTrim.get(), (class_2248)StorageMod.invCablePainted.get(), (class_2248)StorageMod.invCableConnectorPainted.get(), (class_2248)StorageMod.invProxyPainted.get()});
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register((ctx, hr) -> {
            class_310 mc = class_310.method_1551();
            class_746 player = mc.field_1724;
            if (player == null) {
                return true;
            }
            if (!WirelessTerminalItem.isPlayerHolding((class_1657)player)) {
                return true;
            }
            class_3965 lookingAt = (class_3965)player.method_5745((double)StorageMod.CONFIG.wirelessRange, 0.0f, true);
            class_2680 state = mc.field_1687.method_8320(lookingAt.method_17777());
            if (state.method_26164(StorageTags.REMOTE_ACTIVATE)) {
                class_2338 pos = lookingAt.method_17777();
                class_243 renderPos = mc.field_1773.method_19418().method_19326();
                class_4588 buf = mc.method_22940().method_23000().getBuffer(class_1921.method_23594());
                StorageModClient.drawShapeOutline(ctx.matrixStack(), buf, state.method_26220((class_1922)player.method_37908(), pos), (double)pos.method_10263() - renderPos.field_1352, (double)pos.method_10264() - renderPos.field_1351, (double)pos.method_10260() - renderPos.field_1350, 1.0f, 1.0f, 1.0f, 0.4f);
                mc.method_22940().method_23000().method_22994(class_1921.method_23594());
                return false;
            }
            return true;
        });
        try {
            Class<?> clz = Class.forName("com.kqp.inventorytabs.api.TabProviderRegistry");
            Method regSimpleBlock = clz.getDeclaredMethod("registerSimpleBlock", class_2248.class);
            regSimpleBlock.invoke(null, new Object[]{Content.terminal.get()});
            regSimpleBlock.invoke(null, new Object[]{Content.craftingTerminal.get()});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ClientLoginNetworking.registerGlobalReceiver((class_2960)StorageMod.id("config"), (mc, handler, buf, fc) -> {
            Config read;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new ByteBufInputStream((ByteBuf)buf));){
                read = (Config)StorageMod.gson.fromJson((Reader)reader, Config.class);
            }
            catch (Exception e) {
                StorageMod.LOGGER.warn("Error loading server config", (Throwable)e);
                return CompletableFuture.completedFuture(null);
            }
            StorageMod.CONFIG = read;
            StorageMod.LOGGER.info("Received server config");
            return CompletableFuture.completedFuture(PacketByteBufs.empty());
        });
        openTerm = new class_304("key.toms_storage.open_terminal", 66, "key.categories.gameplay");
        KeyBindingHelper.registerKeyBinding((class_304)openTerm);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null) {
                return;
            }
            if (openTerm.method_1436()) {
                NetworkHandler.openTerminal();
            }
        });
        ItemTooltipCallback.EVENT.register((s, c, l) -> Collections.addAll(l, tooltipExt));
    }

    private static void drawShapeOutline(class_4587 matrices, class_4588 vertexConsumer, class_265 voxelShape, double d, double e, double f, float g, float h, float i, float j) {
        class_4587.class_4665 entry = matrices.method_23760();
        voxelShape.method_1104((k, l, m, n, o, p) -> {
            float q = (float)(n - k);
            float r = (float)(o - l);
            float s = (float)(p - m);
            float t = class_3532.method_15355((float)(q * q + r * r + s * s));
            vertexConsumer.method_22918(entry.method_23761(), (float)(k + d), (float)(l + e), (float)(m + f)).method_22915(g, h, i, j).method_23763(entry.method_23762(), q /= t, r /= t, s /= t).method_1344();
            vertexConsumer.method_22918(entry.method_23761(), (float)(n + d), (float)(o + e), (float)(p + f)).method_22915(g, h, i, j).method_23763(entry.method_23762(), q, r, s).method_1344();
        });
    }

    public static void tooltip(String key, List<class_2561> tooltip, Object ... args) {
        StorageModClient.tooltip(key, true, tooltip, args);
    }

    public static void tooltip(String key, boolean shift, List<class_2561> tooltip, Object ... args) {
        if (class_437.method_25442()) {
            String[] sp = class_1074.method_4662((String)("tooltip.toms_storage." + key), (Object[])args).split("\\\\");
            for (int i = 0; i < sp.length; ++i) {
                tooltip.add((class_2561)class_2561.method_43470((String)sp[i]));
            }
        } else if (shift) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.toms_storage.hold_shift_for_info").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}));
        }
    }

    public static void setTooltip(class_2561 ... string) {
        tooltipExt = string;
    }

    static {
        tooltipExt = new class_2561[0];
    }
}

