/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Content;
import com.tom.storagemod.gui.CraftingTerminalMenu;
import com.tom.storagemod.platform.PlatformRecipe;
import com.tom.storagemod.tile.StorageTerminalBlockEntity;
import com.tom.storagemod.util.CraftingMatrix;
import com.tom.storagemod.util.StoredItemStack;
import java.util.HashSet;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1731;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3956;
import net.minecraft.class_8566;

public class CraftingTerminalBlockEntity
extends StorageTerminalBlockEntity {
    private PlatformRecipe currentRecipe;
    private final class_8566 craftMatrix = new CraftingMatrix(3, 3, () -> {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.onCraftingMatrixChanged();
        }
        this.method_5431();
    });
    private class_1731 craftResult = new class_1731();
    private HashSet<CraftingTerminalMenu> craftingListeners = new HashSet();
    private boolean refillingGrid;
    private int craftingCooldown;
    private boolean reading;

    public CraftingTerminalBlockEntity(class_2338 pos, class_2680 state) {
        super(Content.craftingTerminalTile.get(), pos, state);
    }

    @Override
    public class_1703 createMenu(int id, class_1661 plInv, class_1657 arg2) {
        return new CraftingTerminalMenu(id, plInv, this);
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471((String)"ts.crafting_terminal");
    }

    @Override
    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        class_2499 listnbt = new class_2499();
        for (int i = 0; i < this.craftMatrix.method_5439(); ++i) {
            class_1799 itemstack = this.craftMatrix.method_5438(i);
            if (itemstack.method_7960()) continue;
            class_2487 tag = new class_2487();
            tag.method_10567("Slot", (byte)i);
            itemstack.method_7953(tag);
            listnbt.add((Object)tag);
        }
        compound.method_10566("CraftingTable", (class_2520)listnbt);
    }

    @Override
    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.reading = true;
        class_2499 listnbt = compound.method_10554("CraftingTable", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            class_2487 tag = listnbt.method_10602(i);
            int j = tag.method_10571("Slot") & 0xFF;
            if (j < 0 || j >= this.craftMatrix.method_5439()) continue;
            this.craftMatrix.method_5447(j, class_1799.method_7915((class_2487)tag));
        }
        this.reading = false;
    }

    public class_8566 getCraftingInv() {
        return this.craftMatrix;
    }

    public class_1731 getCraftResult() {
        return this.craftResult;
    }

    public void craft(class_1657 thePlayer) {
        if (this.currentRecipe != null) {
            class_2371<class_1799> remainder = this.currentRecipe.getRemainingItems(this.craftMatrix);
            boolean playerInvUpdate = false;
            this.refillingGrid = true;
            for (int i = 0; i < remainder.size(); ++i) {
                class_1799 slot = this.craftMatrix.method_5438(i);
                class_1799 oldItem = slot.method_7972();
                class_1799 rem = (class_1799)remainder.get(i);
                if (class_1799.method_7973((class_1799)slot, (class_1799)rem)) continue;
                if (!slot.method_7960()) {
                    this.craftMatrix.method_5434(i, 1);
                    slot = this.craftMatrix.method_5438(i);
                }
                if (slot.method_7960() && !oldItem.method_7960()) {
                    StoredItemStack is = this.pullStack(new StoredItemStack(oldItem), 1L);
                    if (is == null && (this.getSorting() & 0x100) != 0) {
                        for (int j = 0; j < thePlayer.method_31548().method_5439(); ++j) {
                            class_1799 st = thePlayer.method_31548().method_5438(j);
                            if (!class_1799.method_31577((class_1799)oldItem, (class_1799)st) || (st = thePlayer.method_31548().method_5434(j, 1)).method_7960()) continue;
                            is = new StoredItemStack(st, 1L);
                            playerInvUpdate = true;
                            break;
                        }
                    }
                    if (is != null) {
                        this.craftMatrix.method_5447(i, is.getActualStack());
                        slot = this.craftMatrix.method_5438(i);
                    }
                }
                if (rem.method_7960()) continue;
                if (slot.method_7960()) {
                    this.craftMatrix.method_5447(i, rem);
                    continue;
                }
                if ((rem = this.pushStack(rem)).method_7960() || thePlayer.method_31548().method_7394(rem)) continue;
                thePlayer.method_7328(rem, false);
            }
            this.refillingGrid = false;
            this.onCraftingMatrixChanged();
            this.craftingCooldown += this.craftResult.method_5438(0).method_7947();
            if (playerInvUpdate) {
                thePlayer.field_7512.method_7623();
            }
        }
    }

    public void unregisterCrafting(CraftingTerminalMenu containerCraftingTerminal) {
        this.craftingListeners.remove(containerCraftingTerminal);
    }

    public void registerCrafting(CraftingTerminalMenu containerCraftingTerminal) {
        this.craftingListeners.add(containerCraftingTerminal);
    }

    protected void onCraftingMatrixChanged() {
        if (this.refillingGrid) {
            return;
        }
        if (this.currentRecipe == null || !this.currentRecipe.matches((class_1263)this.craftMatrix, this.field_11863)) {
            this.currentRecipe = PlatformRecipe.of(this.field_11863.method_8433().method_8132(class_3956.field_17545, (class_1263)this.craftMatrix, this.field_11863).orElse(null));
        }
        if (this.currentRecipe == null) {
            this.craftResult.method_5447(0, class_1799.field_8037);
        } else {
            this.craftResult.method_5447(0, this.currentRecipe.assemble((class_1263)this.craftMatrix, this.field_11863.method_30349()));
        }
        this.craftingListeners.forEach(CraftingTerminalMenu::onCraftMatrixChanged);
        this.craftResult.method_7662(this.currentRecipe == null ? null : this.currentRecipe.recipe());
        if (!this.reading) {
            this.method_5431();
        }
    }

    public void clear(class_1657 player) {
        for (int i = 0; i < this.craftMatrix.method_5439(); ++i) {
            StoredItemStack st0;
            class_1799 st = this.craftMatrix.method_5441(i);
            if (st.method_7960() || (st0 = this.pushStack(new StoredItemStack(st))) == null) continue;
            class_1799 is = st0.getActualStack();
            player.method_31548().method_7394(is);
            if (is.method_7960()) continue;
            this.dropItem(is);
        }
        this.onCraftingMatrixChanged();
    }

    @Override
    public void updateServer() {
        super.updateServer();
        this.craftingCooldown = 0;
    }

    public boolean canCraft() {
        return this.craftingCooldown + this.craftResult.method_5438(0).method_7947() <= this.craftResult.method_5438(0).method_7914();
    }

    public void polymorphUpdate() {
    }

    public void setCraftSlot(int x, int y, class_1799 actualStack) {
        this.craftMatrix.method_5447(x + y * 3, actualStack);
    }
}

