/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.behavior;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_4538;
import net.minecraft.class_5431;

public interface CanSurviveHandler {
    public boolean isSensitiveSide(class_2680 var1, class_2350 var2);

    public boolean canSurvive(class_2680 var1, class_4538 var2, class_2338 var3);

    public static CanSurviveHandler checkFloor() {
        return Impls.CHECK_FLOOR;
    }

    public static CanSurviveHandler checkCeiling() {
        return Impls.CHECK_CEILING;
    }

    public static CanSurviveHandler checkFace(class_2753 property) {
        return Impls.CHECK_FACE.computeIfAbsent(property, key -> new CanSurviveHandler((class_2753)key){
            final /* synthetic */ class_2753 val$key;
            {
                this.val$key = class_27532;
            }

            @Override
            public boolean isSensitiveSide(class_2680 state, class_2350 side) {
                return side == ((class_2350)state.method_11654((class_2769)this.val$key)).method_10153();
            }

            @Override
            public boolean canSurvive(class_2680 state, class_4538 world, class_2338 pos) {
                class_2350 direction = (class_2350)state.method_11654((class_2769)this.val$key);
                class_2338 neighbor = pos.method_10093(direction);
                return world.method_8320(neighbor).method_30368((class_1922)world, neighbor, direction.method_10153(), class_5431.field_25824);
            }
        });
    }

    public static Compound any(List<CanSurviveHandler> handlers) {
        return new Compound(true, handlers);
    }

    public static Compound all(List<CanSurviveHandler> handlers) {
        return new Compound(false, handlers);
    }

    public static final class Impls {
        private static final CanSurviveHandler CHECK_FLOOR = new CanSurviveHandler(){

            @Override
            public boolean isSensitiveSide(class_2680 state, class_2350 side) {
                return side == class_2350.field_11033;
            }

            @Override
            public boolean canSurvive(class_2680 state, class_4538 world, class_2338 pos) {
                return class_2248.method_16361((class_1922)world, (class_2338)pos.method_10074());
            }
        };
        private static final CanSurviveHandler CHECK_CEILING = new CanSurviveHandler(){

            @Override
            public boolean isSensitiveSide(class_2680 state, class_2350 side) {
                return side == class_2350.field_11036;
            }

            @Override
            public boolean canSurvive(class_2680 state, class_4538 world, class_2338 pos) {
                pos = pos.method_10084();
                return world.method_8320(pos).method_30368((class_1922)world, pos, class_2350.field_11033, class_5431.field_25824);
            }
        };
        private static final Map<class_2753, CanSurviveHandler> CHECK_FACE = Maps.newHashMap();

        private Impls() {
        }
    }

    public record Compound(boolean any, List<CanSurviveHandler> handlers) implements CanSurviveHandler
    {
        @Override
        public boolean isSensitiveSide(class_2680 state, class_2350 side) {
            for (CanSurviveHandler handler : this.handlers) {
                if (!handler.isSensitiveSide(state, side)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean canSurvive(class_2680 state, class_4538 world, class_2338 pos) {
            for (CanSurviveHandler handler : this.handlers) {
                if (handler.canSurvive(state, world, pos) != this.any) continue;
                return this.any;
            }
            return !this.any;
        }
    }
}

