/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.placement;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.placement.PlaceSlot;
import snownee.kiwi.customization.placement.PlaceSlotProvider;
import snownee.kiwi.customization.placement.TagTestOperator;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.codec.CustomizationCodecs;

public record SlotLink(String from, String to, int interest, List<TagTest> testTag, ResultAction onLinkFrom, ResultAction onLinkTo, ResultAction onUnlinkFrom, ResultAction onUnlinkTo) {
    public static final Codec<String> PRIMARY_TAG_CODEC = class_5699.method_48112((Codec)Codec.STRING, s -> {
        if (s.startsWith("*")) {
            return DataResult.success((Object)s);
        }
        return DataResult.error(() -> "Primary tag must start with *");
    });
    public static final Codec<SlotLink> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PRIMARY_TAG_CODEC.fieldOf("from").forGetter(SlotLink::from), (App)PRIMARY_TAG_CODEC.fieldOf("to").forGetter(SlotLink::to), (App)Codec.INT.optionalFieldOf("interest", (Object)100).forGetter(SlotLink::interest), (App)CustomizationCodecs.strictOptionalField(TagTest.CODEC.listOf(), "test_tag", List.of()).forGetter(SlotLink::testTag), (App)SlotLink.fromToPairCodec("on_link").forGetter($ -> Pair.of((Object)$.onLinkFrom, (Object)$.onLinkTo)), (App)SlotLink.fromToPairCodec("on_unlink").forGetter($ -> Pair.of((Object)$.onUnlinkFrom, (Object)$.onUnlinkTo))).apply((Applicative)instance, SlotLink::create));
    private static ImmutableMap<Pair<String, String>, SlotLink> LOOKUP = ImmutableMap.of();

    private static MapCodec<Pair<ResultAction, ResultAction>> fromToPairCodec(String fieldName) {
        Codec pairCodec = RecordCodecBuilder.create(instance -> instance.group((App)CustomizationCodecs.strictOptionalField(ResultAction.CODEC, "from", ResultAction.EMPTY).forGetter(Pair::getFirst), (App)CustomizationCodecs.strictOptionalField(ResultAction.CODEC, "to", ResultAction.EMPTY).forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
        return pairCodec.optionalFieldOf(fieldName, (Object)Pair.of((Object)ResultAction.EMPTY, (Object)ResultAction.EMPTY));
    }

    private static void renewData(Preparation preparation) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)preparation.slotLinks.size());
        Set<String> primaryTags = preparation.slotProviders.knownPrimaryTags();
        for (SlotLink link : preparation.slotLinks.values()) {
            if (!primaryTags.contains(link.from)) {
                Kiwi.LOGGER.error("Unknown primary tag in \"from\": %s".formatted(link.from));
                continue;
            }
            if (!primaryTags.contains(link.to)) {
                Kiwi.LOGGER.error("Unknown primary tag in \"to\": %s".formatted(link.to));
                continue;
            }
            Pair key = link.from.compareTo(link.to) <= 0 ? Pair.of((Object)link.from, (Object)link.to) : Pair.of((Object)link.to, (Object)link.from);
            SlotLink oldLink = map.put(key, link);
            if (oldLink == null) continue;
            Kiwi.LOGGER.error("Duplicate link: %s and %s".formatted(link, oldLink));
        }
        LOOKUP = ImmutableMap.copyOf((Map)map);
    }

    public static SlotLink create(String from, String to, int interest, List<TagTest> testTag, Pair<ResultAction, ResultAction> onLink, Pair<ResultAction, ResultAction> onUnlink) {
        return new SlotLink(from, to, interest, testTag, (ResultAction)onLink.getFirst(), (ResultAction)onLink.getSecond(), (ResultAction)onUnlink.getFirst(), (ResultAction)onUnlink.getSecond());
    }

    @Nullable
    public static SlotLink find(PlaceSlot slot1, PlaceSlot slot2) {
        String key1 = slot1.primaryTag();
        String key2 = slot2.primaryTag();
        Pair key = SlotLink.isUprightLink(slot1, slot2) ? Pair.of((Object)key1, (Object)key2) : Pair.of((Object)key2, (Object)key1);
        return (SlotLink)LOOKUP.get((Object)key);
    }

    @Nullable
    public static MatchResult find(Collection<PlaceSlot> slots1, Collection<PlaceSlot> slots2) {
        if (slots1.isEmpty() || slots2.isEmpty()) {
            return null;
        }
        int maxInterest = -1;
        SlotLink matchedLink = null;
        boolean isUpright = false;
        for (PlaceSlot slot1 : slots1) {
            for (PlaceSlot slot2 : slots2) {
                SlotLink link = SlotLink.find(slot1, slot2);
                if (link == null || link.interest() <= maxInterest || !link.matches(slot1, slot2)) continue;
                maxInterest = link.interest();
                matchedLink = link;
                isUpright = SlotLink.isUprightLink(slot1, slot2) == link.from().compareTo(link.to()) <= 0;
            }
        }
        return matchedLink == null ? null : new MatchResult(matchedLink, isUpright);
    }

    @Nullable
    public static MatchResult find(class_2680 ourState, class_2680 theirState, class_2350 direction) {
        Collection<PlaceSlot> slots1 = PlaceSlot.find(ourState, direction);
        Collection<PlaceSlot> slots2 = PlaceSlot.find(theirState, direction.method_10153());
        return SlotLink.find(slots1, slots2);
    }

    public static boolean isUprightLink(PlaceSlot slot1, PlaceSlot slot2) {
        return slot1.primaryTag().compareTo(slot2.primaryTag()) <= 0;
    }

    public boolean matches(PlaceSlot slot1, PlaceSlot slot2) {
        for (TagTest test : this.testTag) {
            String s1 = (String)slot1.tags().get((Object)test.key);
            String s2 = (String)slot2.tags().get((Object)test.key);
            if (s1 == null || s2 == null) {
                return false;
            }
            if (test.operator.test().test(s1, s2)) continue;
            return false;
        }
        return true;
    }

    public record ResultAction(Map<String, String> setProperties, boolean reflow) {
        public static final MapCodec<ResultAction> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CustomizationCodecs.strictOptionalField(Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING), "set_properties", Map.of()).forGetter(ResultAction::setProperties), (App)Codec.BOOL.optionalFieldOf("reflow", (Object)false).forGetter(ResultAction::reflow)).apply((Applicative)instance, ResultAction::new));
        public static final Codec<ResultAction> CODEC = MAP_CODEC.codec();
        private static final ResultAction EMPTY = new ResultAction(Map.of(), false);

        public class_2680 apply(class_1937 level, class_2338 pos, class_2680 blockState) {
            KBlockSettings settings;
            for (Map.Entry<String, String> entry : this.setProperties.entrySet()) {
                blockState = KBlockUtils.setValueByString(blockState, entry.getKey(), entry.getValue());
            }
            if (this.reflow && (settings = KBlockSettings.of(blockState.method_26204())) != null && settings.placeChoices != null) {
                blockState = settings.placeChoices.getStateForPlacement(level, pos, blockState);
            }
            return blockState;
        }
    }

    public record Preparation(Map<class_2960, SlotLink> slotLinks, PlaceSlotProvider.Preparation slotProviders) {
        public static Preparation of(Supplier<Map<class_2960, SlotLink>> slotLinksSupplier, PlaceSlotProvider.Preparation slotProviders) {
            Map<class_2960, SlotLink> slotLinks = Platform.isDataGen() ? Map.of() : slotLinksSupplier.get();
            return new Preparation(slotLinks, slotProviders);
        }

        public void finish() {
            SlotLink.renewData(this);
        }
    }

    public record MatchResult(SlotLink link, boolean isUpright) {
        public ResultAction onLinkFrom() {
            return this.isUpright ? this.link.onLinkFrom : this.link.onLinkTo;
        }

        public ResultAction onLinkTo() {
            return this.isUpright ? this.link.onLinkTo : this.link.onLinkFrom;
        }

        public ResultAction onUnlinkTo() {
            return this.isUpright ? this.link.onUnlinkTo : this.link.onUnlinkFrom;
        }
    }

    public record TagTest(String key, TagTestOperator operator) {
        public static final Codec<TagTest> CODEC = CustomizationCodecs.withAlternative(RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(TagTest::key), (App)TagTestOperator.CODEC.fieldOf("operator").forGetter(TagTest::operator)).apply((Applicative)instance, TagTest::new)), class_5699.field_41759.xmap(s -> new TagTest((String)s, TagTestOperator.EQUAL), TagTest::key));
    }
}

