/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.item;

import com.github.mim1q.convenientdecor.ConvenientDecor;
import com.github.mim1q.convenientdecor.block.CustomProperties;
import com.github.mim1q.convenientdecor.block.blockentity.WateringCanBlockEntity;
import com.github.mim1q.convenientdecor.init.ModBlocks;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class WateringCanItem
extends class_1792 {
    public static final int MAX_WATER_LEVEL = 32;
    public static final String WATER_LEVEL_KEY = "item.convenientdecor.watering_can.water_level";

    public WateringCanItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_2586 entity;
        class_3965 hitResult = WateringCanItem.method_7872((class_1937)world, (class_1657)user, (class_3959.class_242)class_3959.class_242.field_36338);
        class_1799 stack = user.method_5998(hand);
        if (hitResult.method_17783() == class_239.class_240.field_1333) {
            return class_1271.method_22430((Object)stack);
        }
        class_1271<class_1799> result = this.tryUseOnBlock(world, user, stack, hitResult);
        if (result != null) {
            return result;
        }
        class_1750 ctx = new class_1750(user, hand, stack, hitResult);
        class_1271<class_1799> result2 = this.tryPlace(ctx);
        if (result2.method_5467().method_23665() && (entity = world.method_8321(ctx.method_8037())) instanceof WateringCanBlockEntity) {
            WateringCanBlockEntity wateringCan = (WateringCanBlockEntity)entity;
            wateringCan.method_38240(stack);
        }
        return result2;
    }

    protected class_1271<class_1799> tryUseOnBlock(class_1937 world, class_1657 user, class_1799 stack, class_3965 hitResult) {
        class_243 pos = hitResult.method_17784();
        class_2680 state = world.method_8320(hitResult.method_17777());
        if (state.method_26227().method_15767(class_3486.field_15517)) {
            if (WateringCanItem.getWaterLevel(stack) < 32) {
                WateringCanItem.setWaterLevel(stack, 32);
                world.method_8486(pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_15126, class_3419.field_15248, 1.0f, 1.0f, true);
                return class_1271.method_22427((Object)stack);
            }
            return class_1271.method_22431((Object)stack);
        }
        if (state.method_27852(class_2246.field_10362) && ConvenientDecor.CONFIG.features.wateringCanPermanentFarmland) {
            if (user.method_5715()) {
                return null;
            }
            if (!WateringCanItem.canWater(stack) || ((Boolean)state.method_11654((class_2769)CustomProperties.HYDRATED)).booleanValue()) {
                return class_1271.method_22431((Object)stack);
            }
            WateringCanItem.setWaterLevel(stack, WateringCanItem.getWaterLevel(stack) - 1);
            world.method_8501(hitResult.method_17777(), (class_2680)((class_2680)class_2246.field_10362.method_9564().method_11657((class_2769)CustomProperties.HYDRATED, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2344.field_11009, (Comparable)Integer.valueOf(7)));
            world.method_8486(pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_14834, class_3419.field_15248, 1.0f, 1.0f, true);
            return class_1271.method_22427((Object)stack);
        }
        return null;
    }

    protected class_1271<class_1799> tryPlace(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_2680 state = world.method_8320(pos);
        class_1799 stack = ctx.method_8041();
        class_1657 user = ctx.method_8036();
        class_2680 newState = ModBlocks.WATERING_CAN.method_9605(ctx);
        if (!world.method_8628(newState, pos, class_3726.method_16194())) {
            return class_1271.method_22431((Object)stack);
        }
        if (state.method_45474()) {
            world.method_8501(pos, newState);
            world.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15167, class_3419.field_15245, (class_2498.field_11533.method_10597() + 1.0f) / 2.0f, class_2498.field_11533.method_10599() * 0.8f, true);
            world.method_43276(class_5712.field_28164, pos, class_5712.class_7397.method_43286((class_1297)user, (class_2680)newState));
            stack.method_7934(1);
        }
        return class_1271.method_22427((Object)stack);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43469((String)WATER_LEVEL_KEY, (Object[])new Object[]{WateringCanItem.getWaterLevel(stack), 32}).method_27692(class_124.field_1075));
    }

    public boolean method_31567(class_1799 stack) {
        return WateringCanItem.getWaterLevel(stack) < 32;
    }

    public class_1799 method_7854() {
        class_1799 stack = super.method_7854();
        WateringCanItem.setWaterLevel(stack, 0);
        return stack;
    }

    public class_1799 getStack(int waterLevel) {
        class_1799 stack = super.method_7854();
        WateringCanItem.setWaterLevel(stack, waterLevel);
        return stack;
    }

    public int method_31571(class_1799 stack) {
        return 43775;
    }

    public int method_31569(class_1799 stack) {
        return Math.round((float)WateringCanItem.getWaterLevel(stack) / 32.0f * 13.0f);
    }

    public static int getWaterLevel(class_1799 stack) {
        return stack.method_7948().method_10550("WaterLevel");
    }

    public static void setWaterLevel(class_1799 stack, int waterLevel) {
        if (class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)stack) == 0 || waterLevel > WateringCanItem.getWaterLevel(stack)) {
            stack.method_7948().method_10569("WaterLevel", waterLevel);
        }
    }

    public static boolean canWater(class_1799 stack) {
        return WateringCanItem.getWaterLevel(stack) > 0;
    }
}

