/*
 * Decompiled with CFR 0.152.
 */
package net.adorabuild.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.adorabuild.structures.AdorabuildStructuresMod;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;

public class OverworldJigsawStructure
extends class_3195 {
    public static final Codec<OverworldJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)OverworldJigsawStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)100).fieldOf("size").forGetter(structure -> structure.size), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.INT.optionalFieldOf("min_absolute_height").forGetter(structure -> structure.minAbsoluteHeight), (App)Codec.INT.optionalFieldOf("max_absolute_height").forGetter(structure -> structure.maxAbsoluteHeight), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, OverworldJigsawStructure::new)).codec();
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int size;
    private final class_6122 startHeight;
    private final Optional<Integer> minAbsoluteHeight;
    private final Optional<Integer> maxAbsoluteHeight;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public OverworldJigsawStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, class_6122 startHeight, Optional<Integer> minAbsoluteHeight, Optional<Integer> maxAbsoluteHeight, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.minAbsoluteHeight = minAbsoluteHeight;
        this.maxAbsoluteHeight = maxAbsoluteHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        int offsetY = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_1923 chunkPos = context.comp_568();
        class_2338 blockPos = new class_2338(chunkPos.method_8326(), offsetY, chunkPos.method_8328());
        if (this.projectStartToHeightmap.isPresent() && (this.minAbsoluteHeight.isPresent() || this.maxAbsoluteHeight.isPresent())) {
            int terrainY = context.comp_562().method_16397(chunkPos.method_8326(), chunkPos.method_8328(), this.projectStartToHeightmap.get(), context.comp_569(), context.comp_564());
            if (this.minAbsoluteHeight.isPresent() && terrainY < this.minAbsoluteHeight.get()) {
                return Optional.empty();
            }
            if (this.maxAbsoluteHeight.isPresent() && terrainY > this.maxAbsoluteHeight.get()) {
                return Optional.empty();
            }
            if (this.projectStartToHeightmap.get() == class_2902.class_2903.field_13195) {
                blockPos = new class_2338(chunkPos.method_8326(), terrainY + offsetY, chunkPos.method_8328());
                return class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)this.size, (class_2338)blockPos, (boolean)false, Optional.empty(), (int)this.maxDistanceFromCenter);
            }
        }
        return class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)this.size, (class_2338)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    public class_7151<?> method_41618() {
        return AdorabuildStructuresMod.OVERWORLD_JIGSAW_STRUCTURE.get();
    }
}

