/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.entity;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.text.TextHelper;
import com.majruszlibrary.time.TimeHelper;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class EffectDef {
    public Supplier<? extends class_1291> effect;
    public int amplifier;
    public float duration;

    public EffectDef(Supplier<? extends class_1291> effect, int amplifier, float duration) {
        this.effect = effect;
        this.amplifier = amplifier;
        this.duration = duration;
    }

    public EffectDef() {
        this(() -> null, 0, 1.0f);
    }

    public class_1293 toEffectInstance() {
        return new class_1293(this.effect.get(), TimeHelper.toTicks(this.duration), this.amplifier);
    }

    public class_5250 toComponent() {
        class_2561 effectName = this.effect.get().method_5560();
        class_5250 fullName = this.amplifier > 0 ? TextHelper.translatable("potion.withAmplifier", effectName.getString(), TextHelper.toRoman(this.amplifier + 1)) : TextHelper.literal(effectName.getString());
        return TextHelper.translatable("potion.withDuration", fullName.getString(), TextHelper.toEffectDuration(this.duration));
    }

    static {
        Serializables.get(EffectDef.class).define("id", Reader.optional(Reader.mobEffect()), s -> s.effect.get(), (s, v) -> {
            s.effect = () -> v;
        }).define("amplifier", Reader.integer(), s -> s.amplifier, (s, v) -> {
            s.amplifier = Range.of(0, 10).clamp((Integer)v);
        }).define("duration", Reader.number(), s -> Float.valueOf(s.duration), (s, v) -> {
            s.duration = Range.of(Float.valueOf(1.0f), Float.valueOf(1000.0f)).clamp((Float)v).floatValue();
        });
    }
}

