/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.events.base;

import com.majruszlibrary.events.base.Event;
import com.majruszlibrary.events.type.ICancellableEvent;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_3532;

public class Events<DataType> {
    static final Object2ObjectMap<Class<?>, Events<?>> EVENTS = new Object2ObjectOpenHashMap();
    final List<Event<DataType>> events = new ArrayList<Event<DataType>>();

    public static <DataType> DataType dispatch(DataType data) {
        Events events = (Events)EVENTS.get(data.getClass());
        if (events != null) {
            events.accept(data);
        }
        return data;
    }

    public static <DataType extends ICancellableEvent> DataType dispatch(DataType data) {
        Events events = (Events)EVENTS.get(data.getClass());
        if (events != null) {
            events.accept(data, ICancellableEvent::isExecutionStopped);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <DataType> Events<DataType> get(Class<DataType> clazz) {
        Class<Events> clazz2 = Events.class;
        synchronized (Events.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (Events)EVENTS.computeIfAbsent(clazz, key -> new Events());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event<DataType> add(Consumer<DataType> consumer) {
        Event<DataType> event = new Event<DataType>(this, consumer);
        Events events = this;
        synchronized (events) {
            this.events.add(event);
        }
        this.sort();
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sort() {
        Events events = this;
        synchronized (events) {
            this.events.sort((left, right) -> class_3532.method_17822((double)(left.priority.ordinal() - right.priority.ordinal())));
        }
    }

    private Events() {
    }

    private void accept(DataType data) {
        for (Event<DataType> event : this.events) {
            event.accept(data);
        }
    }

    private void accept(DataType data, Predicate<DataType> isExecutionStopped) {
        for (Event<DataType> event : this.events) {
            event.accept(data);
            if (!isExecutionStopped.test(data)) continue;
            break;
        }
    }
}

