/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.text;

import com.majruszlibrary.time.TimeHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3544;
import net.minecraft.class_5250;

public class TextHelper {
    static final int DEFAULT_SCALE = 2;
    static final TreeMap<Integer, String> ROMAN_LETTERS = new TreeMap();

    public static String toRoman(int number) {
        int nearestKey = ROMAN_LETTERS.floorKey(number);
        return number == nearestKey ? ROMAN_LETTERS.get(number) : ROMAN_LETTERS.get(nearestKey) + TextHelper.toRoman(number - nearestKey);
    }

    public static String toEffectDuration(int ticks) {
        return class_3544.method_15439((int)ticks);
    }

    public static String toEffectDuration(double seconds) {
        return TextHelper.toEffectDuration(TimeHelper.toTicks(seconds));
    }

    public static String minPrecision(double number, int scale) {
        if (Math.abs(number - (double)((long)number)) < Math.pow(0.1, scale + 1)) {
            return "%.0f".formatted(number);
        }
        return new BigDecimal(number).setScale(scale, RoundingMode.HALF_EVEN).stripTrailingZeros().toPlainString();
    }

    public static String minPrecision(double number) {
        return TextHelper.minPrecision(number, 2);
    }

    public static String minPrecision(float number, int scale) {
        if ((double)Math.abs(number - (float)((int)number)) < Math.pow(0.1f, scale + 1)) {
            return "%.0f".formatted(Float.valueOf(number));
        }
        return new BigDecimal(number).setScale(scale, RoundingMode.HALF_EVEN).stripTrailingZeros().toPlainString();
    }

    public static String minPrecision(float number) {
        return TextHelper.minPrecision(number, 2);
    }

    public static String signed(float number, int scale) {
        return "%s%s".formatted(number >= 0.0f ? "+" : "", TextHelper.minPrecision(number, scale));
    }

    public static String signed(float number) {
        return TextHelper.signed(number, 2);
    }

    public static String signed(int number) {
        return "%s%d".formatted(number >= 0 ? "+" : "", number);
    }

    public static String signedPercent(float number, int scale) {
        return "%s%%".formatted(TextHelper.signed(number * 100.0f, scale));
    }

    public static String signedPercent(float number) {
        return TextHelper.signedPercent(number, 2);
    }

    public static String signedPercent(int number) {
        return "%s%%".formatted(TextHelper.signed(number * 100));
    }

    public static String percent(float number, int scale) {
        return "%s%%".formatted(TextHelper.minPrecision(number * 100.0f, scale));
    }

    public static String percent(float number) {
        return TextHelper.percent(number, 2);
    }

    public static String percent(int number) {
        return "%d%%".formatted(number * 100);
    }

    public static class_5250 literal(String text) {
        return class_2561.method_43470((String)text);
    }

    public static class_5250 literal(String text, Object ... arguments) {
        return class_2561.method_43470((String)text.formatted(arguments));
    }

    public static class_5250 translatable(String id, Object ... arguments) {
        return class_2561.method_43469((String)id, (Object[])arguments);
    }

    public static class_5250 empty() {
        return class_2561.method_43473();
    }

    public static UnaryOperator<class_2583> createURL(String url) {
        return style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, url)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextHelper.literal(url).method_27692(class_124.field_1080)));
    }

    static {
        ROMAN_LETTERS.put(100, "C");
        ROMAN_LETTERS.put(90, "XC");
        ROMAN_LETTERS.put(50, "L");
        ROMAN_LETTERS.put(40, "XL");
        ROMAN_LETTERS.put(10, "X");
        ROMAN_LETTERS.put(9, "IX");
        ROMAN_LETTERS.put(5, "V");
        ROMAN_LETTERS.put(4, "IV");
        ROMAN_LETTERS.put(1, "I");
    }
}

