/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.common.registry.ModRecipeSerializers;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class CuttingBoardRecipe
implements class_1860<RecipeWrapper> {
    public static final int MAX_RESULTS = 4;
    private final class_2960 id;
    private final String group;
    private final class_1856 input;
    private final class_1856 tool;
    private final class_2371<ChanceResult> results;
    private final String soundEvent;

    public CuttingBoardRecipe(class_2960 id, String group, class_1856 input, class_1856 tool, class_2371<ChanceResult> results, String soundEvent) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.tool = tool;
        this.results = results;
        this.soundEvent = soundEvent;
    }

    public boolean method_8118() {
        return true;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public String method_8112() {
        return this.group;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 nonnulllist = class_2371.method_10211();
        nonnulllist.add((Object)this.input);
        return nonnulllist;
    }

    public class_1856 getTool() {
        return this.tool;
    }

    public class_1799 assemble(RecipeWrapper inv, class_5455 access) {
        return ((ChanceResult)this.results.get(0)).stack().method_7972();
    }

    public class_1799 method_8110(class_5455 access) {
        return ((ChanceResult)this.results.get(0)).stack();
    }

    public List<class_1799> getResults() {
        return this.getRollableResults().stream().map(ChanceResult::stack).collect(Collectors.toList());
    }

    public class_2371<ChanceResult> getRollableResults() {
        return this.results;
    }

    public List<class_1799> rollResults(class_5819 rand, int fortuneLevel) {
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        class_2371<ChanceResult> rollableResults = this.getRollableResults();
        for (ChanceResult output : rollableResults) {
            class_1799 stack = output.rollOutput(rand, fortuneLevel);
            if (stack.method_7960()) continue;
            results.add(stack);
        }
        return results;
    }

    public String getSoundEventID() {
        return this.soundEvent;
    }

    public boolean matches(RecipeWrapper inv, class_1937 level) {
        if (inv.method_5442()) {
            return false;
        }
        return this.input.method_8093(inv.method_5438(0));
    }

    protected int getMaxInputCount() {
        return 1;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.getMaxInputCount();
    }

    public class_1865<?> method_8119() {
        return ModRecipeSerializers.CUTTING.get();
    }

    public class_3956<?> method_17716() {
        return ModRecipeTypes.CUTTING.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CuttingBoardRecipe that = (CuttingBoardRecipe)o;
        if (!this.method_8114().equals((Object)that.method_8114())) {
            return false;
        }
        if (!this.method_8112().equals(that.method_8112())) {
            return false;
        }
        if (!this.input.equals(that.input)) {
            return false;
        }
        if (!this.getTool().equals(that.getTool())) {
            return false;
        }
        if (!this.getResults().equals(that.getResults())) {
            return false;
        }
        return Objects.equals(this.soundEvent, that.soundEvent);
    }

    public int hashCode() {
        int result = this.method_8114().hashCode();
        result = 31 * result + (this.method_8112() != null ? this.method_8112().hashCode() : 0);
        result = 31 * result + this.input.hashCode();
        result = 31 * result + this.getTool().hashCode();
        result = 31 * result + this.getResults().hashCode();
        result = 31 * result + (this.soundEvent != null ? this.soundEvent.hashCode() : 0);
        return result;
    }

    public static class Serializer
    implements class_1865<CuttingBoardRecipe> {
        public CuttingBoardRecipe fromJson(class_2960 recipeId, JsonObject json) {
            String groupIn = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_2371<class_1856> inputItemsIn = Serializer.readIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            JsonObject toolObject = class_3518.method_15296((JsonObject)json, (String)"tool");
            class_1856 toolIn = class_1856.method_52177((JsonElement)toolObject);
            if (inputItemsIn.isEmpty()) {
                throw new JsonParseException("No ingredients for cutting recipe");
            }
            if (toolIn.method_8103()) {
                throw new JsonParseException("No tool for cutting recipe");
            }
            if (inputItemsIn.size() > 1) {
                throw new JsonParseException("Too many ingredients for cutting recipe! Please define only one ingredient");
            }
            class_2371<ChanceResult> results = Serializer.readResults(class_3518.method_15261((JsonObject)json, (String)"result"));
            if (results.size() > 4) {
                throw new JsonParseException("Too many results for cutting recipe! The maximum quantity of unique results is 4");
            }
            String soundID = class_3518.method_15253((JsonObject)json, (String)"sound", (String)"");
            return new CuttingBoardRecipe(recipeId, groupIn, (class_1856)inputItemsIn.get(0), toolIn, results, soundID);
        }

        private static class_2371<class_1856> readIngredients(JsonArray ingredientArray) {
            class_2371 nonnulllist = class_2371.method_10211();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_52177((JsonElement)ingredientArray.get(i));
                if (ingredient.method_8103()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        private static class_2371<ChanceResult> readResults(JsonArray resultArray) {
            class_2371 results = class_2371.method_10211();
            for (JsonElement result : resultArray) {
                results.add((Object)ChanceResult.deserialize(result));
            }
            return results;
        }

        @Nullable
        public CuttingBoardRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            String groupIn = buffer.method_10800(Short.MAX_VALUE);
            class_1856 inputItemIn = class_1856.method_8086((class_2540)buffer);
            class_1856 toolIn = class_1856.method_8086((class_2540)buffer);
            int i = buffer.method_10816();
            class_2371 resultsIn = class_2371.method_10213((int)i, (Object)ChanceResult.EMPTY);
            for (int j = 0; j < resultsIn.size(); ++j) {
                resultsIn.set(j, (Object)ChanceResult.read(buffer));
            }
            String soundEventIn = buffer.method_19772();
            return new CuttingBoardRecipe(recipeId, groupIn, inputItemIn, toolIn, (class_2371<ChanceResult>)resultsIn, soundEventIn);
        }

        public void toNetwork(class_2540 buffer, CuttingBoardRecipe recipe) {
            buffer.method_10814(recipe.group);
            recipe.input.method_8088(buffer);
            recipe.tool.method_8088(buffer);
            buffer.method_10804(recipe.results.size());
            for (ChanceResult result : recipe.results) {
                result.write(buffer);
            }
            buffer.method_10814(recipe.soundEvent);
        }
    }
}

