/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks;

import com.ordana.spelunkery.blocks.entity.FallingLayerEntity;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class FallingLayerBlock
extends class_2346 {
    public static final class_2758 LAYERS_8 = class_2741.field_12536;
    private static final class_265[] SHAPE_BY_LAYER = new class_265[9];
    private final int min;
    private final int max;

    public FallingLayerBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)this.layerProperty(), (Comparable)Integer.valueOf(1)));
        this.min = (Integer)Collections.min(this.layerProperty().method_11898());
        this.max = (Integer)Collections.max(this.layerProperty().method_11898());
    }

    public final int getMaxLayers() {
        return this.max;
    }

    public final int getMinLayers() {
        return this.min;
    }

    public class_2758 layerProperty() {
        return LAYERS_8;
    }

    public int getLayers(class_2680 state) {
        return (Integer)state.method_11654((class_2769)this.layerProperty());
    }

    protected void removeOneLayer(class_2680 state, class_2338 pos, class_1937 level) {
        int levels = this.getLayers(state);
        if (levels > 1) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)this.layerProperty(), (Comparable)Integer.valueOf(levels - 1)));
        } else {
            level.method_8650(pos, false);
        }
    }

    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (state.method_26204() != oldState.method_26204()) {
            worldIn.method_39279(pos, (class_2248)this, this.method_26154());
        }
    }

    public class_265 getDefaultShape(class_2680 state) {
        return SHAPE_BY_LAYER[(Integer)state.method_11654((class_2769)LAYERS_8)];
    }

    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return this.getDefaultShape(pState);
    }

    public class_265 method_25959(class_2680 pState, class_1922 pReader, class_2338 pPos) {
        return this.getDefaultShape(pState);
    }

    public class_265 method_26159(class_2680 pState, class_1922 pReader, class_2338 pPos, class_3726 pContext) {
        return this.getDefaultShape(pState);
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case class_10.field_50 -> {
                if (this.getLayers(state) < 5) {
                    yield true;
                }
                yield false;
            }
            case class_10.field_48 -> {
                if (this.getLayers(state) == 0) {
                    yield true;
                }
                yield false;
            }
            case class_10.field_51 -> false;
        };
    }

    public boolean method_9526(class_2680 state) {
        return true;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 facingState, class_1936 world, class_2338 currentPos, class_2338 otherPos) {
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            class_2338 pos = currentPos.method_10084();
            class_2680 state1 = world.method_8320(pos);
            while (state1.method_27852((class_2248)this)) {
                serverLevel.method_39279(pos, (class_2248)this, this.method_26154());
                pos = pos.method_10084();
                state1 = serverLevel.method_8320(pos);
            }
        }
        return super.method_9559(state, direction, facingState, world, currentPos, otherPos);
    }

    public boolean shouldFall(class_2680 belowState) {
        return (belowState.method_26215() || belowState.method_45474()) && !belowState.method_27852((class_2248)this);
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 pRand) {
        class_2680 below = level.method_8320(pos.method_10074());
        if ((this.shouldFall(below) || this.hasIncompletePileBelow(below)) && pos.method_10264() >= level.method_31607()) {
            while (state.method_27852((class_2248)this)) {
                FallingLayerEntity fallingblockentity = FallingLayerEntity.fall((class_1937)level, pos, state);
                this.method_10132(fallingblockentity);
                pos = pos.method_10084();
                state = level.method_8320(pos);
            }
        }
    }

    private boolean hasIncompletePileBelow(class_2680 state) {
        return state.method_27852((class_2248)this) && this.getLayers(state) != this.getMaxLayers();
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2680 blockstate = context.method_8045().method_8320(context.method_8037());
        if (blockstate.method_27852((class_2248)this)) {
            int i = this.getLayers(blockstate);
            return (class_2680)blockstate.method_11657((class_2769)this.layerProperty(), (Comparable)Integer.valueOf(Math.min(this.getMaxLayers(), i + 1)));
        }
        return super.method_9605(context);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{this.layerProperty()});
    }

    public boolean method_9616(class_2680 pState, class_1750 pUseContext) {
        int i = this.getLayers(pState);
        if (pUseContext.method_8041().method_31574(this.method_8389()) && i < this.getMaxLayers()) {
            return true;
        }
        return i == 1;
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.method_9530(state, level, pos, context);
    }

    public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float height) {
        super.method_9554(level, state, pos, entity, height);
    }

    static {
        Arrays.setAll(SHAPE_BY_LAYER, l -> class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(l * 2), (double)16.0));
        FallingLayerBlock.SHAPE_BY_LAYER[0] = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.1f, (double)16.0);
    }
}

