/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.registry;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_config.FC;
import me.fzzyhmstrs.fzzy_config.annotations.Action;
import me.fzzyhmstrs.fzzy_config.api.RegisterType;
import me.fzzyhmstrs.fzzy_config.api.SaveType;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigContext;
import me.fzzyhmstrs.fzzy_config.event.impl.EventApiImpl;
import me.fzzyhmstrs.fzzy_config.impl.ConfigApiImpl;
import me.fzzyhmstrs.fzzy_config.networking.ConfigPermissionsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigSyncS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.DynamicIdsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.FzzyPayload;
import me.fzzyhmstrs.fzzy_config.networking.NetworkEvents;
import me.fzzyhmstrs.fzzy_config.networking.SettingForwardCustomPayload;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.fzzyhmstrs.fzzy_config.util.PortingUtils;
import me.fzzyhmstrs.fzzy_config.util.ValidationResult;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003STUB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJG\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016JE\u0010\u001c\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJq\u0010$\u001a\u00020\u00142\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0004\b\"\u0010#J_\u0010,\u001a\u00020\u00142\u0006\u0010&\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0004\b*\u0010+J\u0015\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050-H\u0000\u00a2\u0006\u0004\b.\u0010/J;\u00109\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u00052\u0014\u00104\u001a\u0010\u0012\u0004\u0012\u00020%\u0012\u0006\u0012\u0004\u0018\u000103022\f\u00106\u001a\b\u0012\u0004\u0012\u00020305H\u0000\u00a2\u0006\u0004\b7\u00108J\u001f\u0010<\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0004\b:\u0010;J\u001f\u0010>\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0004\b=\u0010;J\u0017\u0010B\u001a\u00020?2\u0006\u0010'\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b@\u0010AJ\u0019\u0010F\u001a\u0004\u0018\u00010C2\u0006\u0010'\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\bD\u0010EJ\u001f\u0010L\u001a\u00020\u00142\u0006\u0010G\u001a\u00020C2\u0006\u0010I\u001a\u00020HH\u0000\u00a2\u0006\u0004\bJ\u0010KR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060M8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010NR \u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020P0O8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bQ\u0010R\u00a8\u0006V"}, d2={"Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry;", "", "<init>", "()V", "", "", "Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$SyncedConfigEntry;", "syncedConfigs$fzzy_config", "()Ljava/util/Map;", "syncedConfigs", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/server/MinecraftServer;", "server", "Ljava/util/function/BiPredicate;", "Lnet/minecraft/class_2960;", "canSender", "Ljava/util/function/BiConsumer;", "Lme/fzzyhmstrs/fzzy_config/networking/FzzyPayload;", "sender", "", "onJoin$fzzy_config", "(Lnet/minecraft/class_3222;Lnet/minecraft/server/MinecraftServer;Ljava/util/function/BiPredicate;Ljava/util/function/BiConsumer;)V", "onJoin", "", "players", "onEndDataReload$fzzy_config", "(Ljava/util/List;Ljava/util/function/BiPredicate;Ljava/util/function/BiConsumer;)V", "onEndDataReload", "serializedConfigs", "serverPlayer", "", "clientPerm", "changes", "receiveConfigUpdate$fzzy_config", "(Ljava/util/Map;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3222;ILjava/util/List;Ljava/util/function/BiPredicate;Ljava/util/function/BiConsumer;)V", "receiveConfigUpdate", "Ljava/util/UUID;", "uuid", "scope", "update", "summary", "receiveSettingForward$fzzy_config", "(Ljava/util/UUID;Lnet/minecraft/class_3222;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/function/BiPredicate;Ljava/util/function/BiConsumer;)V", "receiveSettingForward", "", "quarantineList$fzzy_config", "()Ljava/util/Set;", "quarantineList", "id", "Ljava/util/function/Function;", "Lnet/minecraft/class_2561;", "nameFinder", "Ljava/util/function/Consumer;", "messageSender", "inspectQuarantine$fzzy_config", "(Ljava/lang/String;Ljava/util/function/Function;Ljava/util/function/Consumer;)V", "inspectQuarantine", "acceptQuarantine$fzzy_config", "(Ljava/lang/String;Lnet/minecraft/server/MinecraftServer;)V", "acceptQuarantine", "rejectQuarantine$fzzy_config", "rejectQuarantine", "", "hasConfig$fzzy_config", "(Ljava/lang/String;)Z", "hasConfig", "Lme/fzzyhmstrs/fzzy_config/config/Config;", "getConfig$fzzy_config", "(Ljava/lang/String;)Lme/fzzyhmstrs/fzzy_config/config/Config;", "getConfig", "config", "Lme/fzzyhmstrs/fzzy_config/api/RegisterType;", "registerType", "registerConfig$fzzy_config", "(Lme/fzzyhmstrs/fzzy_config/config/Config;Lme/fzzyhmstrs/fzzy_config/api/RegisterType;)V", "registerConfig", "", "Ljava/util/Map;", "Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$LimitedHashMap;", "Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$QuarantinedUpdate;", "quarantinedUpdates", "Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$LimitedHashMap;", "LimitedHashMap", "QuarantinedUpdate", "SyncedConfigEntry", "fzzy_config"})
public final class SyncedConfigRegistry {
    @NotNull
    public static final SyncedConfigRegistry INSTANCE = new SyncedConfigRegistry();
    @NotNull
    private static final Map<String, SyncedConfigEntry> syncedConfigs = new LinkedHashMap();
    @NotNull
    private static final LimitedHashMap<String, QuarantinedUpdate> quarantinedUpdates = new LimitedHashMap();

    private SyncedConfigRegistry() {
    }

    @NotNull
    public final Map<String, SyncedConfigEntry> syncedConfigs$fzzy_config() {
        return syncedConfigs;
    }

    public final void onJoin$fzzy_config(@NotNull class_3222 player, @NotNull MinecraftServer server, @NotNull BiPredicate<class_3222, class_2960> canSender, @NotNull BiConsumer<class_3222, FzzyPayload> sender) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter(canSender, (String)"canSender");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        if (server.method_3724()) {
            ValidatedIdentifier.Companion.createSpSyncs$fzzy_config(PortingUtils.INSTANCE.getDynamicManager(player));
            return;
        }
        if (!canSender.test(player, ConfigPermissionsS2CCustomPayload.Companion.getId())) {
            return;
        }
        for (Map.Entry<String, SyncedConfigEntry> object : syncedConfigs.entrySet()) {
            String id = object.getKey();
            SyncedConfigEntry configEntry = object.getValue();
            if (configEntry.skipSync()) continue;
            Map<String, Boolean> perms = ConfigApiImpl.INSTANCE.generatePermissionsReport$fzzy_config((class_1657)player, configEntry, (byte)0);
            ConfigPermissionsS2CCustomPayload payload = new ConfigPermissionsS2CCustomPayload(id, perms);
            sender.accept(player, payload);
        }
        if (!canSender.test(player, DynamicIdsS2CCustomPayload.Companion.getType())) {
            return;
        }
        List<DynamicIdsS2CCustomPayload> dynamicIdSyncs = ValidatedIdentifier.Companion.createSyncs$fzzy_config(PortingUtils.INSTANCE.getDynamicManager(player));
        if (dynamicIdSyncs.isEmpty()) {
            return;
        }
        for (DynamicIdsS2CCustomPayload sync : dynamicIdSyncs) {
            sender.accept(player, sync);
        }
    }

    public final void onEndDataReload$fzzy_config(@NotNull List<? extends class_3222> players, @NotNull BiPredicate<class_3222, class_2960> canSender, @NotNull BiConsumer<class_3222, FzzyPayload> sender) {
        Intrinsics.checkNotNullParameter(players, (String)"players");
        Intrinsics.checkNotNullParameter(canSender, (String)"canSender");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        for (class_3222 class_32222 : players) {
            if (class_32222.field_13995.method_3724()) {
                ValidatedIdentifier.Companion.createSpSyncs$fzzy_config(PortingUtils.INSTANCE.getDynamicManager(class_32222));
                continue;
            }
            if (!canSender.test(class_32222, ConfigSyncS2CCustomPayload.Companion.getId())) continue;
            for (Map.Entry<String, SyncedConfigEntry> entry : syncedConfigs.entrySet()) {
                String id = entry.getKey();
                SyncedConfigEntry configEntry = entry.getValue();
                if (configEntry.skipSync()) continue;
                ValidationResult<ConfigSyncS2CCustomPayload> payloadResult = ValidationResult.Companion.map(ConfigApiImpl.serializeConfigSafe$fzzy_config$default(ConfigApiImpl.INSTANCE, configEntry.getConfig(), "Error encountered serializing config for S2C data reload sync.", (byte)0, null, 8, null), arg_0 -> SyncedConfigRegistry.onEndDataReload$lambda$0(id, arg_0)).log(ValidationResult.ErrorEntry.Companion.getENTRY_ERROR_LOGGER());
                sender.accept(class_32222, payloadResult.get());
                if (!canSender.test(class_32222, ConfigPermissionsS2CCustomPayload.Companion.getId())) continue;
                Map<String, Boolean> perms = ConfigApiImpl.INSTANCE.generatePermissionsReport$fzzy_config((class_1657)class_32222, configEntry, (byte)0);
                ConfigPermissionsS2CCustomPayload permsPayload = new ConfigPermissionsS2CCustomPayload(id, perms);
                sender.accept(class_32222, permsPayload);
                try {
                    configEntry.getConfig().onSyncServer();
                }
                catch (Throwable e) {
                    FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered with reload onSyncServer method of config " + id + ", for player " + class_32222 + "!", e);
                }
                try {
                    EventApiImpl.INSTANCE.fireOnSyncServer$fzzy_config(configEntry.getId(), configEntry.getConfig());
                }
                catch (Throwable e) {
                    FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered while running reload onSyncServer event for config " + id + ", for player " + class_32222 + "!", e);
                }
            }
            List<DynamicIdsS2CCustomPayload> dynamicIdSyncs = ValidatedIdentifier.Companion.createSyncs$fzzy_config(PortingUtils.INSTANCE.getDynamicManager(class_32222));
            if (dynamicIdSyncs.isEmpty()) continue;
            for (DynamicIdsS2CCustomPayload sync : dynamicIdSyncs) {
                sender.accept(class_32222, sync);
            }
        }
    }

    public final void receiveConfigUpdate$fzzy_config(@NotNull Map<String, String> serializedConfigs, @NotNull MinecraftServer server, @NotNull class_3222 serverPlayer, int clientPerm, @NotNull List<String> changes, @NotNull BiPredicate<class_3222, class_2960> canSender, @NotNull BiConsumer<class_3222, FzzyPayload> sender) {
        Intrinsics.checkNotNullParameter(serializedConfigs, (String)"serializedConfigs");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter(canSender, (String)"canSender");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        Map successfulUpdates = new LinkedHashMap();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        for (Map.Entry<String, String> entry : serializedConfigs.entrySet()) {
            ValidationResult<List<String>> validationResult;
            String id = entry.getKey();
            String configString = entry.getValue();
            SyncedConfigEntry configEntry = syncedConfigs.get(id);
            if (configEntry == null) {
                FC.INSTANCE.getLOGGER$fzzy_config().error("Config " + id + " wasn't found!, Skipping update");
                continue;
            }
            if (!server.method_3724() && (validationResult = ConfigApiImpl.INSTANCE.validatePermissions$fzzy_config(serverPlayer, id, configEntry.getConfig(), configString, clientPerm)).isError()) {
                FC.INSTANCE.getLOGGER$fzzy_config().error("Player [" + serverPlayer.method_5477() + "] may have tried to cheat changes onto the Server Config! Problem settings found: " + CollectionsKt.joinToString$default((Iterable)validationResult.get(), (CharSequence)" | ", null, null, (int)0, null, null, (int)62, null));
                FC.INSTANCE.getLOGGER$fzzy_config().error("This update has not been applied, and has been moved to quarantine. Use the configure_update command to inspect and permit or deny the update.");
                FC.INSTANCE.getLOGGER$fzzy_config().warn("If no action is taken, the quarantined update will be flushed on the next server restart, and its changes will not be applied");
                ConfigApiImpl.INSTANCE.printChangeHistory$fzzy_config(changes, serializedConfigs.keySet().toString(), (class_1657)serverPlayer);
                UUID uUID = serverPlayer.method_5667();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
                QuarantinedUpdate quarantine = new QuarantinedUpdate(uUID, changes, id, configString);
                String quarantineId = id + " @" + serverPlayer.method_5477().getString() + " @" + formatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(System.currentTimeMillis()), ZoneId.systemDefault()));
                ((Map)quarantinedUpdates).put(quarantineId, quarantine);
                for (class_3222 player : server.method_3760().method_14571()) {
                    Intrinsics.checkNotNull((Object)player);
                    if (ConfigApiImpl.INSTANCE.isConfigAdmin$fzzy_config((class_1657)player, configEntry.getConfig())) {
                        Object[] objectArray = new Object[]{serverPlayer.method_5477()};
                        player.method_43502((class_2561)FcText.INSTANCE.translate("fc.networking.permission.cheat", objectArray), false);
                    }
                    player.method_43502((class_2561)FcText.INSTANCE.translate("fc.command.accept", new Object[0]).method_27694(arg_0 -> SyncedConfigRegistry.receiveConfigUpdate$lambda$1(id, arg_0)), false);
                    player.method_43502((class_2561)FcText.INSTANCE.translate("fc.command.accept", new Object[0]).method_27694(arg_0 -> SyncedConfigRegistry.receiveConfigUpdate$lambda$2(id, arg_0)), false);
                    player.method_43502((class_2561)FcText.INSTANCE.translate("fc.command.accept", new Object[0]).method_27694(arg_0 -> SyncedConfigRegistry.receiveConfigUpdate$lambda$3(id, arg_0)), false);
                }
                continue;
            }
            ValidationResult<ConfigContext<Config>> result = ConfigApiImpl.INSTANCE.deserializeUpdate$fzzy_config(configEntry.getConfig(), configString, "Error(s) encountered while receiving config update for " + id, (byte)10).log(ValidationResult.ErrorEntry.Companion.getENTRY_ERROR_LOGGER());
            result.get().getConfig().save();
            if (result.test(ValidationResult.Errors.INSTANCE.getACTION(), SyncedConfigRegistry::receiveConfigUpdate$lambda$4)) {
                FC.INSTANCE.getLOGGER$fzzy_config().warn("The server has received a config update that may require a restart. Connected clients have been automatically updated and notified of the potential for restart.");
                if (result.has(ValidationResult.Errors.INSTANCE.getRESTART())) {
                    FC.INSTANCE.getLOGGER$fzzy_config().info("Server prompted for a restart due to received config changes");
                    FC.INSTANCE.getLOGGER$fzzy_config().info("Restart-prompting changes:");
                    for (ValidationResult.ErrorEntry.Entry<Action> record : result.iterate(ValidationResult.Errors.INSTANCE.getRESTART())) {
                        record.log(ValidationResult.ErrorEntry.Companion.getENTRY_INFO_LOGGER());
                    }
                }
            }
            successfulUpdates.put(id, configString);
            server.execute(() -> SyncedConfigRegistry.receiveConfigUpdate$lambda$5(configEntry, serverPlayer, id));
        }
        if (!server.method_3724()) {
            for (class_3222 player : serverPlayer.field_13995.method_3760().method_14571()) {
                if (Intrinsics.areEqual((Object)player, (Object)serverPlayer) || !canSender.test(player, ConfigUpdateS2CCustomPayload.Companion.getId())) continue;
                ConfigUpdateS2CCustomPayload newPayload = new ConfigUpdateS2CCustomPayload(successfulUpdates);
                sender.accept(player, newPayload);
            }
        }
        ConfigApiImpl.INSTANCE.printChangeHistory$fzzy_config(changes, serializedConfigs.keySet().toString(), (class_1657)serverPlayer);
    }

    public final void receiveSettingForward$fzzy_config(@NotNull UUID uuid, @NotNull class_3222 player, @NotNull String scope, @NotNull String update, @NotNull String summary, @NotNull BiPredicate<class_3222, class_2960> canSender, @NotNull BiConsumer<class_3222, FzzyPayload> sender) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
        Intrinsics.checkNotNullParameter(canSender, (String)"canSender");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        class_3222 class_32222 = player.field_13995.method_3760().method_14602(uuid);
        if (class_32222 == null) {
            return;
        }
        class_3222 receivingPlayer = class_32222;
        if (!canSender.test(receivingPlayer, SettingForwardCustomPayload.Companion.getId())) {
            player.method_43496((class_2561)FcText.INSTANCE.translate("fc.config.forwarded_error.s2c", new Object[0]));
            return;
        }
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        sender.accept(receivingPlayer, new SettingForwardCustomPayload(update, uUID, scope, summary));
    }

    @NotNull
    public final Set<String> quarantineList$fzzy_config() {
        Set<String> set = quarantinedUpdates.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    public final void inspectQuarantine$fzzy_config(@NotNull String id, @NotNull Function<UUID, class_2561> nameFinder, @NotNull Consumer<class_2561> messageSender) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(nameFinder, (String)"nameFinder");
        Intrinsics.checkNotNullParameter(messageSender, (String)"messageSender");
        QuarantinedUpdate quarantinedUpdate = (QuarantinedUpdate)quarantinedUpdates.get(id);
        if (quarantinedUpdate == null) {
            return;
        }
        QuarantinedUpdate quarantinedUpdate2 = quarantinedUpdate;
        messageSender.accept((class_2561)FcText.INSTANCE.translate("fc.command.config", new Object[0]));
        messageSender.accept((class_2561)FcText.INSTANCE.translate(quarantinedUpdate2.getConfigId(), new Object[0]));
        messageSender.accept((class_2561)FcText.INSTANCE.translate("fc.command.player", new Object[0]));
        String string = quarantinedUpdate2.getPlayerUuid().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        messageSender.accept((class_2561)FcText.INSTANCE.lit(string));
        class_2561 class_25612 = nameFinder.apply(quarantinedUpdate2.getPlayerUuid());
        if (class_25612 != null) {
            class_2561 it = class_25612;
            boolean bl = false;
            messageSender.accept(it);
        }
        messageSender.accept((class_2561)FcText.INSTANCE.translate("fc.command.history", new Object[0]));
        for (String str : quarantinedUpdate2.getChangeHistory()) {
            messageSender.accept((class_2561)FcText.INSTANCE.lit(str));
        }
        messageSender.accept((class_2561)FcText.INSTANCE.translate("fc.command.accept", new Object[0]).method_27694(arg_0 -> SyncedConfigRegistry.inspectQuarantine$lambda$7(id, arg_0)));
        messageSender.accept((class_2561)FcText.INSTANCE.translate("fc.command.reject", new Object[0]).method_27694(arg_0 -> SyncedConfigRegistry.inspectQuarantine$lambda$8(id, arg_0)));
    }

    public final void acceptQuarantine$fzzy_config(@NotNull String id, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        QuarantinedUpdate quarantinedUpdate = (QuarantinedUpdate)quarantinedUpdates.get(id);
        if (quarantinedUpdate == null) {
            return;
        }
        QuarantinedUpdate quarantinedUpdate2 = quarantinedUpdate;
        SyncedConfigEntry configEntry = syncedConfigs.get(quarantinedUpdate2.getConfigId());
        class_3222 player = server.method_3760().method_14602(quarantinedUpdate2.getPlayerUuid());
        if (configEntry != null) {
            ValidationResult<ConfigContext<Config>> result = ConfigApiImpl.INSTANCE.deserializeUpdate$fzzy_config(configEntry.getConfig(), quarantinedUpdate2.getConfigString(), "Error(s) encountered while receiving config update for " + id, (byte)10).log(ValidationResult.ErrorEntry.Companion.getENTRY_ERROR_LOGGER());
            result.get().getConfig().save();
            if (result.test(ValidationResult.Errors.INSTANCE.getACTION(), SyncedConfigRegistry::acceptQuarantine$lambda$9)) {
                FC.INSTANCE.getLOGGER$fzzy_config().warn("A quarantined update has been accepted that may require a restart. Connected clients have been automatically updated and notified of the potential for restart.");
                if (result.has(ValidationResult.Errors.INSTANCE.getRESTART())) {
                    FC.INSTANCE.getLOGGER$fzzy_config().info("Quarantined update requires a restart due to received config changes");
                    FC.INSTANCE.getLOGGER$fzzy_config().info("Restart-prompting updates:");
                    for (ValidationResult.ErrorEntry.Entry entry : result.iterate(ValidationResult.Errors.INSTANCE.getRESTART())) {
                        entry.log(ValidationResult.ErrorEntry.Companion.getENTRY_INFO_LOGGER());
                    }
                }
            }
            for (class_3222 class_32222 : server.method_3760().method_14571()) {
                if (Intrinsics.areEqual((Object)class_32222, (Object)player)) continue;
                Intrinsics.checkNotNull((Object)class_32222);
                if (!NetworkEvents.INSTANCE.canSend(class_32222, ConfigUpdateS2CCustomPayload.Companion.getId())) continue;
                ConfigUpdateS2CCustomPayload newPayload = new ConfigUpdateS2CCustomPayload(MapsKt.mapOf((Pair)TuplesKt.to((Object)quarantinedUpdate2.getConfigId(), (Object)quarantinedUpdate2.getConfigString())));
                NetworkEvents.INSTANCE.send(class_32222, newPayload);
            }
        }
        class_3222 class_32223 = player;
        if (class_32223 != null) {
            class_3222 it = class_32223;
            boolean bl = false;
            if (NetworkEvents.INSTANCE.canSend(player, ConfigPermissionsS2CCustomPayload.Companion.getId())) {
                for (Map.Entry<String, SyncedConfigEntry> entry : syncedConfigs.entrySet()) {
                    String id2 = entry.getKey();
                    SyncedConfigEntry config2 = entry.getValue();
                    Map<String, Boolean> perms = ConfigApiImpl.INSTANCE.generatePermissionsReport$fzzy_config((class_1657)player, config2, (byte)0);
                    class_2540 buf = PacketByteBufs.create();
                    ConfigPermissionsS2CCustomPayload payload = new ConfigPermissionsS2CCustomPayload(id2, perms);
                    NetworkEvents.INSTANCE.send(player, payload);
                }
            }
        }
        quarantinedUpdates.remove(id);
    }

    public final void rejectQuarantine$fzzy_config(@NotNull String id, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        quarantinedUpdates.remove(id);
    }

    public final boolean hasConfig$fzzy_config(@NotNull String scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return syncedConfigs.containsKey(scope);
    }

    @Nullable
    public final Config getConfig$fzzy_config(@NotNull String scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        SyncedConfigEntry syncedConfigEntry = syncedConfigs.get(scope);
        return syncedConfigEntry != null ? syncedConfigEntry.getConfig() : null;
    }

    public final synchronized void registerConfig$fzzy_config(@NotNull Config config, @NotNull RegisterType registerType) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)registerType), (String)"registerType");
        syncedConfigs.put(config.getId().method_42094(), new SyncedConfigEntry(config, registerType == RegisterType.SERVER));
        EventApiImpl.INSTANCE.fireOnRegisteredServer$fzzy_config(config.getId(), config);
    }

    private static final ConfigSyncS2CCustomPayload onEndDataReload$lambda$0(String $id, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ConfigSyncS2CCustomPayload($id, it);
    }

    private static final class_2583 receiveConfigUpdate$lambda$1(String $id, class_2583 s) {
        return s.method_10958(new class_2558(class_2558.class_2559.field_11750, "/configure_update \"" + $id + "\" inspect"));
    }

    private static final class_2583 receiveConfigUpdate$lambda$2(String $id, class_2583 s) {
        return s.method_10958(new class_2558(class_2558.class_2559.field_11750, "/configure_update \"" + $id + "\" accept"));
    }

    private static final class_2583 receiveConfigUpdate$lambda$3(String $id, class_2583 s) {
        return s.method_10958(new class_2558(class_2558.class_2559.field_11750, "/configure_update \"" + $id + "\" reject"));
    }

    private static final boolean receiveConfigUpdate$lambda$4(ValidationResult.ErrorEntry.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Action)((Object)it.getContent())).getRestartPrompt();
    }

    private static final void receiveConfigUpdate$lambda$5(SyncedConfigEntry $configEntry, class_3222 $serverPlayer, String $id) {
        try {
            $configEntry.getConfig().onUpdateServer($serverPlayer);
        }
        catch (Throwable e) {
            FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered with onUpdateServer method of config " + $id + "!", e);
        }
        try {
            EventApiImpl.INSTANCE.fireOnUpdateServer$fzzy_config($configEntry.getId(), $configEntry.getConfig(), $serverPlayer);
        }
        catch (Throwable e) {
            FC.INSTANCE.getLOGGER$fzzy_config().error("Error encountered while running onUpdateServer event for config " + $id + "!", e);
        }
    }

    private static final class_2583 inspectQuarantine$lambda$7(String $id, class_2583 s) {
        return s.method_10958(new class_2558(class_2558.class_2559.field_11750, "/configure_update \"" + $id + "\" accept"));
    }

    private static final class_2583 inspectQuarantine$lambda$8(String $id, class_2583 s) {
        return s.method_10958(new class_2558(class_2558.class_2559.field_11750, "/configure_update \"" + $id + "\" reject"));
    }

    private static final boolean acceptQuarantine$lambda$9(ValidationResult.ErrorEntry.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Action)((Object)it.getContent())).getRestartPrompt();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010'\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\t\u001a\u00020\b2\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0006H\u0014\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$LimitedHashMap;", "K", "V", "Ljava/util/LinkedHashMap;", "<init>", "()V", "", "eldest", "", "removeEldestEntry", "(Ljava/util/Map$Entry;)Z", "fzzy_config"})
    private static final class LimitedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        @Override
        protected boolean removeEldestEntry(@Nullable Map.Entry<K, V> eldest) {
            return this.size() > 128;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0007\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\b\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0011\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$QuarantinedUpdate;", "", "Ljava/util/UUID;", "playerUuid", "", "", "changeHistory", "configId", "configString", "<init>", "(Ljava/util/UUID;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "Ljava/util/UUID;", "getPlayerUuid", "()Ljava/util/UUID;", "Ljava/util/List;", "getChangeHistory", "()Ljava/util/List;", "Ljava/lang/String;", "getConfigId", "()Ljava/lang/String;", "getConfigString", "fzzy_config"})
    public static final class QuarantinedUpdate {
        @NotNull
        private final UUID playerUuid;
        @NotNull
        private final List<String> changeHistory;
        @NotNull
        private final String configId;
        @NotNull
        private final String configString;

        public QuarantinedUpdate(@NotNull UUID playerUuid, @NotNull List<String> changeHistory, @NotNull String configId, @NotNull String configString) {
            Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
            Intrinsics.checkNotNullParameter(changeHistory, (String)"changeHistory");
            Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
            Intrinsics.checkNotNullParameter((Object)configString, (String)"configString");
            this.playerUuid = playerUuid;
            this.changeHistory = changeHistory;
            this.configId = configId;
            this.configString = configString;
        }

        @NotNull
        public final UUID getPlayerUuid() {
            return this.playerUuid;
        }

        @NotNull
        public final List<String> getChangeHistory() {
            return this.changeHistory;
        }

        @NotNull
        public final String getConfigId() {
            return this.configId;
        }

        @NotNull
        public final String getConfigString() {
            return this.configString;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\tJ$\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0013\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\u000eR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\t\u00a8\u0006\u001f"}, d2={"Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$SyncedConfigEntry;", "", "Lme/fzzyhmstrs/fzzy_config/config/Config;", "config", "", "server", "<init>", "(Lme/fzzyhmstrs/fzzy_config/config/Config;Z)V", "skipSync", "()Z", "Lnet/minecraft/class_2960;", "getId", "()Lnet/minecraft/class_2960;", "component1", "()Lme/fzzyhmstrs/fzzy_config/config/Config;", "component2", "copy", "(Lme/fzzyhmstrs/fzzy_config/config/Config;Z)Lme/fzzyhmstrs/fzzy_config/registry/SyncedConfigRegistry$SyncedConfigEntry;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lme/fzzyhmstrs/fzzy_config/config/Config;", "getConfig", "Z", "getServer", "fzzy_config"})
    public static final class SyncedConfigEntry {
        @NotNull
        private final Config config;
        private final boolean server;

        public SyncedConfigEntry(@NotNull Config config, boolean server) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.config = config;
            this.server = server;
        }

        @NotNull
        public final Config getConfig() {
            return this.config;
        }

        public final boolean getServer() {
            return this.server;
        }

        public final boolean skipSync() {
            return this.config.saveType() == SaveType.SEPARATE && this.server;
        }

        @NotNull
        public final class_2960 getId() {
            return this.config.getId();
        }

        @NotNull
        public final Config component1() {
            return this.config;
        }

        public final boolean component2() {
            return this.server;
        }

        @NotNull
        public final SyncedConfigEntry copy(@NotNull Config config, boolean server) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new SyncedConfigEntry(config, server);
        }

        public static /* synthetic */ SyncedConfigEntry copy$default(SyncedConfigEntry syncedConfigEntry, Config config, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                config = syncedConfigEntry.config;
            }
            if ((n & 2) != 0) {
                bl = syncedConfigEntry.server;
            }
            return syncedConfigEntry.copy(config, bl);
        }

        @NotNull
        public String toString() {
            return "SyncedConfigEntry(config=" + this.config + ", server=" + this.server + ")";
        }

        public int hashCode() {
            int result = this.config.hashCode();
            result = result * 31 + Boolean.hashCode(this.server);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SyncedConfigEntry)) {
                return false;
            }
            SyncedConfigEntry syncedConfigEntry = (SyncedConfigEntry)other;
            if (!Intrinsics.areEqual((Object)this.config, (Object)syncedConfigEntry.config)) {
                return false;
            }
            return this.server == syncedConfigEntry.server;
        }
    }
}

