/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.would.entities;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.ordana.would.entities.ModBoatEntity;
import com.ordana.would.entities.ModChestBoatEntity;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4595;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7752;
import net.minecraft.class_7755;
import net.minecraft.class_7833;
import net.minecraft.class_881;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class ModBoatRenderer
extends class_881 {
    private final Map<ModBoatEntity.Type, Pair<class_2960, class_4595<class_1690>>> boatResources = (Map)Stream.of(ModBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new class_2960("would", ModBoatRenderer.getTextureLocation(type, pChestBoat)), this.createBoatModel(pContext, (ModBoatEntity.Type)((Object)type), pChestBoat))));

    public ModBoatRenderer(class_5617.class_5618 pContext, boolean pChestBoat) {
        super(pContext, pChestBoat);
    }

    private static String getTextureLocation(ModBoatEntity.Type pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    private class_4595<class_1690> createBoatModel(class_5617.class_5618 pContext, ModBoatEntity.Type pType, boolean pChestBoat) {
        class_5601 modellayerlocation = pChestBoat ? ModBoatRenderer.createChestBoatModelName(pType) : ModBoatRenderer.createBoatModelName(pType);
        class_630 modelpart = pContext.method_32167(modellayerlocation);
        return pChestBoat ? new class_7752(modelpart) : new class_554(modelpart);
    }

    public static class_5601 createBoatModelName(ModBoatEntity.Type pType) {
        return ModBoatRenderer.createLocation("boat/" + pType.getName(), "main");
    }

    public static class_5601 createChestBoatModelName(ModBoatEntity.Type pType) {
        return ModBoatRenderer.createLocation("chest_boat/" + pType.getName(), "main");
    }

    private static class_5601 createLocation(String pPath, String pModel) {
        return new class_5601(new class_2960("would", pPath), pModel);
    }

    @NotNull
    public class_2960 method_3891(class_1690 boat) {
        if (boat instanceof ModBoatEntity) {
            ModBoatEntity modBoat = (ModBoatEntity)boat;
            return (class_2960)this.boatResources.get((Object)modBoat.getModVariant()).getFirst();
        }
        if (boat instanceof ModChestBoatEntity) {
            ModChestBoatEntity modChestBoatEntity = (ModChestBoatEntity)boat;
            return (class_2960)this.boatResources.get((Object)modChestBoatEntity.getModVariant()).getFirst();
        }
        return null;
    }

    public void method_3888(class_1690 entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        Object boatEntity;
        float h;
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.375f, 0.0f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - entityYaw));
        float f = (float)entity.method_7533() - partialTicks;
        float g = entity.method_7554() - partialTicks;
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)f) * f * g / 10.0f * (float)entity.method_7543()));
        }
        if (!class_3532.method_15347((float)(h = entity.method_7547(partialTicks)), (float)0.0f)) {
            poseStack.method_22907(new Quaternionf().setAngleAxis(entity.method_7547(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<class_2960, class_4595<class_1690>> pair = null;
        class_2960 resourceLocation = null;
        class_4595 listModel = null;
        if (entity instanceof ModBoatEntity) {
            boatEntity = (ModBoatEntity)entity;
            pair = this.boatResources.get((Object)((ModBoatEntity)((Object)boatEntity)).getModVariant());
            resourceLocation = (class_2960)pair.getFirst();
            listModel = (class_4595)pair.getSecond();
        }
        if (entity instanceof ModChestBoatEntity) {
            boatEntity = (ModChestBoatEntity)entity;
            pair = this.boatResources.get((Object)((ModChestBoatEntity)((Object)boatEntity)).getModVariant());
            resourceLocation = (class_2960)pair.getFirst();
            listModel = (class_4595)pair.getSecond();
        }
        if (pair == null) {
            return;
        }
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        listModel.method_2819((class_1297)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexConsumer = buffer.getBuffer(listModel.method_23500(resourceLocation));
        listModel.method_2828(poseStack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.method_5869()) {
            class_4588 vertexConsumer2 = buffer.getBuffer(class_1921.method_23589());
            if (listModel instanceof class_7755) {
                class_7755 waterPatchModel = (class_7755)listModel;
                waterPatchModel.method_22954().method_22698(poseStack, vertexConsumer2, packedLight, class_4608.field_21444);
            }
        }
        poseStack.method_22909();
        if (this.method_3921((class_1297)entity)) {
            this.method_3926((class_1297)entity, entity.method_5476(), poseStack, buffer, packedLight);
        }
    }
}

