/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.model.assembly;

import com.copycatsplus.copycats.foundation.copycat.model.assembly.AssemblyTransform;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.MutableVec3;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.MutableVertex;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.Mutation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2350;

public class MutableQuad
implements AssemblyTransform.Transformable<MutableQuad> {
    public List<MutableVertex> vertices;
    @Nullable
    public class_2350 cullFace;
    public boolean disableFinalAutoCull = false;
    List<Mutation> mutations = new ArrayList<Mutation>();
    private static final double EPSILON = 0.05;

    public MutableQuad(List<MutableVertex> vertices, @Nullable class_2350 cullFace) {
        this.vertices = vertices;
        this.cullFace = cullFace;
    }

    public class_2350 computeLightFace() {
        MutableVec3 normal = this.computeFaceNormal();
        return switch (MutableQuad.longestAxis(normal.x, normal.y, normal.z)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> {
                if (normal.method_10216() > 0.0) {
                    yield class_2350.field_11034;
                }
                yield class_2350.field_11039;
            }
            case class_2350.class_2351.field_11052 -> {
                if (normal.method_10214() > 0.0) {
                    yield class_2350.field_11036;
                }
                yield class_2350.field_11033;
            }
            case class_2350.class_2351.field_11051 -> normal.method_10215() > 0.0 ? class_2350.field_11035 : class_2350.field_11043;
        };
    }

    public static class_2350.class_2351 longestAxis(double normalX, double normalY, double normalZ) {
        class_2350.class_2351 result = class_2350.class_2351.field_11052;
        double longest = Math.abs(normalY);
        double a = Math.abs(normalX);
        if (a > longest + 0.05) {
            result = class_2350.class_2351.field_11048;
            longest = a;
        }
        return Math.abs(normalZ) > longest + 0.05 ? class_2350.class_2351.field_11051 : result;
    }

    public MutableVec3 computeFaceNormal() {
        double y2 = this.vertices.get((int)2).xyz.y;
        double y0 = this.vertices.get((int)0).xyz.y;
        double dy0 = y2 - y0;
        double z3 = this.vertices.get((int)3).xyz.z;
        double z1 = this.vertices.get((int)1).xyz.z;
        double dz1 = z3 - z1;
        double z2 = this.vertices.get((int)2).xyz.z;
        double z0 = this.vertices.get((int)0).xyz.z;
        double dz0 = z2 - z0;
        double y3 = this.vertices.get((int)3).xyz.y;
        double y1 = this.vertices.get((int)1).xyz.y;
        double dy1 = y3 - y1;
        double normX = dy0 * dz1 - dz0 * dy1;
        double x3 = this.vertices.get((int)3).xyz.x;
        double x1 = this.vertices.get((int)1).xyz.x;
        double dx1 = x3 - x1;
        double x2 = this.vertices.get((int)2).xyz.x;
        double x0 = this.vertices.get((int)0).xyz.x;
        double dx0 = x2 - x0;
        double normY = dz0 * dx1 - dx0 * dz1;
        double normZ = dx0 * dy1 - dy0 * dx1;
        double l = (float)Math.sqrt(normX * normX + normY * normY + normZ * normZ);
        if (l != 0.0) {
            normX /= l;
            normY /= l;
            normZ /= l;
        }
        return new MutableVec3(normX, normY, normZ);
    }

    public MutableQuad mutate() {
        for (Mutation mutation : this.mutations) {
            for (MutableVertex vertex : this.vertices) {
                mutation.mutate(vertex.xyz);
            }
            if (mutation.type() == Mutation.MutationType.MIRROR) {
                this.reverseWinding();
            }
            this.cullFace = mutation.mutate(this.cullFace);
        }
        return this;
    }

    public MutableQuad undoMutate() {
        for (int i = this.mutations.size() - 1; i >= 0; --i) {
            Mutation mutation = this.mutations.get(i);
            for (MutableVertex vertex : this.vertices) {
                mutation.undoMutate(vertex.xyz);
            }
            if (mutation.type() == Mutation.MutationType.MIRROR) {
                this.reverseWinding();
            }
            this.cullFace = mutation.undoMutate(this.cullFace);
        }
        return this;
    }

    private void reverseWinding() {
        MutableVertex temp = this.vertices.get(0);
        this.vertices.set(0, this.vertices.get(1));
        this.vertices.set(1, temp);
        temp = this.vertices.get(2);
        this.vertices.set(2, this.vertices.get(3));
        this.vertices.set(3, temp);
    }

    @Override
    public MutableQuad rotateX(int angle) {
        this.mutations.add(new Mutation(Mutation.MutationType.ROTATE_X, angle));
        return this;
    }

    @Override
    public MutableQuad rotateY(int angle) {
        this.mutations.add(new Mutation(Mutation.MutationType.ROTATE_Y, angle));
        return this;
    }

    @Override
    public MutableQuad rotateZ(int angle) {
        this.mutations.add(new Mutation(Mutation.MutationType.ROTATE_Z, angle));
        return this;
    }

    @Override
    public MutableQuad flipX(boolean flip) {
        if (!flip) {
            return this;
        }
        this.mutations.add(new Mutation(Mutation.MutationType.MIRROR, 0));
        return this;
    }

    @Override
    public MutableQuad flipY(boolean flip) {
        if (!flip) {
            return this;
        }
        this.mutations.add(new Mutation(Mutation.MutationType.MIRROR, 1));
        return this;
    }

    @Override
    public MutableQuad flipZ(boolean flip) {
        if (!flip) {
            return this;
        }
        this.mutations.add(new Mutation(Mutation.MutationType.MIRROR, 2));
        return this;
    }
}

