/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.spookydoors.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.client.BlockHighlightDrawEvent;
import net.blay09.mods.balm.api.event.client.GuiDrawEvent;
import net.blay09.mods.spookydoors.block.SpookyDoorBlock;
import net.blay09.mods.spookydoors.block.entity.SpookyDoorBlockEntity;
import net.blay09.mods.spookydoors.client.ModRenderers;
import net.blay09.mods.spookydoors.client.render.SpookyDoorBlockEntityRenderer;
import net.blay09.mods.spookydoors.network.ServerboundOpenCloseDoorPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_761;

public class SpookyDoorsClient {
    private static final class_2960 UI_HINT_TEXTURE = new class_2960("spookydoors", "textures/gui/door_ui_hint.png");
    private static final int UI_HINT_TICKS = 20;
    private static final int SYNC_INTERVAL = 1;
    private static double lastMouseX;
    private static boolean isDragging;
    private static float accumulatedOpennessChange;
    private static SpookyDoorBlockEntity activeDoor;
    private static int ticksSinceLastSync;
    private static boolean isDirty;
    private static int uiHintTicksLeft;

    public static void initialize() {
        ModRenderers.initialize(BalmClient.getRenderers());
        Balm.getEvents().onEvent(GuiDrawEvent.Post.class, SpookyDoorsClient::onDrawGui);
        Balm.getEvents().onEvent(BlockHighlightDrawEvent.class, SpookyDoorsClient::onDrawHighlight);
        Balm.getEvents().onTickEvent(TickType.Client, TickPhase.End, SpookyDoorsClient::onClientTick);
    }

    public static void setActiveDoor(SpookyDoorBlockEntity activeDoor) {
        SpookyDoorsClient.activeDoor = activeDoor;
    }

    public static boolean onMoveMouse(long windowPointer, double x, double y) {
        if (activeDoor != null && isDragging) {
            boolean isPlayerBehind;
            class_2680 state = activeDoor.method_11010();
            class_2350 facing = (class_2350)state.method_11654((class_2769)SpookyDoorBlock.field_10938);
            class_2750 hinge = (class_2750)state.method_11654((class_2769)SpookyDoorBlock.field_10941);
            float openness = activeDoor.getOpenness();
            double deltaX = x - lastMouseX;
            class_746 player = class_310.method_1551().field_1724;
            class_2338 doorPos = activeDoor.method_11016();
            double relativeX = player.method_23317() - (double)doorPos.method_10263();
            double relativeZ = player.method_23321() - (double)doorPos.method_10260();
            switch (facing) {
                case field_11043: {
                    boolean bl;
                    if (relativeZ < 0.0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case field_11035: {
                    boolean bl;
                    if (relativeZ > 0.0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case field_11039: {
                    boolean bl;
                    if (relativeX < 0.0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case field_11034: {
                    boolean bl;
                    if (relativeX > 0.0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = isPlayerBehind = false;
                }
            }
            if (isPlayerBehind) {
                deltaX = -deltaX;
            }
            deltaX = hinge == class_2750.field_12588 ? -deltaX : deltaX;
            double sensitivity = 0.005;
            float currentOpenness = activeDoor.getOpenness();
            accumulatedOpennessChange += Math.abs((openness += (float)(deltaX * 0.005)) - currentOpenness);
            activeDoor.setOpennessBy(openness, (class_1297)player);
            isDirty = true;
            lastMouseX = x;
            return true;
        }
        return false;
    }

    private static void onDrawGui(GuiDrawEvent.Post event) {
        if (event.getElement() == GuiDrawEvent.Element.ALL && uiHintTicksLeft > 0) {
            class_332 guiGraphics = event.getGuiGraphics();
            class_4587 poseStack = guiGraphics.method_51448();
            RenderSystem.enableBlend();
            poseStack.method_22903();
            int screenCenterX = class_310.method_1551().method_22683().method_4486() / 2;
            int screenCenterY = class_310.method_1551().method_22683().method_4502() / 2;
            poseStack.method_46416((float)screenCenterX, (float)screenCenterY, 0.0f);
            poseStack.method_22905(0.4f, 0.4f, 0.4f);
            float alpha = (float)uiHintTicksLeft / 20.0f;
            guiGraphics.method_51422(1.0f, 1.0f, 1.0f, alpha);
            guiGraphics.method_25290(UI_HINT_TEXTURE, -23, -54, 0.0f, 0.0f, 46, 32, 46, 32);
            poseStack.method_22909();
        }
    }

    private static void onDrawHighlight(BlockHighlightDrawEvent event) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_2338 pos = event.getHitResult().method_17777();
        class_2680 state = level.method_8320(pos);
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof SpookyDoorBlockEntity) {
            SpookyDoorBlockEntity spookyDoor = (SpookyDoorBlockEntity)blockEntity;
            SpookyDoorBlockEntity baseDoor = spookyDoor.getBaseDoor();
            if (level.method_8621().method_11952(pos)) {
                class_243 cameraVec = event.getCamera().method_19326();
                double cameraX = cameraVec.method_10216();
                double cameraY = cameraVec.method_10214();
                double cameraZ = cameraVec.method_10215();
                class_4588 vertexConsumer = event.getMultiBufferSource().getBuffer(class_1921.method_23594());
                class_4587 poseStack = event.getPoseStack();
                poseStack.method_22903();
                poseStack.method_22904((double)pos.method_10263() - cameraX, (double)pos.method_10264() - cameraY, (double)pos.method_10260() - cameraZ);
                SpookyDoorBlockEntityRenderer.applyDoorPose(poseStack, baseDoor.getOpenness(), (class_2350)state.method_11654((class_2769)SpookyDoorBlock.field_10938), (class_2750)state.method_11654((class_2769)SpookyDoorBlock.field_10941));
                class_265 shape = SpookyDoorBlock.getOutlineShape(state);
                class_761.method_22983((class_4587)poseStack, (class_4588)vertexConsumer, (class_265)shape, (double)0.0, (double)0.0, (double)0.0, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f, (boolean)false);
                poseStack.method_22909();
            }
            event.setCanceled(true);
        }
    }

    private static void onClientTick(class_310 client) {
        if (!isDragging && activeDoor != null && !class_310.method_1551().field_1724.method_24515().equals((Object)activeDoor.method_11016())) {
            activeDoor = null;
        }
        if (++ticksSinceLastSync >= 1) {
            if (activeDoor != null && isDirty) {
                Balm.getNetworking().sendToServer((Object)new ServerboundOpenCloseDoorPacket(activeDoor.method_11016(), activeDoor.getOpenness()));
                isDirty = false;
            }
            ticksSinceLastSync = 0;
        }
        if (uiHintTicksLeft > 0) {
            --uiHintTicksLeft;
        }
    }

    public static boolean onMouseInput(int button, int action) {
        if (button == 1) {
            if (action == 1) {
                class_3965 blockHitResult;
                class_2338 pos;
                class_638 level;
                class_2586 blockEntity;
                class_239 hitResult = class_310.method_1551().field_1765;
                if (hitResult != null && hitResult.method_17783() == class_239.class_240.field_1332 && (blockEntity = (level = class_310.method_1551().field_1687).method_8321(pos = (blockHitResult = (class_3965)hitResult).method_17777())) instanceof SpookyDoorBlockEntity) {
                    SpookyDoorBlockEntity spookyDoor = (SpookyDoorBlockEntity)blockEntity;
                    class_1297 entity = class_310.method_1551().method_1560();
                    if (entity != null) {
                        lastMouseX = class_310.method_1551().field_1729.method_1603();
                        activeDoor = spookyDoor.getBaseDoor();
                        activeDoor.setClientControl(true);
                        isDragging = true;
                        return true;
                    }
                }
            } else if (action == 0) {
                if (activeDoor != null) {
                    if (isDirty) {
                        Balm.getNetworking().sendToServer((Object)new ServerboundOpenCloseDoorPacket(activeDoor.method_11016(), activeDoor.getOpenness()));
                        isDirty = false;
                    }
                    activeDoor.setClientControl(false);
                    if ((double)accumulatedOpennessChange < 0.1) {
                        uiHintTicksLeft = 20;
                    }
                    accumulatedOpennessChange = 0.0f;
                }
                isDragging = false;
                activeDoor = null;
            }
        }
        return false;
    }

    static {
        uiHintTicksLeft = 0;
    }
}

