/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.api.FluidFuelRegistry;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.NbtHelper;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantItemStorage;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5251;

public interface FluidFuelItemHelper {
    public static FluidVariant getFluid(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag == null ? FluidVariant.blank() : NbtHelper.getFluidCompatible(tag, "fluid");
    }

    public static void setFluid(class_1799 stack, FluidVariant fluid) {
        if (!fluid.isBlank()) {
            NbtHelper.putFluid(stack.method_7948(), "fluid", fluid);
        } else {
            stack.method_7983("fluid");
        }
    }

    public static long getAmount(class_1799 stack) {
        if (FluidFuelItemHelper.getFluid(stack).isBlank()) {
            return 0L;
        }
        class_2487 tag = stack.method_7969();
        if (tag != null) {
            return tag.method_10537("amt");
        }
        return 0L;
    }

    public static void setAmount(class_1799 stack, long amount) {
        if (amount != 0L) {
            stack.method_7948().method_10544("amt", amount);
        } else {
            stack.method_7983("amt");
            stack.method_7983("fluid");
        }
    }

    public static void decrement(class_1799 stack) {
        long amount = FluidFuelItemHelper.getAmount(stack);
        if (amount > 0L) {
            FluidFuelItemHelper.setAmount(stack, Math.max(0L, amount - 81L));
        }
    }

    public static void appendTooltip(class_1799 stack, List<class_2561> tooltip, long capacity) {
        class_2583 style = class_2583.field_24360.method_27703(class_5251.method_27717((int)0xA9A9A9)).method_10978(Boolean.valueOf(true));
        FluidVariant fluid = FluidFuelItemHelper.getFluid(stack);
        tooltip.add(FluidHelper.getFluidName(fluid, true));
        if (!fluid.isBlank()) {
            tooltip.add((class_2561)FluidHelper.getFluidAmount(FluidFuelItemHelper.getAmount(stack), capacity).method_10862(style));
        }
    }

    public static class ItemStorage
    extends SingleVariantItemStorage<FluidVariant> {
        private final long capacity;

        public ItemStorage(long capacity, ContainerItemContext ctx) {
            super(ctx);
            this.capacity = capacity;
        }

        protected FluidVariant getBlankResource() {
            return FluidVariant.blank();
        }

        protected FluidVariant getResource(ItemVariant currentVariant) {
            return FluidFuelItemHelper.getFluid(currentVariant.toStack());
        }

        protected long getAmount(ItemVariant currentVariant) {
            return FluidFuelItemHelper.getAmount(currentVariant.toStack());
        }

        protected long getCapacity(FluidVariant variant) {
            return this.capacity;
        }

        protected ItemVariant getUpdatedVariant(ItemVariant currentVariant, FluidVariant newResource, long newAmount) {
            class_1799 stack = currentVariant.toStack();
            FluidFuelItemHelper.setFluid(stack, newResource);
            FluidFuelItemHelper.setAmount(stack, newAmount);
            return ItemVariant.of((class_1799)stack);
        }

        protected boolean canInsert(FluidVariant resource) {
            return FluidFuelRegistry.getEu(resource.getFluid()) > 0;
        }
    }
}

