/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines;

import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.guicomponents.AutoExtractClient;
import aztech.modern_industrialization.machines.guicomponents.CraftingMultiblockGuiClient;
import aztech.modern_industrialization.machines.guicomponents.EnergyBarClient;
import aztech.modern_industrialization.machines.guicomponents.GunpowderOverclockGuiClient;
import aztech.modern_industrialization.machines.guicomponents.LargeTankFluidDisplayClient;
import aztech.modern_industrialization.machines.guicomponents.NuclearReactorGuiClient;
import aztech.modern_industrialization.machines.guicomponents.ProgressBarClient;
import aztech.modern_industrialization.machines.guicomponents.RecipeEfficiencyBarClient;
import aztech.modern_industrialization.machines.guicomponents.ReiSlotLockingClient;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelectionClient;
import aztech.modern_industrialization.machines.guicomponents.SlotPanelClient;
import aztech.modern_industrialization.machines.guicomponents.TemperatureBarClient;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public final class GuiComponentsClient {
    private static final Map<class_2960, GuiComponentClient.Factory> components = new HashMap<class_2960, GuiComponentClient.Factory>();

    public static GuiComponentClient.Factory get(class_2960 identifier) {
        return components.get(identifier);
    }

    public static void register(class_2960 id, GuiComponentClient.Factory clientFactory) {
        if (components.put(id, clientFactory) != null) {
            throw new RuntimeException("Duplicate registration of component identifier.");
        }
    }

    static {
        GuiComponentsClient.register(GuiComponents.AUTO_EXTRACT, AutoExtractClient::new);
        GuiComponentsClient.register(GuiComponents.CRAFTING_MULTIBLOCK_GUI, CraftingMultiblockGuiClient::new);
        GuiComponentsClient.register(GuiComponents.ENERGY_BAR, EnergyBarClient::new);
        GuiComponentsClient.register(GuiComponents.LARGE_TANK_FLUID_DISPLAY, LargeTankFluidDisplayClient::new);
        GuiComponentsClient.register(GuiComponents.GUNPOWDER_OVERCLOCK_GUI, GunpowderOverclockGuiClient::new);
        GuiComponentsClient.register(GuiComponents.NUCLEAR_REACTOR_GUI, NuclearReactorGuiClient::new);
        GuiComponentsClient.register(GuiComponents.PROGRESS_BAR, ProgressBarClient::new);
        GuiComponentsClient.register(GuiComponents.RECIPE_EFFICIENCY_BAR, RecipeEfficiencyBarClient::new);
        GuiComponentsClient.register(GuiComponents.REI_SLOT_LOCKING, ReiSlotLockingClient::new);
        GuiComponentsClient.register(GuiComponents.SHAPE_SELECTION, ShapeSelectionClient::new);
        GuiComponentsClient.register(GuiComponents.SLOT_PANEL, SlotPanelClient::new);
        GuiComponentsClient.register(GuiComponents.TEMPERATURE_BAR, TemperatureBarClient::new);
    }
}

