/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.DropableComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class UpgradeComponent
implements IComponent.ServerOnly,
DropableComponent {
    private class_1799 itemStack = class_1799.field_8037;
    private static final Map<class_2960, Long> UPGRADES = new HashMap<class_2960, Long>();

    public static long getExtraEu(class_1935 item) {
        return UPGRADES.getOrDefault(class_7923.field_41178.method_10221((Object)item.method_8389()), 0L);
    }

    public static void registerUpgrade(class_1935 item, long extraEu) {
        UpgradeComponent.registerUpgrade(class_7923.field_41178.method_10221((Object)item.method_8389()), extraEu);
    }

    public static void registerUpgrade(class_2960 itemId, long extraEu) {
        Objects.requireNonNull(itemId);
        if (extraEu <= 0L) {
            throw new IllegalArgumentException("extraEu must be positive");
        }
        if (UPGRADES.containsKey(itemId)) {
            throw new IllegalArgumentException("Upgrade already registered:" + itemId);
        }
        UPGRADES.put(itemId, extraEu);
    }

    @Override
    public void writeNbt(class_2487 tag) {
        tag.method_10566("upgradesItemStack", (class_2520)this.itemStack.method_7953(new class_2487()));
    }

    @Override
    public void readNbt(class_2487 tag) {
        this.itemStack = class_1799.method_7915((class_2487)tag.method_10562("upgradesItemStack"));
    }

    public class_1269 onUse(MachineBlockEntity be, class_1657 player, class_1268 hand) {
        class_1799 stackInHand = player.method_5998(hand);
        if (stackInHand.method_7960()) {
            return class_1269.field_5811;
        }
        if (UpgradeComponent.getExtraEu((class_1935)stackInHand.method_7909()) > 0L) {
            boolean changed = false;
            if (this.itemStack.method_7960()) {
                this.itemStack = stackInHand.method_7972();
                if (!player.method_7337()) {
                    stackInHand.method_7939(0);
                }
                changed = true;
            } else if (stackInHand.method_7909() == this.itemStack.method_7909()) {
                int maxAdded = Math.min(stackInHand.method_7947(), this.itemStack.method_7914() - this.itemStack.method_7947());
                changed = maxAdded > 0;
                this.itemStack.method_7933(maxAdded);
                if (!player.method_7337()) {
                    stackInHand.method_7934(maxAdded);
                }
            }
            if (changed) {
                be.method_5431();
                if (!be.method_10997().method_8608()) {
                    be.sync();
                }
                return class_1269.method_29236((boolean)be.method_10997().field_9236);
            }
        }
        return class_1269.field_5811;
    }

    public long getAddMaxEUPerTick() {
        if (this.itemStack.method_7960()) {
            return 0L;
        }
        return (long)this.itemStack.method_7947() * UpgradeComponent.getExtraEu((class_1935)this.itemStack.method_7909());
    }

    @Override
    public class_1799 getDrop() {
        return this.itemStack;
    }

    public void setStackServer(MachineBlockEntity be, class_1799 stack) {
        this.itemStack = stack;
        be.method_5431();
        be.sync();
    }

    static {
        UpgradeComponent.registerUpgrade((class_1935)MIItem.BASIC_UPGRADE.method_8389(), 2L);
        UpgradeComponent.registerUpgrade((class_1935)MIItem.ADVANCED_UPGRADE.method_8389(), 8L);
        UpgradeComponent.registerUpgrade((class_1935)MIItem.TURBO_UPGRADE.method_8389(), 32L);
        UpgradeComponent.registerUpgrade((class_1935)MIItem.HIGHLY_ADVANCED_UPGRADE.method_8389(), 128L);
        UpgradeComponent.registerUpgrade((class_1935)MIItem.QUANTUM_UPGRADE.method_8389(), 999999999L);
        KubeJSProxy.instance.fireRegisterUpgradesEvent();
    }
}

