/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.recipe.builder;

import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.materials.recipe.builder.MIRecipeBuilder;
import aztech.modern_industrialization.materials.recipe.builder.MaterialRecipeBuilder;
import aztech.modern_industrialization.recipe.json.ShapedRecipeJson;
import com.google.gson.Gson;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class ShapedRecipeBuilder
implements MaterialRecipeBuilder {
    private static final Gson GSON = new Gson();
    public final String recipeId;
    private final MaterialBuilder.RecipeContext context;
    private boolean canceled = false;
    private final String id;
    private final ShapedRecipeJson json;

    public ShapedRecipeBuilder(MaterialBuilder.RecipeContext context, PartKeyProvider result, int count, String id, String ... pattern) {
        this.recipeId = "craft/" + id;
        this.context = context;
        this.id = id;
        if (context.getPart(result) == null) {
            this.json = null;
            this.canceled = true;
        } else {
            this.json = new ShapedRecipeJson(context.getPart(result).getItemId(), count, pattern);
        }
        context.addRecipe(this);
    }

    public ShapedRecipeBuilder addPart(char key, PartKeyProvider part) {
        if (this.context.getPart(part) != null) {
            this.addInput(key, this.context.getPart(part).getItemId());
        } else {
            this.canceled = true;
        }
        return this;
    }

    public ShapedRecipeBuilder addTaggedPart(char key, PartKeyProvider part) {
        if (this.context.getPart(part) != null) {
            this.addInput(key, this.context.getPart(part).getTaggedItemId());
        } else {
            this.canceled = true;
        }
        return this;
    }

    public ShapedRecipeBuilder addInput(char key, class_6862<class_1792> tag) {
        return this.addInput(key, "#" + tag.comp_327().toString());
    }

    public ShapedRecipeBuilder addInput(char key, String maybeTag) {
        if (!this.canceled) {
            this.json.addInput(key, maybeTag);
        }
        return this;
    }

    public ShapedRecipeBuilder addInput(char key, class_1935 item) {
        return this.addInput(key, class_7923.field_41178.method_10221((Object)item.method_8389()).toString());
    }

    public ShapedRecipeBuilder exportToAssembler(int eu, int duration) {
        return this.exportToMachine(MIMachineRecipeTypes.ASSEMBLER, eu, duration, 1);
    }

    public ShapedRecipeBuilder exportToAssembler() {
        return this.exportToAssembler(8, 200);
    }

    public ShapedRecipeBuilder exportToMachine(MachineRecipeType machine, int eu, int duration, int division) {
        if (!this.canceled) {
            new MIRecipeBuilder(this.context, this.id, this.json.exportToMachine(machine, eu, duration, division));
        }
        return this;
    }

    public ShapedRecipeBuilder exportToMachine(MachineRecipeType machine) {
        return this.exportToMachine(machine, 2, (int)(200.0 * this.context.get(MaterialProperty.HARDNESS).timeFactor), 1);
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public String getRecipeId() {
        return this.recipeId;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void save(Consumer<class_2444> consumer) {
        if (!this.canceled) {
            this.json.validate();
            String fullId = "materials/" + this.context.getMaterialName() + "/" + this.recipeId;
            this.json.offerTo(consumer, fullId);
        }
    }
}

