/*
 * Decompiled with CFR 0.152.
 */
package at.randorf.want_of_building;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class Config {
    public int maxSize_building_wand = 1024;
    public int maxDurabillity_building_wand = 5000;
    public int maxSize_exchanging_wand = 256;
    public int maxDurabillity_exchanging_wand = 1024;
    private String configName = "better-to-build.json";

    public void initConfig() {
        JsonObject config;
        File jsonFile = new File("config/" + this.configName);
        if (!jsonFile.exists()) {
            this.createConfig();
        }
        if ((config = this.getConfig()) != null) {
            this.maxSize_building_wand = config.get("maxSize_building_wand").getAsInt();
            this.maxDurabillity_building_wand = config.get("maxDurabillity_building_wand").getAsInt();
            this.maxSize_exchanging_wand = config.get("maxSize_exchanging_wand").getAsInt();
            this.maxDurabillity_exchanging_wand = config.get("maxDurabillity_exchanging_wand").getAsInt();
        }
    }

    private void createConfig() {
        JsonObject obj = new JsonObject();
        obj.addProperty("maxSize_building_wand", (Number)this.maxSize_building_wand);
        obj.addProperty("maxDurabillity_building_wand", (Number)this.maxDurabillity_building_wand);
        obj.addProperty("maxSize_exchanging_wand", (Number)this.maxSize_exchanging_wand);
        obj.addProperty("maxDurabillity_exchanging_wand", (Number)this.maxDurabillity_exchanging_wand);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonString = gson.toJson((JsonElement)obj);
        try (FileWriter writer = new FileWriter("config/" + this.configName);){
            writer.write(jsonString);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JsonObject getConfig() {
        String jsonFilePath = "config/" + this.configName;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(jsonFilePath));
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse((Reader)bufferedReader);
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                return jsonObject;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

