/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.client.widgets;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.client.gui.MathExpressionParser;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ConfirmableTextField;
import appeng.core.localization.GuiText;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.mixin.accessors.EditBoxMixin;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_5250;

public class NumberField
extends ConfirmableTextField {
    private static final int PADDING = 10;
    private static final int WIDTH = 52;
    private static final int HEIGHT = 12;
    private static final int TEXT_COLOR = 0xFFFFFF;
    private static final int ERROR_COLOR = 0xFF0000;
    private static final int MIN_VALUE = 0;
    private final String name;
    private final DecimalFormat decimalFormat;
    private NumberEntryType type = NumberEntryType.UNITLESS;
    private boolean isFluid;

    NumberField(int x, int y, String name, ScreenStyle style, Consumer<Long> onConfirm) {
        super(style, class_310.method_1551().field_1772, x, y, 52, 12);
        this.name = name;
        this.decimalFormat = new DecimalFormat("#.######", new DecimalFormatSymbols());
        this.decimalFormat.setParseBigDecimal(true);
        this.decimalFormat.setNegativePrefix("-");
        this.method_1858(false);
        this.method_1862(true);
        this.method_1880(7);
        this.setLongValue(0L);
        this.method_1863(text -> this.validate());
        this.setOnConfirm(() -> {
            if (this.getLongValue().isPresent()) {
                onConfirm.accept(this.getLongValue().getAsLong());
                this.method_25365(false);
            }
        });
        this.validate();
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partial) {
        super.method_48579(guiGraphics, mouseX, mouseY, partial);
        if (!this.isFluid) {
            return;
        }
        guiGraphics.method_51433(class_310.method_1551().field_1772, "B", this.method_46426() + 52 - 10, this.method_46427(), 0x545454, false);
    }

    private void validate() {
        ArrayList<class_5250> validationErrors = new ArrayList<class_5250>();
        ArrayList<class_2561> infoMessages = new ArrayList<class_2561>();
        Optional<BigDecimal> possibleValue = this.getValueInternal();
        if (possibleValue.isPresent()) {
            if (possibleValue.get().scale() > 0) {
                validationErrors.add(Utils.translate("tooltip", "whole_number", new Object[0]));
            } else {
                long value = this.convertToExternalValue(possibleValue.get());
                if (value < 0L) {
                    String formatted = this.decimalFormat.format(this.convertToInternalValue(0L));
                    validationErrors.add(GuiText.NumberLessThanMinValue.text(new Object[]{formatted}));
                } else if (!this.isNumber()) {
                    infoMessages.add((class_2561)class_2561.method_43470((String)("= " + this.decimalFormat.format(possibleValue.get()))));
                }
            }
        } else {
            validationErrors.add(GuiText.InvalidNumber.text());
        }
        boolean valid = validationErrors.isEmpty();
        ArrayList<class_2561> tooltip = valid ? infoMessages : validationErrors;
        this.method_1868(valid ? 0xFFFFFF : 0xFF0000);
        this.setTooltipMessage(tooltip);
    }

    private long convertToExternalValue(BigDecimal internalValue) {
        BigDecimal multiplicand = BigDecimal.valueOf(this.type.amountPerUnit());
        BigDecimal value = internalValue.multiply(multiplicand, MathContext.DECIMAL128);
        value = value.setScale(0, RoundingMode.UP);
        return value.longValue();
    }

    private BigDecimal convertToInternalValue(long externalValue) {
        BigDecimal divisor = BigDecimal.valueOf(this.type.amountPerUnit());
        return BigDecimal.valueOf(externalValue).divide(divisor, MathContext.DECIMAL128);
    }

    OptionalLong getLongValue() {
        Optional<BigDecimal> internalValue = this.getValueInternal();
        if (internalValue.isEmpty()) {
            return OptionalLong.empty();
        }
        long externalValue = this.convertToExternalValue(internalValue.get());
        if (externalValue < 0L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(externalValue);
    }

    void setLongValue(long value) {
        BigDecimal internalValue = this.convertToInternalValue(Math.max(value, 0L));
        this.method_1852(this.decimalFormat.format(internalValue));
        this.method_1872();
        this.validate();
    }

    private boolean isNumber() {
        ParsePosition position = new ParsePosition(0);
        String textValue = this.method_1882().trim();
        this.decimalFormat.parse(textValue, position);
        return position.getErrorIndex() == -1 && position.getIndex() == textValue.length();
    }

    private Optional<BigDecimal> getValueInternal() {
        return MathExpressionParser.parse((String)this.method_1882(), (DecimalFormat)this.decimalFormat);
    }

    public void setTooltipMessage(List<class_2561> tooltipMessage) {
        tooltipMessage.add(0, (class_2561)Utils.translate("tooltip", this.name, new Object[0]));
        super.setTooltipMessage(tooltipMessage);
        if (!this.method_25370() || tooltipMessage.size() > 1 && !tooltipMessage.get(1).getString().startsWith("=")) {
            return;
        }
        tooltipMessage.add((class_2561)class_2561.method_43470((String)"\u00bb ").method_27692(class_124.field_1075).method_10852((class_2561)Utils.translate("tooltip", "enter_to_submit", class_3675.method_15981((String)"key.keyboard.enter").method_27445()).method_27692(class_124.field_1080)));
    }

    public void method_25365(boolean isFocused) {
        if (isFocused && !Utils.cast((Object)this, EditBoxMixin.class).merequester$isEditable()) {
            return;
        }
        super.method_25365(isFocused);
    }

    void adjustToType(@Nullable AEKey key) {
        this.isFluid = key instanceof AEFluidKey;
        this.type = NumberEntryType.of((AEKey)key);
        if (this.isFluid) {
            this.method_25358(32);
        } else {
            this.method_25358(42);
        }
    }
}

