/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageWatcherNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.stacks.AEKey;
import appeng.api.storage.StorageHelper;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.me.helpers.MachineSource;
import appeng.util.SettingsFrom;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.platform.Platform;
import com.almostreliable.merequester.requester.Requests;
import com.almostreliable.merequester.requester.StorageManager;
import com.almostreliable.merequester.requester.abstraction.RequestHost;
import com.almostreliable.merequester.requester.status.LinkState;
import com.almostreliable.merequester.requester.status.RequestStatus;
import com.almostreliable.merequester.requester.status.StatusState;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class RequesterBlockEntity
extends AENetworkBlockEntity
implements RequestHost,
IGridTickable,
ICraftingRequester {
    private static final String REQUESTS_ID = "requests";
    private static final String REQUEST_STATUS_ID = "request_status";
    private static final String STORAGE_MANAGER_ID = "storage_manager";
    private final Requests requests;
    private final StatusState[] requestStatus;
    private final StorageManager storageManager;
    private final IActionSource actionSource;
    private TickRateModulation currentTickRate = TickRateModulation.IDLE;

    public RequesterBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.requests = new Requests(this);
        this.requestStatus = new StatusState[Platform.getRequestLimit()];
        Arrays.fill(this.requestStatus, StatusState.IDLE);
        this.storageManager = new StorageManager(this);
        this.actionSource = new MachineSource((IActionHost)this);
        this.getMainNode().setExposedOnSides(this.getExposedSides()).addService(IGridTickable.class, (IGridNodeService)this).addService(ICraftingRequester.class, (IGridNodeService)this).addService(IStorageWatcherNode.class, (IGridNodeService)this.storageManager).setIdlePowerUsage(Platform.getIdleEnergy());
        if (Platform.requireChannel()) {
            this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        }
    }

    public void loadTag(class_2487 tag) {
        super.loadTag(tag);
        if (tag.method_10545(REQUESTS_ID)) {
            this.requests.deserialize(tag.method_10562(REQUESTS_ID));
        }
        if (tag.method_10545(REQUEST_STATUS_ID)) {
            this.deserializeStatus(tag.method_10562(REQUEST_STATUS_ID));
        }
        if (tag.method_10545(STORAGE_MANAGER_ID)) {
            this.storageManager.deserialize(tag.method_10562(STORAGE_MANAGER_ID));
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10566(REQUESTS_ID, (class_2520)this.requests.serialize());
        tag.method_10566(REQUEST_STATUS_ID, (class_2520)this.serializeStatus());
        tag.method_10566(STORAGE_MANAGER_ID, (class_2520)this.storageManager.serialize());
    }

    public void importSettings(SettingsFrom mode, class_2487 input, @Nullable class_1657 player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.MEMORY_CARD && input.method_10545(REQUESTS_ID)) {
            this.requests.deserialize(input.method_10562(REQUESTS_ID));
        }
    }

    public void exportSettings(SettingsFrom mode, class_2487 output, @Nullable class_1657 player) {
        super.exportSettings(mode, output, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            output.method_10566(REQUESTS_ID, (class_2520)this.requests.serialize());
        }
    }

    public void onReady() {
        this.getMainNode().setExposedOnSides(this.getExposedSides());
        super.onReady();
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.field_11863 == null || this.field_11863.field_9236 || !this.getMainNode().isActive()) {
            return TickRateModulation.IDLE;
        }
        if (this.handleRequests()) {
            this.method_5431();
        }
        return this.currentTickRate;
    }

    @Override
    public void requestChanged(int index) {
        this.storageManager.clear(index);
        this.saveChanges();
    }

    @Override
    public Requests getRequests() {
        return this.requests;
    }

    @Override
    public class_2561 getTerminalName() {
        return this.method_16914() ? Objects.requireNonNull(this.method_5797()) : Utils.translate("block", "requester", new Object[0]);
    }

    protected void onOrientationChanged(BlockOrientation orientation) {
        super.onOrientationChanged(orientation);
        this.getMainNode().setExposedOnSides(this.getExposedSides());
    }

    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        super.addAdditionalDrops(level, pos, drops);
        this.storageManager.addDrops(drops);
    }

    private void deserializeStatus(class_2487 tag) {
        for (int i = 0; i < this.requestStatus.length; ++i) {
            if (!tag.method_10545(String.valueOf(i))) continue;
            class_2487 stateTag = tag.method_10562(String.valueOf(i));
            ICraftingLink link = StorageHelper.loadCraftingLink((class_2487)stateTag, (ICraftingRequester)this);
            this.requestStatus[i] = new LinkState(link);
        }
    }

    private class_2487 serializeStatus() {
        class_2487 tag = new class_2487();
        for (int i = 0; i < this.requestStatus.length; ++i) {
            StatusState state = this.requestStatus[i];
            if (!(state instanceof LinkState)) continue;
            LinkState cls = (LinkState)state;
            class_2487 stateTag = new class_2487();
            cls.link().writeToNBT(stateTag);
            tag.method_10566(String.valueOf(i), (class_2520)stateTag);
        }
        return tag;
    }

    private boolean handleRequests() {
        boolean changed = false;
        TickRateModulation tickRateModulation = TickRateModulation.IDLE;
        for (int i = 0; i < this.requestStatus.length; ++i) {
            TickRateModulation resultTickRateModulation;
            StatusState state = this.requestStatus[i];
            StatusState result = this.handleRequest(i);
            if (!Objects.equals(state, result)) {
                changed = true;
            }
            if ((resultTickRateModulation = result.getTickRateModulation()).ordinal() > tickRateModulation.ordinal()) {
                tickRateModulation = resultTickRateModulation;
            }
            this.updateRequestStatus(i, result);
        }
        this.currentTickRate = tickRateModulation;
        return changed;
    }

    private StatusState handleRequest(int slot) {
        StatusState state = this.requestStatus[slot];
        this.updateRequestStatus(slot, state.handle(this, slot));
        if (this.requestStatus[slot].type() != RequestStatus.IDLE && !Objects.equals(this.requestStatus[slot], state)) {
            return this.handleRequest(slot);
        }
        return this.requestStatus[slot];
    }

    private void updateRequestStatus(int slot, StatusState state) {
        this.requestStatus[slot] = state;
        if (state.type().translateToClient() != this.requests.get(slot).getClientStatus()) {
            this.requests.get(slot).setClientStatus(state.type().translateToClient());
            this.markForUpdate();
        }
    }

    private EnumSet<class_2350> getExposedSides() {
        EnumSet<class_2350> exposedSides = EnumSet.allOf(class_2350.class);
        exposedSides.remove(this.getFront());
        return exposedSides;
    }

    boolean isActive() {
        return Arrays.stream(this.requestStatus).anyMatch(p -> p.type().translateToClient() != RequestStatus.IDLE);
    }

    public IGrid getMainNodeGrid() {
        IGrid grid = this.getMainNode().getGrid();
        Objects.requireNonNull(grid, "RequesterBlockEntity was not fully initialized - Grid is null");
        return grid;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public IActionSource getActionSource() {
        return this.actionSource;
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return (ImmutableSet)Arrays.stream(this.requestStatus).filter(LinkState.class::isInstance).map(state -> ((LinkState)state).link()).collect(ImmutableSet.toImmutableSet());
    }

    public long insertCraftedItems(ICraftingLink link, AEKey what, long amount, Actionable mode) {
        for (int i = 0; i < this.requestStatus.length; ++i) {
            LinkState cls;
            StatusState state = this.requestStatus[i];
            if (!(state instanceof LinkState) || !(cls = (LinkState)state).link().equals(link)) continue;
            if (mode != Actionable.SIMULATE) {
                this.storageManager.get(i).update(what, amount);
            }
            return amount;
        }
        throw new IllegalStateException("No CraftingLinkState found");
    }

    public void jobStateChange(ICraftingLink link) {
    }

    public long getSortValue() {
        return (long)this.field_11867.method_10260() << 24 ^ (long)this.field_11867.method_10263() << 8 ^ (long)this.field_11867.method_10264();
    }
}

