/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers.patternprovider;

import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.MEStorage;
import appeng.helpers.patternprovider.PatternProviderTarget;
import appeng.me.storage.CompositeStorage;
import appeng.parts.automation.StackWorldBehaviors;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

class PatternProviderTargetCache {
    private final BlockApiCache<MEStorage, class_2350> cache;
    private final class_2350 direction;
    private final IActionSource src;
    private final Map<AEKeyType, ExternalStorageStrategy> strategies;

    PatternProviderTargetCache(class_3218 l, class_2338 pos, class_2350 direction, IActionSource src) {
        this.cache = BlockApiCache.create(MEStorage.SIDED, (class_3218)l, (class_2338)pos);
        this.direction = direction;
        this.src = src;
        this.strategies = StackWorldBehaviors.createExternalStorageStrategies(l, pos, direction);
    }

    @Nullable
    PatternProviderTarget find() {
        MEStorage meStorage = (MEStorage)this.cache.find((Object)this.direction);
        if (meStorage != null) {
            return this.wrapMeStorage(meStorage);
        }
        IdentityHashMap<AEKeyType, MEStorage> externalStorages = new IdentityHashMap<AEKeyType, MEStorage>(2);
        for (Map.Entry<AEKeyType, ExternalStorageStrategy> entry : this.strategies.entrySet()) {
            MEStorage wrapper = entry.getValue().createWrapper(false, () -> {});
            if (wrapper == null) continue;
            externalStorages.put(entry.getKey(), wrapper);
        }
        if (externalStorages.size() > 0) {
            return this.wrapMeStorage(new CompositeStorage(externalStorages));
        }
        return null;
    }

    private PatternProviderTarget wrapMeStorage(final MEStorage storage) {
        return new PatternProviderTarget(){

            @Override
            public long insert(AEKey what, long amount, Actionable type) {
                return storage.insert(what, amount, type, PatternProviderTargetCache.this.src);
            }

            @Override
            public boolean containsPatternInput(Set<AEKey> patternInputs) {
                for (Object2LongMap.Entry<AEKey> stack : storage.getAvailableStacks()) {
                    if (!patternInputs.contains(((AEKey)stack.getKey()).dropSecondary())) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

