/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.emi;

import appeng.core.localization.ItemModText;
import appeng.integration.modules.emi.AbstractRecipeHandler;
import appeng.integration.modules.jeirei.CraftingHelper;
import appeng.menu.me.items.CraftingTermMenu;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_465;
import net.minecraft.class_7710;

public class EmiUseCraftingRecipeHandler<T extends CraftingTermMenu>
extends AbstractRecipeHandler<T> {
    public EmiUseCraftingRecipeHandler(Class<T> containerClass) {
        super(containerClass);
    }

    @Override
    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory().equals(VanillaEmiRecipeCategories.CRAFTING);
    }

    @Override
    protected AbstractRecipeHandler.Result transferRecipe(T menu, class_1860<?> recipeBase, EmiRecipe emiRecipe, boolean doTransfer) {
        Map<Integer, class_1856> slotToIngredientMap;
        CraftingTermMenu.MissingIngredientSlots missingSlots;
        boolean craftingRecipe;
        class_1860<?> recipe = null;
        if (recipeBase instanceof class_1860) {
            recipe = recipeBase;
        }
        if (!(craftingRecipe = this.isCraftingRecipe(recipe, emiRecipe))) {
            return AbstractRecipeHandler.Result.createNotApplicable();
        }
        if (!this.fitsIn3x3Grid(recipe, emiRecipe)) {
            return AbstractRecipeHandler.Result.createFailed((class_2561)ItemModText.RECIPE_TOO_LARGE.text());
        }
        if (recipe == null) {
            recipe = this.createFakeRecipe(emiRecipe);
        }
        if ((missingSlots = ((CraftingTermMenu)menu).findMissingIngredients(slotToIngredientMap = EmiUseCraftingRecipeHandler.getGuiSlotToIngredientMap(recipe))).missingSlots().size() == slotToIngredientMap.size()) {
            return AbstractRecipeHandler.Result.createFailed((class_2561)ItemModText.NO_ITEMS.text(), missingSlots.missingSlots());
        }
        if (!doTransfer) {
            if (missingSlots.anyMissingOrCraftable()) {
                return new AbstractRecipeHandler.Result.PartiallyCraftable(missingSlots);
            }
        } else {
            boolean craftMissing = class_465.method_25441();
            CraftingHelper.performTransfer(menu, recipe, craftMissing);
        }
        return AbstractRecipeHandler.Result.createSuccessful();
    }

    private class_1860<?> createFakeRecipe(EmiRecipe display) {
        class_2371 ingredients = class_2371.method_10213((int)9, (Object)class_1856.field_9017);
        for (int i = 0; i < Math.min(display.getInputs().size(), ingredients.size()); ++i) {
            class_1856 ingredient = class_1856.method_26964(((EmiIngredient)display.getInputs().get(i)).getEmiStacks().stream().map(EmiStack::getItemStack).filter(is -> !is.method_7960()));
            ingredients.set(i, (Object)ingredient);
        }
        return new class_1869(new class_2960(""), "", class_7710.field_40251, 3, 3, ingredients, class_1799.field_8037);
    }

    public static Map<Integer, class_1856> getGuiSlotToIngredientMap(class_1860<?> recipe) {
        int width;
        class_2371 ingredients = recipe.method_8117();
        if (recipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)recipe;
            width = shapedRecipe.method_8150();
        } else {
            width = 3;
        }
        HashMap<Integer, class_1856> result = new HashMap<Integer, class_1856>(ingredients.size());
        for (int i = 0; i < ingredients.size(); ++i) {
            int guiSlot = i / width * 3 + i % width;
            class_1856 ingredient = (class_1856)ingredients.get(i);
            if (ingredient.method_8103()) continue;
            result.put(guiSlot, ingredient);
        }
        return result;
    }
}

