/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.localization.ItemModText;
import appeng.integration.modules.jei.JEIPlugin;
import appeng.integration.modules.jei.ViewBasedCategory;
import appeng.integration.modules.jei.widgets.Label;
import appeng.integration.modules.jei.widgets.View;
import appeng.integration.modules.jei.widgets.Widget;
import appeng.integration.modules.jei.widgets.WidgetFactory;
import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;

public class EntropyManipulatorCategory
extends ViewBasedCategory<EntropyRecipe> {
    public static final RecipeType<EntropyRecipe> TYPE = RecipeType.create((String)"ae2", (String)"entropy", EntropyRecipe.class);
    private final IDrawable slotBackground;
    private final IDrawable background;
    private final IDrawable icon;
    private final IPlatformFluidHelper<?> fluidHelper;
    private final IDrawable blockDestroyOverlay;
    private final IDrawable iconHeat;
    private final IDrawable iconCool;
    private final int centerX;

    public EntropyManipulatorCategory(IJeiHelpers helpers) {
        super(helpers);
        IGuiHelper guiHelper = helpers.getGuiHelper();
        this.slotBackground = guiHelper.getSlotDrawable();
        this.background = guiHelper.createBlankDrawable(130, 50);
        this.fluidHelper = helpers.getPlatformFluidHelper();
        this.icon = guiHelper.drawableBuilder(AppEng.makeId("textures/item/entropy_manipulator.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.blockDestroyOverlay = guiHelper.createDrawable(JEIPlugin.TEXTURE, 0, 52, 16, 16);
        this.iconHeat = guiHelper.createDrawable(JEIPlugin.TEXTURE, 0, 68, 6, 6);
        this.iconCool = guiHelper.createDrawable(JEIPlugin.TEXTURE, 6, 68, 6, 6);
        this.centerX = this.background.getWidth() / 2;
    }

    @Override
    protected View getView(final EntropyRecipe recipe) {
        return new View(){

            @Override
            public void createWidgets(WidgetFactory factory, List<Widget> widgets) {
                IDrawable icon = switch (recipe.getMode()) {
                    default -> throw new IncompatibleClassChangeError();
                    case EntropyMode.HEAT -> EntropyManipulatorCategory.this.iconHeat;
                    case EntropyMode.COOL -> EntropyManipulatorCategory.this.iconCool;
                };
                class_5250 labelText = switch (recipe.getMode()) {
                    default -> throw new IncompatibleClassChangeError();
                    case EntropyMode.HEAT -> ItemModText.ENTROPY_MANIPULATOR_HEAT.text(1600);
                    case EntropyMode.COOL -> ItemModText.ENTROPY_MANIPULATOR_COOL.text(1600);
                };
                class_5250 interaction = switch (recipe.getMode()) {
                    default -> throw new IncompatibleClassChangeError();
                    case EntropyMode.HEAT -> ItemModText.RIGHT_CLICK.text();
                    case EntropyMode.COOL -> ItemModText.SHIFT_RIGHT_CLICK.text();
                };
                Label modeLabel = factory.label(EntropyManipulatorCategory.this.centerX + 4, 2.0f, (class_2561)labelText).bodyText();
                widgets.add(modeLabel);
                widgets.add(factory.drawable(modeLabel.getBounds().method_3321() - 9, 3, icon));
                widgets.add(factory.unfilledArrow(EntropyManipulatorCategory.this.centerX - 12, 14));
                widgets.add(factory.label(EntropyManipulatorCategory.this.centerX, 38.0f, (class_2561)interaction).bodyText());
            }

            @Override
            public void buildSlots(IRecipeLayoutBuilder builder) {
                IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, EntropyManipulatorCategory.this.centerX - 36, 15).setBackground(EntropyManipulatorCategory.this.slotBackground, -1, -1);
                EntropyManipulatorCategory.this.setFluidOrBlockSlot(input, recipe.getInputBlock(), recipe.getInputFluid());
                int x = EntropyManipulatorCategory.this.centerX + 20;
                if (recipe.getOutputBlock() == class_2246.field_10124 && (recipe.getOutputFluid() == null || recipe.getOutputFluid() == class_3612.field_15906)) {
                    IRecipeSlotBuilder destroyed = builder.addSlot(RecipeIngredientRole.RENDER_ONLY, x, 15).setBackground(EntropyManipulatorCategory.this.slotBackground, -1, -1);
                    EntropyManipulatorCategory.this.setFluidOrBlockSlot(destroyed, recipe.getInputBlock(), recipe.getInputFluid());
                    destroyed.setOverlay(EntropyManipulatorCategory.this.blockDestroyOverlay, 0, 0);
                    destroyed.addTooltipCallback((recipeSlotView, tooltip) -> tooltip.add(ItemModText.CONSUMED.text().method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})));
                    x += 18;
                } else if (recipe.getOutputBlock() != null || recipe.getOutputFluid() != null) {
                    IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, x, 15).setBackground(EntropyManipulatorCategory.this.slotBackground, -1, -1);
                    EntropyManipulatorCategory.this.setFluidOrBlockSlot(output, recipe.getOutputBlock(), recipe.getOutputFluid());
                    x += 18;
                }
                for (class_1799 drop : recipe.getDrops()) {
                    IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, x, 15).setBackground(EntropyManipulatorCategory.this.slotBackground, -1, -1);
                    output.addItemStack(drop);
                    x += 18;
                }
            }
        };
    }

    private void setFluidOrBlockSlot(IRecipeSlotBuilder slot, class_2248 block, class_3611 fluid) {
        if (fluid != null) {
            if (!fluid.method_15793(fluid.method_15785())) {
                if (fluid instanceof class_3609) {
                    class_3609 flowingFluid = (class_3609)fluid;
                    slot.addFluidStack(flowingFluid.method_15751(), this.fluidHelper.bucketVolume());
                } else {
                    slot.addFluidStack(fluid, this.fluidHelper.bucketVolume());
                    AELog.warn("Don't know how to get the source fluid for %s", fluid);
                }
                slot.addTooltipCallback((recipeSlotView, tooltip) -> {
                    class_2561 firstLine = (class_2561)tooltip.get(0);
                    tooltip.set(0, ItemModText.FLOWING_FLUID_NAME.text(firstLine));
                });
            } else {
                slot.addFluidStack(fluid, this.fluidHelper.bucketVolume());
            }
        } else if (block != null) {
            slot.addItemStack(block.method_8389().method_7854());
        }
    }

    public RecipeType<EntropyRecipe> getRecipeType() {
        return TYPE;
    }

    public class_2561 getTitle() {
        return AEItems.ENTROPY_MANIPULATOR.method_8389().method_7848();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

