/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jeirei;

import appeng.api.util.AEColor;
import appeng.core.AEConfig;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.items.parts.FacadeItem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public final class ItemPredicates {
    private ItemPredicates() {
    }

    public static boolean shouldBeHidden(class_1799 stack) {
        if (ItemPredicates.isInternal(stack)) {
            return true;
        }
        if (!AEConfig.instance().isDebugToolsEnabled() && ItemPredicates.isDeveloperTool(stack)) {
            return true;
        }
        if (!AEConfig.instance().isEnableFacadesInJEI() && ItemPredicates.isFacade(stack)) {
            return true;
        }
        return AEConfig.instance().isDisableColoredCableRecipesInJEI() && ItemPredicates.isColoredCable(stack);
    }

    private static boolean isInternal(class_1799 stack) {
        return AEItems.WRAPPED_GENERIC_STACK.isSameAs(stack) || ItemPredicates.isBrokenFacade(stack) || AEBlocks.CABLE_BUS.isSameAs(stack) || AEBlocks.MATRIX_FRAME.isSameAs(stack) || AEBlocks.PAINT.isSameAs(stack);
    }

    private static boolean isBrokenFacade(class_1799 stack) {
        FacadeItem i;
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof FacadeItem && (i = (FacadeItem)class_17922).getTextureItem(stack).equals(class_1799.field_8037);
    }

    private static boolean isFacade(class_1799 stack) {
        return stack.method_7909() instanceof FacadeItem;
    }

    private static boolean isDeveloperTool(class_1799 stack) {
        return AEBlocks.DEBUG_CUBE_GEN.isSameAs(stack) || AEBlocks.DEBUG_ENERGY_GEN.isSameAs(stack) || AEBlocks.DEBUG_ITEM_GEN.isSameAs(stack) || AEBlocks.DEBUG_PHANTOM_NODE.isSameAs(stack) || AEItems.DEBUG_CARD.isSameAs(stack) || AEItems.DEBUG_ERASER.isSameAs(stack) || AEItems.DEBUG_METEORITE_PLACER.isSameAs(stack) || AEItems.DEBUG_REPLICATOR_CARD.isSameAs(stack);
    }

    private static boolean isColoredCable(class_1799 stack) {
        for (AEColor color : AEColor.values()) {
            if (color == AEColor.TRANSPARENT || stack.method_7909() != AEParts.COVERED_CABLE.item(color) && stack.method_7909() != AEParts.COVERED_DENSE_CABLE.item(color) && stack.method_7909() != AEParts.GLASS_CABLE.item(color) && stack.method_7909() != AEParts.SMART_CABLE.item(color) && stack.method_7909() != AEParts.SMART_DENSE_CABLE.item(color)) continue;
            return true;
        }
        return false;
    }
}

