/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.items;

import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.storage.ITerminalHost;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.IMenuCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IClientRepo;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.crafting.CraftConfirmMenu;
import appeng.menu.slot.CraftingMatrixSlot;
import appeng.menu.slot.CraftingTermSlot;
import appeng.parts.reporting.CraftingTerminalPart;
import appeng.util.inv.PlayerInternalInventory;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_8566;

public class CraftingTermMenu
extends MEStorageMenu
implements IMenuCraftingPacket {
    public static final class_3917<CraftingTermMenu> TYPE = MenuTypeBuilder.create(CraftingTermMenu::new, ITerminalHost.class).build("craftingterm");
    private static final String ACTION_CLEAR_TO_PLAYER = "clearToPlayer";
    private final ISegmentedInventory craftingInventoryHost;
    private final CraftingMatrixSlot[] craftingSlots = new CraftingMatrixSlot[9];
    private final class_8566 recipeTestContainer = new class_1715((class_1703)this, 3, 3);
    private final CraftingTermSlot outputSlot;
    private class_1860<class_8566> currentRecipe;

    public CraftingTermMenu(int id, class_1661 ip, ITerminalHost host) {
        this(TYPE, id, ip, host, true);
    }

    public CraftingTermMenu(class_3917<?> menuType, int id, class_1661 ip, ITerminalHost host, boolean bindInventory) {
        super(menuType, id, ip, host, bindInventory);
        this.craftingInventoryHost = (ISegmentedInventory)((Object)host);
        InternalInventory craftingGridInv = this.craftingInventoryHost.getSubInventory(CraftingTerminalPart.INV_CRAFTING);
        for (int i = 0; i < 9; ++i) {
            this.craftingSlots[i] = new CraftingMatrixSlot(this, craftingGridInv, i);
            this.addSlot(this.craftingSlots[i], SlotSemantics.CRAFTING_GRID);
        }
        this.outputSlot = new CraftingTermSlot(this.getPlayerInventory().field_7546, this.getActionSource(), this.powerSource, host.getInventory(), craftingGridInv, craftingGridInv, this);
        this.addSlot(this.outputSlot, SlotSemantics.CRAFTING_RESULT);
        this.updateCurrentRecipeAndOutput(true);
        this.registerClientAction(ACTION_CLEAR_TO_PLAYER, this::clearToPlayerInventory);
    }

    public void method_7609(class_1263 inventory) {
        if (inventory != this.recipeTestContainer) {
            this.updateCurrentRecipeAndOutput(false);
        }
    }

    private void updateCurrentRecipeAndOutput(boolean forceUpdate) {
        boolean hasChanged = forceUpdate;
        for (int x = 0; x < 9; ++x) {
            class_1799 stack = this.craftingSlots[x].method_7677();
            if (class_1799.method_31577((class_1799)stack, (class_1799)this.recipeTestContainer.method_5438(x))) continue;
            hasChanged = true;
            this.recipeTestContainer.method_5447(x, stack.method_7972());
        }
        if (!hasChanged) {
            return;
        }
        class_1937 level = this.getPlayerInventory().field_7546.method_37908();
        this.currentRecipe = level.method_8433().method_8132(class_3956.field_17545, (class_1263)this.recipeTestContainer, level).orElse(null);
        if (this.currentRecipe == null) {
            this.outputSlot.method_7673(class_1799.field_8037);
        } else {
            this.outputSlot.method_7673(this.currentRecipe.method_8116((class_1263)this.recipeTestContainer, level.method_30349()));
        }
    }

    @Override
    public InternalInventory getCraftingMatrix() {
        return this.craftingInventoryHost.getSubInventory(CraftingTerminalPart.INV_CRAFTING);
    }

    @Override
    public boolean useRealItems() {
        return true;
    }

    @Override
    public void startAutoCrafting(List<IMenuCraftingPacket.AutoCraftEntry> toCraft) {
        CraftConfirmMenu.openWithCraftingList(this.getActionHost(), (class_3222)this.getPlayer(), this.getLocator(), toCraft);
    }

    public class_1860<class_8566> getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void clearCraftingGrid() {
        Preconditions.checkState((boolean)this.isClientSide());
        CraftingMatrixSlot slot = this.craftingSlots[0];
        InventoryActionPacket p = new InventoryActionPacket(InventoryAction.MOVE_REGION, slot.field_7874, 0L);
        NetworkHandler.instance().sendToServer(p);
    }

    @Override
    public boolean hasItemType(class_1799 itemStack, int amount) {
        for (class_1735 slot : this.getSlots(SlotSemantics.CRAFTING_GRID)) {
            class_1799 stackInSlot = slot.method_7677();
            if (stackInSlot.method_7960() || !class_1799.method_31577((class_1799)itemStack, (class_1799)stackInSlot)) continue;
            if (itemStack.method_7947() >= amount) {
                return true;
            }
            amount -= itemStack.method_7947();
        }
        return super.hasItemType(itemStack, amount);
    }

    public MissingIngredientSlots findMissingIngredients(Map<Integer, class_1856> ingredients) {
        HashSet<Integer> missingSlots = new HashSet<Integer>();
        HashSet<Integer> craftableSlots = new HashSet<Integer>();
        Object2IntOpenHashMap reservedGridAmounts = new Object2IntOpenHashMap();
        class_2371 playerItems = this.getPlayerInventory().field_7547;
        int[] reservedPlayerItems = new int[playerItems.size()];
        for (Map.Entry<Integer, class_1856> entry : ingredients.entrySet()) {
            class_1799 stack;
            int n;
            class_1856 ingredient = entry.getValue();
            boolean found = false;
            for (int i = 0; i < playerItems.size(); ++i) {
                class_1799 stack2;
                if (this.isPlayerInventorySlotLocked(i) || (stack2 = (class_1799)playerItems.get(i)).method_7947() - reservedPlayerItems[i] <= 0 || !ingredient.method_8093(stack2)) continue;
                int n2 = i;
                reservedPlayerItems[n2] = reservedPlayerItems[n2] + 1;
                found = true;
                break;
            }
            if (!found) {
                class_1799[] class_1799Array = ingredient.method_8105();
                int n3 = class_1799Array.length;
                for (n = 0; n < n3; ++n) {
                    stack = class_1799Array[n];
                    AEItemKey itemKey = AEItemKey.of(stack);
                    int reservedAmount = reservedGridAmounts.getOrDefault((Object)itemKey, 0) + 1;
                    if (!this.hasItemType(stack, reservedAmount)) continue;
                    reservedGridAmounts.put((Object)itemKey, reservedAmount);
                    found = true;
                    break;
                }
            }
            if (!found) {
                class_1799[] class_1799Array = ingredient.method_8105();
                int n4 = class_1799Array.length;
                for (n = 0; n < n4; ++n) {
                    stack = class_1799Array[n];
                    if (!this.isCraftable(stack)) continue;
                    craftableSlots.add(entry.getKey());
                    found = true;
                    break;
                }
            }
            if (found) continue;
            missingSlots.add(entry.getKey());
        }
        return new MissingIngredientSlots(missingSlots, craftableSlots);
    }

    protected boolean isCraftable(class_1799 itemStack) {
        IClientRepo clientRepo = this.getClientRepo();
        if (clientRepo != null) {
            for (GridInventoryEntry stack : clientRepo.getAllEntries()) {
                if (!AEItemKey.matches(stack.getWhat(), itemStack) || !stack.isCraftable()) continue;
                return true;
            }
        }
        return false;
    }

    public void clearToPlayerInventory() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CLEAR_TO_PLAYER);
            return;
        }
        InternalInventory craftingGridInv = this.craftingInventoryHost.getSubInventory(CraftingTerminalPart.INV_CRAFTING);
        PlayerInternalInventory playerInv = new PlayerInternalInventory(this.getPlayerInventory());
        for (int i = 0; i < craftingGridInv.size(); ++i) {
            for (int emptyLoop = 0; emptyLoop < 2; ++emptyLoop) {
                boolean allowEmpty = emptyLoop == 1;
                int HOTBAR_SIZE = 9;
                int j = 9;
                while (j-- > 0) {
                    if (playerInv.getStackInSlot(j).method_7960() != allowEmpty) continue;
                    craftingGridInv.setItemDirect(i, playerInv.getSlotInv(j).addItems(craftingGridInv.getStackInSlot(i)));
                }
                for (j = 9; j < 36; ++j) {
                    if (playerInv.getStackInSlot(j).method_7960() != allowEmpty) continue;
                    craftingGridInv.setItemDirect(i, playerInv.getSlotInv(j).addItems(craftingGridInv.getStackInSlot(i)));
                }
            }
        }
    }

    public record MissingIngredientSlots(Set<Integer> missingSlots, Set<Integer> craftableSlots) {
        public int totalSize() {
            return this.missingSlots.size() + this.craftableSlots.size();
        }

        public boolean anyMissing() {
            return this.missingSlots.size() > 0;
        }

        public boolean anyCraftable() {
            return this.craftableSlots.size() > 0;
        }

        public boolean anyMissingOrCraftable() {
            return this.anyMissing() || this.anyCraftable();
        }
    }
}

