/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.createenchantablemachinery.content.block.fan;

import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingTypeRegistry;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.cotrin8672.createenchantablemachinery.util.extension.ItemEntityExtensionKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\fJ'\u0010\r\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u0013J\u001f\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lio/github/cotrin8672/createenchantablemachinery/content/block/fan/EnchantableFanProcessing;", "", "", "efficiencyLevel", "<init>", "(I)V", "Lnet/minecraft/class_1542;", "entity", "Lcom/simibubi/create/content/kinetics/fan/processing/FanProcessingType;", "type", "", "canProcess", "(Lnet/minecraft/class_1542;Lcom/simibubi/create/content/kinetics/fan/processing/FanProcessingType;)Z", "applyProcessing", "Lcom/simibubi/create/content/kinetics/belt/transport/TransportedItemStack;", "transported", "Lnet/minecraft/class_1937;", "world", "Lcom/simibubi/create/content/kinetics/belt/behaviour/TransportedItemStackHandlerBehaviour$TransportedResult;", "(Lcom/simibubi/create/content/kinetics/belt/transport/TransportedItemStack;Lnet/minecraft/class_1937;Lcom/simibubi/create/content/kinetics/fan/processing/FanProcessingType;)Lcom/simibubi/create/content/kinetics/belt/behaviour/TransportedItemStackHandlerBehaviour$TransportedResult;", "decrementProcessingTime", "(Lnet/minecraft/class_1542;Lcom/simibubi/create/content/kinetics/fan/processing/FanProcessingType;)I", "I", "createenchantablemachinery"})
public final class EnchantableFanProcessing {
    private final int efficiencyLevel;

    public EnchantableFanProcessing(int efficiencyLevel) {
        this.efficiencyLevel = efficiencyLevel;
    }

    public final boolean canProcess(@NotNull class_1542 entity, @NotNull FanProcessingType type) {
        class_2487 compound;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (ItemEntityExtensionKt.getEntityPersistentData(entity).method_10545("CreateData") && (compound = ItemEntityExtensionKt.getEntityPersistentData(entity).method_10562("CreateData")).method_10545("Processing")) {
            class_2487 processing = compound.method_10562("Processing");
            if (AllFanProcessingTypes.parseLegacy((String)processing.method_10558("Type")) != type) {
                return type.canProcess(entity.method_6983(), entity.method_37908());
            }
            if (processing.method_10550("Time") >= 0) {
                return true;
            }
            if (processing.method_10550("Time") == -1) {
                return false;
            }
        }
        return type.canProcess(entity.method_6983(), entity.method_37908());
    }

    public final boolean applyProcessing(@NotNull class_1542 entity, @NotNull FanProcessingType type) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (this.decrementProcessingTime(entity, type) != 0) {
            return false;
        }
        List list = type.process(entity.method_6983(), entity.method_37908());
        if (list == null) {
            return false;
        }
        List stacks = list;
        if (stacks.isEmpty()) {
            entity.method_31472();
            return false;
        }
        entity.method_6979((class_1799)stacks.remove(0));
        for (class_1799 additional : stacks) {
            class_1542 entityIn = new class_1542(entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321(), additional);
            entityIn.method_18799(entity.method_18798());
            entity.method_37908().method_8649((class_1297)entityIn);
        }
        return true;
    }

    @NotNull
    public final TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing(@NotNull TransportedItemStack transported, @Nullable class_1937 world, @NotNull FanProcessingType type) {
        Intrinsics.checkNotNullParameter((Object)transported, (String)"transported");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        TransportedItemStackHandlerBehaviour.TransportedResult ignore = TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        if (transported.processedBy != type) {
            transported.processedBy = type;
            int timeModifierForStackSize = (transported.stack.method_7947() - 1) / 16 + 1;
            double efficiencyLevelModifier = this.efficiencyLevel == 0 ? 1.0 : Math.pow(this.efficiencyLevel, 1.5);
            int processingTime = ((Number)AllConfigs.server().kinetics.fanProcessingTime.get()).intValue() * timeModifierForStackSize + 1;
            transported.processingTime = (int)((double)processingTime / efficiencyLevelModifier);
            if (!type.canProcess(transported.stack, world)) {
                transported.processingTime = -1;
            }
            Intrinsics.checkNotNull((Object)ignore);
            return ignore;
        }
        if (transported.processingTime == -1) {
            Intrinsics.checkNotNull((Object)ignore);
            return ignore;
        }
        int timeModifierForStackSize = transported.processingTime;
        transported.processingTime = timeModifierForStackSize + -1;
        if (timeModifierForStackSize > 0) {
            Intrinsics.checkNotNull((Object)ignore);
            return ignore;
        }
        List list = type.process(transported.stack, world);
        if (list == null) {
            Intrinsics.checkNotNull((Object)ignore);
            return ignore;
        }
        List stacks = list;
        List transportedStacks = new ArrayList();
        for (class_1799 additional : stacks) {
            TransportedItemStack newTransported = transported.getSimilar();
            newTransported.stack = additional.method_7972();
            Intrinsics.checkNotNull((Object)newTransported);
            transportedStacks.add(newTransported);
        }
        TransportedItemStackHandlerBehaviour.TransportedResult transportedResult = TransportedItemStackHandlerBehaviour.TransportedResult.convertTo((List)transportedStacks);
        Intrinsics.checkNotNullExpressionValue((Object)transportedResult, (String)"convertTo(...)");
        return transportedResult;
    }

    private final int decrementProcessingTime(class_1542 entity, FanProcessingType type) {
        class_2487 processing;
        class_2487 createData;
        class_2487 nbt = ItemEntityExtensionKt.getEntityPersistentData(entity);
        if (!nbt.method_10545("CreateData")) {
            nbt.method_10566("CreateData", (class_2520)new class_2487());
        }
        if (!(createData = nbt.method_10562("CreateData")).method_10545("Processing")) {
            createData.method_10566("Processing", (class_2520)new class_2487());
        }
        if (!(processing = createData.method_10562("Processing")).method_10545("Type") || AllFanProcessingTypes.parseLegacy((String)processing.method_10558("Type")) != type) {
            processing.method_10582("Type", FanProcessingTypeRegistry.getIdOrThrow((FanProcessingType)type).toString());
            int timeModifierForStackSize = (entity.method_6983().method_7947() - 1) / 16 + 1;
            double efficiencyLevelModifier = this.efficiencyLevel == 0 ? 1.0 : Math.pow(this.efficiencyLevel, 1.5);
            int processingTime = ((Number)AllConfigs.server().kinetics.fanProcessingTime.get()).intValue() * timeModifierForStackSize + 1;
            processing.method_10569("Time", (int)((double)processingTime / efficiencyLevelModifier));
        }
        int value = processing.method_10550("Time") - 1;
        processing.method_10569("Time", value);
        return value;
    }
}

