/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.archEx;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.compat.archEx.ArchExGroup;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.content.decoration.palettes.PaletteBlockPattern;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_7403;
import org.jetbrains.annotations.NotNull;

public class GroupProvider
implements class_2405 {
    public static final Set<PaletteBlockPattern> EXTENDABLE_PATTERNS = Set.of(PaletteBlockPattern.CUT, PaletteBlockPattern.POLISHED, PaletteBlockPattern.BRICKS, PaletteBlockPattern.SMALL_BRICKS);
    private final FabricDataOutput out;
    public final List<ArchExGroup> groups;

    public GroupProvider(FabricDataOutput out) {
        this.out = out;
        this.groups = this.generateGroups();
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 output) {
        Path outputDir = this.out.method_45971().resolve("staticdata").resolve("architecture_extensions");
        ArrayList saveFutures = new ArrayList();
        this.groups.forEach(group -> {
            JsonObject json = group.toJson();
            Path outputFile = outputDir.resolve(group.name() + ".json");
            CompletableFuture future = class_2405.method_10320((class_7403)output, (JsonElement)json, (Path)outputFile);
            saveFutures.add(future);
        });
        return CompletableFuture.allOf((CompletableFuture[])saveFutures.toArray(CompletableFuture[]::new));
    }

    private List<ArchExGroup> generateGroups() {
        ArrayList<ArchExGroup> groups = new ArrayList<ArchExGroup>();
        for (AllPaletteStoneTypes stoneType : AllPaletteStoneTypes.values()) {
            for (PaletteBlockPattern blockPattern : stoneType.variantTypes) {
                if (!EXTENDABLE_PATTERNS.contains(blockPattern)) continue;
                ArchExGroup group = ArchExGroup.builder().fromStoneTypeAndPattern(stoneType, blockPattern).build();
                groups.add(group);
            }
        }
        return groups;
    }

    @NotNull
    public String method_10321() {
        return "Create's ArchEx compat";
    }
}

