/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.clock;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.clock.CuckooClockBlock;
import com.simibubi.create.content.kinetics.clock.CuckooClockBlockEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class CuckooClockRenderer
extends KineticBlockEntityRenderer<CuckooClockBlockEntity> {
    public CuckooClockRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(CuckooClockBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        if (!(be instanceof CuckooClockBlockEntity)) {
            return;
        }
        class_2680 blockState = be.method_11010();
        class_2350 direction = (class_2350)blockState.method_11654(CuckooClockBlock.HORIZONTAL_FACING);
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        SuperByteBuffer hourHand = CachedBufferer.partial(AllPartialModels.CUCKOO_HOUR_HAND, blockState);
        SuperByteBuffer minuteHand = CachedBufferer.partial(AllPartialModels.CUCKOO_MINUTE_HAND, blockState);
        float hourAngle = be.hourHand.getValue(partialTicks);
        float minuteAngle = be.minuteHand.getValue(partialTicks);
        this.rotateHand(hourHand, hourAngle, direction).light(light).renderInto(ms, vb);
        this.rotateHand(minuteHand, minuteAngle, direction).light(light).renderInto(ms, vb);
        SuperByteBuffer leftDoor = CachedBufferer.partial(AllPartialModels.CUCKOO_LEFT_DOOR, blockState);
        SuperByteBuffer rightDoor = CachedBufferer.partial(AllPartialModels.CUCKOO_RIGHT_DOOR, blockState);
        float angle = 0.0f;
        float offset = 0.0f;
        if (be.animationType != null) {
            float value = be.animationProgress.getValue(partialTicks);
            int step = be.animationType == CuckooClockBlockEntity.Animation.SURPRISE ? 3 : 15;
            for (int phase = 30; phase <= 60; phase += step) {
                float local = value - (float)phase;
                if (local < (float)(-step / 3)) continue;
                if (local < 0.0f) {
                    angle = class_3532.method_16439((float)((value - (float)(phase - 5)) / 5.0f), (float)0.0f, (float)135.0f);
                    continue;
                }
                if (local < (float)(step / 3)) {
                    angle = 135.0f;
                    continue;
                }
                if (!(local < (float)(2 * step / 3))) continue;
                angle = class_3532.method_16439((float)((value - (float)(phase + 5)) / 5.0f), (float)135.0f, (float)0.0f);
            }
        }
        this.rotateDoor(leftDoor, angle, true, direction).light(light).renderInto(ms, vb);
        this.rotateDoor(rightDoor, angle, false, direction).light(light).renderInto(ms, vb);
        if (be.animationType != CuckooClockBlockEntity.Animation.NONE) {
            offset = -(angle / 135.0f) * 1.0f / 2.0f + 0.625f;
            PartialModel partialModel = be.animationType == CuckooClockBlockEntity.Animation.PIG ? AllPartialModels.CUCKOO_PIG : AllPartialModels.CUCKOO_CREEPER;
            SuperByteBuffer figure = CachedBufferer.partial(partialModel, blockState);
            figure.rotateCentered(class_2350.field_11036, AngleHelper.rad(AngleHelper.horizontalAngle(direction.method_10160())));
            figure.translate(offset, 0.0, 0.0);
            figure.light(light).renderInto(ms, vb);
        }
    }

    @Override
    protected SuperByteBuffer getRotatedModel(CuckooClockBlockEntity be, class_2680 state) {
        return CachedBufferer.partialFacing(AllPartialModels.SHAFT_HALF, state, ((class_2350)state.method_11654(CuckooClockBlock.HORIZONTAL_FACING)).method_10153());
    }

    private SuperByteBuffer rotateHand(SuperByteBuffer buffer, float angle, class_2350 facing) {
        float pivotX = 0.125f;
        float pivotY = 0.375f;
        float pivotZ = 0.5f;
        buffer.rotateCentered(class_2350.field_11036, AngleHelper.rad(AngleHelper.horizontalAngle(facing.method_10160())));
        buffer.translate(pivotX, pivotY, pivotZ);
        buffer.rotate(class_2350.field_11034, AngleHelper.rad(angle));
        buffer.translate(-pivotX, -pivotY, -pivotZ);
        return buffer;
    }

    private SuperByteBuffer rotateDoor(SuperByteBuffer buffer, float angle, boolean left, class_2350 facing) {
        float pivotX = 0.125f;
        float pivotY = 0.0f;
        float pivotZ = (float)(left ? 6 : 10) / 16.0f;
        buffer.rotateCentered(class_2350.field_11036, AngleHelper.rad(AngleHelper.horizontalAngle(facing.method_10160())));
        buffer.translate(pivotX, pivotY, pivotZ);
        buffer.rotate(class_2350.field_11036, AngleHelper.rad(angle) * (float)(left ? -1 : 1));
        buffer.translate(-pivotX, -pivotY, -pivotZ);
        return buffer;
    }
}

