/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.jozufozu.flywheel.api.MaterialManager;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeyInstance;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class CarriageBogey {
    public static final String UPSIDE_DOWN_KEY = "UpsideDown";
    public Carriage carriage;
    boolean isLeading;
    public class_2487 bogeyData;
    AbstractBogeyBlock<?> type;
    boolean upsideDown;
    Couple<TravellingPoint> points;
    LerpedFloat wheelAngle;
    LerpedFloat yaw;
    LerpedFloat pitch;
    public Couple<class_243> couplingAnchors;
    int derailAngle;

    public CarriageBogey(AbstractBogeyBlock<?> type, boolean upsideDown, class_2487 bogeyData, TravellingPoint point, TravellingPoint point2) {
        this.type = type;
        point.upsideDown = this.upsideDown = type.canBeUpsideDown() && upsideDown;
        point2.upsideDown = this.upsideDown;
        if (bogeyData == null || bogeyData.method_33133()) {
            bogeyData = this.createBogeyData();
        }
        bogeyData.method_10556(UPSIDE_DOWN_KEY, upsideDown);
        this.bogeyData = bogeyData;
        this.points = Couple.create(point, point2);
        this.wheelAngle = LerpedFloat.angular();
        this.yaw = LerpedFloat.angular();
        this.pitch = LerpedFloat.angular();
        this.derailAngle = Create.RANDOM.nextInt(60) - 30;
        this.couplingAnchors = Couple.create(null, null);
    }

    public class_5321<class_1937> getDimension() {
        TravellingPoint leading = this.leading();
        TravellingPoint trailing = this.trailing();
        if (leading.edge == null || trailing.edge == null) {
            return null;
        }
        if (leading.edge.isInterDimensional() || trailing.edge.isInterDimensional()) {
            return null;
        }
        class_5321<class_1937> dimension1 = leading.node1.getLocation().dimension;
        class_5321<class_1937> dimension2 = trailing.node1.getLocation().dimension;
        if (dimension1.equals(dimension2)) {
            return dimension1;
        }
        return null;
    }

    public void updateAngles(CarriageContraptionEntity entity, double distanceMoved) {
        double angleDiff = 360.0 * distanceMoved / (Math.PI * 2 * this.type.getWheelRadius());
        float xRot = 0.0f;
        float yRot = 0.0f;
        if (this.leading().edge == null || this.carriage.train.derailed) {
            yRot = -90.0f + entity.yaw - (float)this.derailAngle;
        } else if (!entity.method_37908().method_27983().equals(this.getDimension())) {
            yRot = -90.0f + entity.yaw;
            xRot = 0.0f;
        } else {
            class_243 positionVec = this.leading().getPosition(this.carriage.train.graph);
            class_243 coupledVec = this.trailing().getPosition(this.carriage.train.graph);
            double diffX = positionVec.field_1352 - coupledVec.field_1352;
            double diffY = positionVec.field_1351 - coupledVec.field_1351;
            double diffZ = positionVec.field_1350 - coupledVec.field_1350;
            yRot = AngleHelper.deg(class_3532.method_15349((double)diffZ, (double)diffX)) + 90.0f;
            xRot = AngleHelper.deg(Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)));
        }
        double newWheelAngle = ((double)this.wheelAngle.getValue() - angleDiff) % 360.0;
        for (boolean twice : Iterate.trueAndFalse) {
            if (twice && !entity.firstPositionUpdate) continue;
            this.wheelAngle.setValue(newWheelAngle);
            this.pitch.setValue(xRot);
            this.yaw.setValue(-yRot);
        }
    }

    public TravellingPoint leading() {
        TravellingPoint point = (TravellingPoint)this.points.getFirst();
        point.upsideDown = this.isUpsideDown();
        return point;
    }

    public TravellingPoint trailing() {
        TravellingPoint point = (TravellingPoint)this.points.getSecond();
        point.upsideDown = this.isUpsideDown();
        return point;
    }

    public double getStress() {
        if (this.getDimension() == null) {
            return 0.0;
        }
        if (this.carriage.train.derailed) {
            return 0.0;
        }
        return this.type.getWheelPointSpacing() - this.leading().getPosition(this.carriage.train.graph).method_1022(this.trailing().getPosition(this.carriage.train.graph));
    }

    @Nullable
    public class_243 getAnchorPosition() {
        return this.getAnchorPosition(false);
    }

    @Nullable
    public class_243 getAnchorPosition(boolean flipUpsideDown) {
        if (this.leading().edge == null) {
            return null;
        }
        return ((TravellingPoint)this.points.getFirst()).getPosition(this.carriage.train.graph, flipUpsideDown).method_1019(((TravellingPoint)this.points.getSecond()).getPosition(this.carriage.train.graph, flipUpsideDown)).method_1021(0.5);
    }

    public void updateCouplingAnchor(class_243 entityPos, float entityXRot, float entityYRot, int bogeySpacing, float partialTicks, boolean leading) {
        boolean selfUpsideDown = this.isUpsideDown();
        boolean leadingUpsideDown = this.carriage.leadingBogey().isUpsideDown();
        class_243 thisOffset = this.type.getConnectorAnchorOffset(selfUpsideDown);
        thisOffset = thisOffset.method_18805(1.0, 1.0, leading ? -1.0 : 1.0);
        thisOffset = VecHelper.rotate(thisOffset, this.pitch.getValue(partialTicks), class_2350.class_2351.field_11048);
        thisOffset = VecHelper.rotate(thisOffset, this.yaw.getValue(partialTicks), class_2350.class_2351.field_11052);
        thisOffset = VecHelper.rotate(thisOffset, -entityYRot - 90.0f, class_2350.class_2351.field_11052);
        thisOffset = VecHelper.rotate(thisOffset, entityXRot, class_2350.class_2351.field_11048);
        thisOffset = VecHelper.rotate(thisOffset, -180.0, class_2350.class_2351.field_11052);
        thisOffset = thisOffset.method_1031(0.0, 0.0, leading ? 0.0 : (double)(-bogeySpacing));
        thisOffset = VecHelper.rotate(thisOffset, 180.0, class_2350.class_2351.field_11052);
        thisOffset = VecHelper.rotate(thisOffset, -entityXRot, class_2350.class_2351.field_11048);
        thisOffset = VecHelper.rotate(thisOffset, entityYRot + 90.0f, class_2350.class_2351.field_11052);
        if (selfUpsideDown != leadingUpsideDown) {
            thisOffset = thisOffset.method_1031(0.0, selfUpsideDown ? -2.0 : 2.0, 0.0);
        }
        this.couplingAnchors.set(leading, entityPos.method_1019(thisOffset));
    }

    public class_2487 write(DimensionPalette dimensions) {
        class_2487 tag = new class_2487();
        tag.method_10582("Type", RegisteredObjects.getKeyOrThrow(this.type).toString());
        tag.method_10566("Points", (class_2520)this.points.serializeEach(tp -> tp.write(dimensions)));
        tag.method_10556(UPSIDE_DOWN_KEY, this.upsideDown);
        this.bogeyData.method_10556(UPSIDE_DOWN_KEY, this.upsideDown);
        NBTHelper.writeResourceLocation(this.bogeyData, "BogeyStyle", this.getStyle().name);
        tag.method_10566("BogeyData", (class_2520)this.bogeyData);
        return tag;
    }

    public static CarriageBogey read(class_2487 tag, TrackGraph graph, DimensionPalette dimensions) {
        AbstractBogeyBlock bogey;
        class_2960 location = new class_2960(tag.method_10558("Type"));
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(location);
        AbstractBogeyBlock type = block instanceof AbstractBogeyBlock ? (bogey = (AbstractBogeyBlock)block) : (AbstractBogeyBlock)AllBlocks.SMALL_BOGEY.get();
        boolean upsideDown = tag.method_10577(UPSIDE_DOWN_KEY);
        Couple<TravellingPoint> points = Couple.deserializeEach(tag.method_10554("Points", 10), c -> TravellingPoint.read(c, graph, dimensions));
        class_2487 data = tag.method_10562("BogeyData");
        return new CarriageBogey(type, upsideDown, data, (TravellingPoint)points.getFirst(), (TravellingPoint)points.getSecond());
    }

    public BogeyInstance createInstance(MaterialManager materialManager) {
        return this.getStyle().createInstance(this, this.type.getSize(), materialManager);
    }

    public BogeyStyle getStyle() {
        class_2960 location = NBTHelper.readResourceLocation(this.bogeyData, "BogeyStyle");
        BogeyStyle style = AllBogeyStyles.BOGEY_STYLES.get(location);
        return style != null ? style : AllBogeyStyles.STANDARD;
    }

    private class_2487 createBogeyData() {
        BogeyStyle style = this.type != null ? this.type.getDefaultStyle() : AllBogeyStyles.STANDARD;
        class_2487 nbt = style.defaultData != null ? style.defaultData : new class_2487();
        NBTHelper.writeResourceLocation(nbt, "BogeyStyle", style.name);
        nbt.method_10556(UPSIDE_DOWN_KEY, this.isUpsideDown());
        return nbt;
    }

    void setLeading() {
        this.isLeading = true;
    }

    public boolean isUpsideDown() {
        return this.type.canBeUpsideDown() && this.upsideDown;
    }
}

